/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public abstract class ExecutingControler {
    private boolean executing;
    private boolean canceling;
    private ExecutingControlSwitch executingControlSwitch;
    private List controls = new ArrayList();

    public void finishedExecute() {
    }

    public void execute() {
        this.executing = true;
        this.canceling = false;
        this.executingControlSwitch.updateCancelMode();
        this.disableControls();
        this.beforeExecute();
        new InExecute().start();
    }

    public void updateControlSwitch() {
        if (this.canExecute()) {
            this.executingControlSwitch.setEnabled(true);
        } else {
            this.executingControlSwitch.setEnabled(false);
        }
    }

    public abstract boolean canExecute();

    public abstract void afterExecute();

    public abstract void beforeExecute();

    public abstract void inExecute();

    public abstract void cancelExecuting();

    public void finishExecute() {
        this.executing = false;
        this.executingControlSwitch.updateExecuteMode();
        this.enableControls();
    }

    public void canceldExecute() {
        this.canceling = true;
        this.cancelExecuting();
        this.executing = false;
        this.executingControlSwitch.updateExecuteMode();
        this.enableControls();
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void setExecuting(boolean executing) {
        this.executing = executing;
    }

    public void addControl(Control control) {
        this.controls.add(control);
    }

    public void enableControls() {
        for (Control control : this.controls) {
            control.setEnabled(true);
        }
    }

    public void disableControls() {
        for (Control control : this.controls) {
            control.setEnabled(false);
        }
    }

    public boolean isCanceling() {
        return this.canceling;
    }

    public void setCanceling(boolean canceling) {
        this.canceling = canceling;
    }

    public ExecutingControlSwitch getExecutingControlSwitch() {
        return this.executingControlSwitch;
    }

    public void setExecutingControlSwitch(ExecutingControlSwitch executingControlSwitch) {
        this.executingControlSwitch = executingControlSwitch;
    }

    public class InExecute
    extends Thread {
        public void run() {
            ExecutingControler.this.inExecute();
            if (!ExecutingControler.this.canceling) {
                PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new FinishExecute());
            }
        }
    }

    public class CancelExecute
    extends Thread {
        public void run() {
            ExecutingControler.this.canceldExecute();
        }
    }

    public class FinishExecute
    extends Thread {
        public void run() {
            ExecutingControler.this.afterExecute();
            ExecutingControler.this.finishExecute();
        }
    }

    public class UpdateControlSwitch
    extends Thread {
        public void run() {
            ExecutingControler.this.updateControlSwitch();
        }
    }

    public static interface ExecutingControlSwitch {
        public void setEnabled(boolean var1);

        public void updateExecuteMode();

        public void updateCancelMode();
    }

    public static class ExecutingControlButton
    extends Composite
    implements ExecutingControlSwitch {
        private ExecutingControler controler;
        private String executeLabel;
        private String cancelLabel;
        private Button button;

        public ExecutingControlButton(Composite arg0, int arg1, ExecutingControler controler, String executeLabel, String cancelLabel) {
            super(arg0, arg1);
            this.setLayout((Layout)new FillLayout());
            this.button = new Button((Composite)this, 0);
            this.cancelLabel = cancelLabel;
            this.executeLabel = executeLabel;
            this.controler = controler;
            this.button.setText(executeLabel);
            this.setEnabled(false);
            controler.setExecutingControlSwitch(this);
            this.button.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (ExecutingControlButton.this.getControler().isExecuting()) {
                        ExecutingControlButton.this.getControler().canceldExecute();
                    } else {
                        ExecutingControlButton.this.getControler().execute();
                    }
                }
            });
        }

        public void setEnabled(boolean bool) {
            super.setEnabled(bool);
            this.button.setEnabled(bool);
        }

        public String getCancelLabel() {
            return this.cancelLabel;
        }

        public void setCancelLabel(String cancelLabel) {
            this.cancelLabel = cancelLabel;
        }

        public ExecutingControler getControler() {
            return this.controler;
        }

        public void setControler(ExecutingControler controler) {
            this.controler = controler;
        }

        public String getExecuteLabel() {
            return this.executeLabel;
        }

        public void setExecuteLabel(String executeLabel) {
            this.executeLabel = executeLabel;
        }

        public void updateCancelMode() {
            this.button.setText(this.cancelLabel);
        }

        public void updateExecuteMode() {
            this.button.setText(this.executeLabel);
        }
    }
}

