/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import java.io.File;
import jp.sourceforge.akjrcp.util.FileSizeListener;

public class FileSizeMonitor
extends Thread {
    private long maxSize;
    private int step;
    private boolean running;
    private File file;
    private int sleepTime = 100;
    private FileSizeListener listener;

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void stopMonitor() {
        this.running = false;
    }

    public void startMonitor() {
        this.running = true;
        this.start();
    }

    public void run() {
        long persize = this.maxSize / (long)this.step;
        long current = 0L;
        while (this.running) {
            if (this.file == null) break;
            long size = this.file.length();
            long v = size / persize;
            if (size >= this.maxSize) {
                this.listener.done((int)((long)this.step - current));
                break;
            }
            if (v > current) {
                this.listener.stepped((int)(v - current));
                current = v;
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.running = false;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public FileSizeListener getListener() {
        return this.listener;
    }

    public void setListener(FileSizeListener listener) {
        this.listener = listener;
    }
}

