/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.videotools;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class BitrateViewCanvas
extends Canvas {
    int mpixel = 18;
    int bitpixel = 6;
    private int[] bitrates1;
    private int[] bitrates2;
    private int dx = 50;
    private int dy = 15;
    private int maxMinute = 60;

    public BitrateViewCanvas(Composite arg0, int arg1) {
        super(arg0, arg1);
        this.addPaintListener(new Painter());
        this.init(0);
        this.init(1);
    }

    public void init(int index) {
        if (index == 0) {
            this.bitrates1 = new int[this.mpixel * this.maxMinute];
        } else {
            this.bitrates2 = new int[this.mpixel * this.maxMinute];
        }
    }

    private int toY(int bps) {
        int pixel = bps * this.bitpixel / 100;
        int ret = this.getClientArea().height - this.dy - pixel;
        return ret;
    }

    public void setData(int index, double second, double kbps) {
        int[] targetArray = index == 0 ? this.bitrates1 : this.bitrates2;
        int x = (int)(second * (double)this.mpixel / 60.0);
        if (x > 0 && x < targetArray.length && kbps > (double)targetArray[x]) {
            targetArray[x] = (int)kbps;
        }
    }

    public void drawDatas(GC gc, int index) {
        int[] datas = index == 0 ? this.bitrates1 : this.bitrates2;
        int x = 0;
        while (x < datas.length) {
            if (datas[x] > 0) {
                int y1 = this.toY(datas[x]);
                int x2 = 0;
                int y2 = 0;
                int j = x + 1;
                while (j < datas.length) {
                    if (datas[j] > 0) {
                        x2 = j;
                        y2 = this.toY(datas[x2]);
                        gc.drawLine(this.dx + x, y1, this.dx + x2, y2);
                        x = x2 - 1;
                        break;
                    }
                    ++j;
                }
                if (x2 == 0) break;
            }
            ++x;
        }
    }

    public int getMaxMinute() {
        return this.maxMinute;
    }

    public void setMaxMinute(int maxMinute) {
        this.maxMinute = maxMinute;
    }

    public int getMpixel() {
        return this.mpixel;
    }

    public void setMpixel(int mpixel) {
        this.mpixel = mpixel;
    }

    public class Painter
    implements PaintListener {
        public void paintControl(PaintEvent e) {
            int y0 = BitrateViewCanvas.this.getClientArea().height - BitrateViewCanvas.this.dy;
            e.gc.setForeground(new Color(null, 0, 0, 0));
            e.gc.drawLine(BitrateViewCanvas.this.dx, y0, BitrateViewCanvas.this.dx, 0);
            e.gc.drawLine(BitrateViewCanvas.this.dx, y0, BitrateViewCanvas.this.dx + BitrateViewCanvas.this.mpixel * BitrateViewCanvas.this.maxMinute, y0);
            int i = 0;
            while (i <= BitrateViewCanvas.this.maxMinute) {
                int x = BitrateViewCanvas.this.dx + i * BitrateViewCanvas.this.mpixel;
                if (i % 15 == 0) {
                    e.gc.drawLine(x, y0, x, y0 - 5);
                    e.gc.drawText("" + i, x - 5, y0 + 2);
                } else {
                    e.gc.drawLine(x, y0, x, y0 - 2);
                }
                i += 5;
            }
            i = 1;
            while (i <= 22) {
                int y = y0 - i * 5 * BitrateViewCanvas.this.bitpixel;
                if (i % 2 == 0) {
                    e.gc.setForeground(new Color(null, 240, 240, 240));
                    e.gc.drawLine(BitrateViewCanvas.this.dx, y, BitrateViewCanvas.this.dx + BitrateViewCanvas.this.mpixel * BitrateViewCanvas.this.maxMinute, y);
                    e.gc.setForeground(new Color(null, 0, 0, 0));
                    e.gc.drawLine(BitrateViewCanvas.this.dx, y, BitrateViewCanvas.this.dx + 5, y);
                    e.gc.drawText(i * 500 + "k", 0, y - 5);
                } else {
                    e.gc.drawLine(BitrateViewCanvas.this.dx, y, BitrateViewCanvas.this.dx + 3, y);
                }
                ++i;
            }
            e.gc.setForeground(new Color(null, 255, 0, 0));
            BitrateViewCanvas.this.drawDatas(e.gc, 0);
            e.gc.setForeground(new Color(null, 0, 0, 255));
            BitrateViewCanvas.this.drawDatas(e.gc, 1);
        }
    }
}

