/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.lib.commons.preset;

import com.akjava.lib.commons.preset.DefaultPreSetIO;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PreSet {
    public static Log log = LogFactory.getLog(PreSet.class);
    private Map<String, String> parameters = new HashMap<String, String>();
    public static String PARAM_NAME = "#name";
    public static String PARAM_COMMENT = "#comment";

    public PreSet() {
    }

    public PreSet(Map<String, String> parameters) {
        this();
        this.setParameters(parameters);
    }

    public void remove(String key) {
        this.parameters.remove(key);
    }

    public void setValue(String key, String value) {
        if (PreSet.isCSVHeaderKey(key)) {
            value = DefaultPreSetIO.restoreCharacters(value);
        }
        this.parameters.put(key, value);
    }

    public String getComment() {
        String value = this.parameters.get(PARAM_COMMENT);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setComment(String comment) {
        this.parameters.put(PARAM_COMMENT, comment);
    }

    public String getName() {
        String value = this.parameters.get(PARAM_NAME);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setName(String name) {
        this.parameters.put(PARAM_NAME, name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getValue(String key) {
        return this.parameters.get(key);
    }

    public String toString() {
        String ret = "#NAME=" + this.getName() + "\n";
        ret = String.valueOf(ret) + "#COMMENT=" + this.getComment() + "\n";
        Object[] names = this.parameters.keySet().toArray(new String[0]);
        Arrays.sort(names);
        int i = 0;
        while (i < names.length) {
            if (!PreSet.isCSVHeaderKey((String)names[i])) {
                ret = String.valueOf(ret) + (String)names[i] + "=" + this.parameters.get(names[i]) + "\n";
            }
            ++i;
        }
        return ret;
    }

    static boolean isCSVHeaderKey(String key) {
        return PARAM_NAME.equals(key) || PARAM_COMMENT.equals(key);
    }
}

