/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.lib.commons.time;

import com.akjava.lib.commons.text.TextUtils;
import java.math.BigDecimal;

public class TimeUtils {
    private static final String MS_REPLACE = "__N_N_A_A__";

    public static String toTimeText(long millisecond) {
        return TimeUtils.toTimeText(millisecond, true, true, true, true);
    }

    public static long toMillisecond(int[] times) {
        if (times.length != 4) {
            return 0L;
        }
        return TimeUtils.toMillisecond(times[0], times[1], times[2], times[3]);
    }

    public static long toMillisecond(int hour, int minute, int second, int millisecond) {
        long ret = 0L;
        ret += (long)(hour * 60 * 60 * 1000);
        ret += (long)(minute * 60 * 1000);
        ret += (long)(second * 1000);
        return ret += (long)millisecond;
    }

    public static long toMillisecond(String text, boolean isShortMillisecond) {
        int[] vs = TimeUtils.toHourMinSecMilliSecond(text);
        if (vs == null) {
            return 0L;
        }
        if (isShortMillisecond) {
            vs[3] = vs[3] * 10;
        }
        return TimeUtils.toMillisecond(vs[0], vs[1], vs[2], vs[3]);
    }

    public static long toMillisecond(String text) {
        return TimeUtils.toMillisecond(text, false);
    }

    private static int[] wordToHourMinSecMilliSecond(String word) {
        String timeText;
        int[] ret = new int[4];
        String wordText = word.replace(" ", "");
        wordText = wordText.replace("\t", "");
        wordText = wordText.replace("\r", "");
        wordText = wordText.replace("\n", "");
        wordText = wordText.replace("ms", MS_REPLACE);
        int index = (wordText = wordText.replace("MS", MS_REPLACE)).toLowerCase().indexOf("h");
        if (index != -1) {
            String hourText = wordText.substring(0, index);
            if (!TextUtils.isDigitOnly(hourText)) {
                return ret;
            }
            ret[0] = Integer.parseInt(hourText);
            wordText = wordText.substring(index + 1);
        }
        if ((index = wordText.toLowerCase().indexOf("m")) != -1) {
            timeText = wordText.substring(0, index);
            if (!TextUtils.isDigitOnly(timeText)) {
                return ret;
            }
            ret[1] = Integer.parseInt(timeText);
            wordText = wordText.substring(index + 1);
        }
        if ((index = wordText.toLowerCase().indexOf("s")) != -1) {
            timeText = wordText.substring(0, index);
            if (!TextUtils.isDigitOnly(timeText)) {
                return ret;
            }
            ret[2] = Integer.parseInt(timeText);
            wordText = wordText.substring(index + 1);
        }
        if ((index = wordText.indexOf(MS_REPLACE)) != -1) {
            timeText = wordText.substring(0, index);
            if (!TextUtils.isDigitOnly(timeText)) {
                return ret;
            }
            ret[3] = Integer.parseInt(timeText);
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] toHourMinSecMilliSecond(String text) {
        if (text.toLowerCase().indexOf("h") != -1 || text.toLowerCase().indexOf("m") != -1 || text.toLowerCase().indexOf("s") != -1) {
            return TimeUtils.wordToHourMinSecMilliSecond(text);
        }
        int[] ret = new int[4];
        String[] values = text.split(":");
        if (values.length > 3) {
            if (values.length != 4) return null;
            String[] tmp = values;
            values = new String[]{tmp[0], tmp[1], String.valueOf(tmp[2]) + "." + tmp[3]};
        }
        if (values[values.length - 1].indexOf(".") != -1) {
            String[] sec_milli = values[values.length - 1].split("\\.");
            if (sec_milli.length != 2) {
                return null;
            }
            if (!TextUtils.isDigitOnly(sec_milli[0]) || !TextUtils.isDigitOnly(sec_milli[1])) return null;
            values[values.length - 1] = sec_milli[0];
            ret[3] = Integer.parseInt(sec_milli[1]);
        }
        if (values.length == 1) {
            if (!TextUtils.isDigitOnly(values[0])) return null;
            ret[2] = Integer.parseInt(values[0]);
            return ret;
        } else if (values.length == 2) {
            if (!TextUtils.isDigitOnly(values[0]) || !TextUtils.isDigitOnly(values[1])) return ret;
            ret[2] = Integer.parseInt(values[1]);
            ret[1] = Integer.parseInt(values[0]);
            return ret;
        } else {
            if (values.length != 3 || !TextUtils.isDigitOnly(values[0]) || !TextUtils.isDigitOnly(values[1]) || !TextUtils.isDigitOnly(values[2])) return ret;
            ret[2] = Integer.parseInt(values[2]);
            ret[1] = Integer.parseInt(values[1]);
            ret[0] = Integer.parseInt(values[0]);
        }
        return ret;
    }

    public static boolean isTimeText(String text) {
        return TimeUtils.toHourMinSecMilliSecond(text) != null;
    }

    public static String toTimeText(long millisecond, boolean showHour, boolean showMinute, boolean showSecond, boolean showMilliSecond) {
        long hour_millisecond = 3600000L;
        int minute_millisecond = 60000;
        int second_millisecond = 1000;
        int hour = (int)(millisecond / hour_millisecond);
        long remain = millisecond % hour_millisecond;
        int minute = (int)(remain / (long)minute_millisecond);
        int second = (int)((remain %= (long)minute_millisecond) / (long)second_millisecond);
        remain %= (long)second_millisecond;
        String ret = "";
        if (showHour) {
            ret = String.valueOf(ret) + TimeUtils.toLabel2(hour) + ":";
            if (!showMinute) {
                ret = String.valueOf(ret) + "00:";
                if (!showSecond) {
                    ret = String.valueOf(ret) + "00";
                }
            }
        }
        if (showMinute) {
            ret = String.valueOf(ret) + TimeUtils.toLabel2(minute) + ":";
            if (!showSecond) {
                ret = String.valueOf(ret) + "00";
            }
        }
        if (showSecond) {
            ret = String.valueOf(ret) + TimeUtils.toLabel2(second);
        }
        if (showMilliSecond) {
            ret = String.valueOf(ret) + ".";
            ret = String.valueOf(ret) + TimeUtils.toLabel3((int)remain);
        }
        return ret;
    }

    private static String toLabel2(int number) {
        String v = "" + number;
        if (v.length() < 2) {
            v = "0" + v;
        }
        return v;
    }

    private static String toLabel3(int number) {
        String v = "" + number;
        if (v.length() < 2) {
            v = "0" + v;
        }
        if (v.length() < 3) {
            v = "0" + v;
        }
        if (v.length() > 3) {
            return "000";
        }
        return v;
    }

    public static double toBigDecimalTime(double tim1) {
        try {
            BigDecimal ret = new BigDecimal(tim1);
            return ret.setScale(3, 4).doubleValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }
}

