/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.actions.BuildSetMenu;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;
import org.eclipse.ui.internal.ide.actions.QuickMenuAction;
import org.eclipse.ui.internal.ide.actions.RetargetActionWithDefault;
import org.eclipse.ui.internal.provisional.application.IActionBarConfigurer2;
import org.eclipse.ui.internal.util.StatusLineContributionItem;
import org.eclipse.ui.menus.IMenuService;

public final class WorkbenchActionBuilder
extends ActionBarAdvisor {
    private final IWorkbenchWindow window;
    private ActionFactory.IWorkbenchAction closeAction;
    private ActionFactory.IWorkbenchAction closeAllAction;
    private ActionFactory.IWorkbenchAction closeOthersAction;
    private ActionFactory.IWorkbenchAction closeAllSavedAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAllAction;
    private ActionFactory.IWorkbenchAction newWindowAction;
    private ActionFactory.IWorkbenchAction newEditorAction;
    private ActionFactory.IWorkbenchAction helpContentsAction;
    private ActionFactory.IWorkbenchAction helpSearchAction;
    private ActionFactory.IWorkbenchAction dynamicHelpAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private ActionFactory.IWorkbenchAction openPreferencesAction;
    private ActionFactory.IWorkbenchAction saveAsAction;
    private ActionFactory.IWorkbenchAction hideShowEditorAction;
    private ActionFactory.IWorkbenchAction savePerspectiveAction;
    private ActionFactory.IWorkbenchAction resetPerspectiveAction;
    private ActionFactory.IWorkbenchAction editActionSetAction;
    private ActionFactory.IWorkbenchAction closePerspAction;
    private ActionFactory.IWorkbenchAction lockToolBarAction;
    private ActionFactory.IWorkbenchAction closeAllPerspsAction;
    private ActionFactory.IWorkbenchAction showViewMenuAction;
    private ActionFactory.IWorkbenchAction showPartPaneMenuAction;
    private ActionFactory.IWorkbenchAction nextPartAction;
    private ActionFactory.IWorkbenchAction prevPartAction;
    private ActionFactory.IWorkbenchAction nextEditorAction;
    private ActionFactory.IWorkbenchAction prevEditorAction;
    private ActionFactory.IWorkbenchAction nextPerspectiveAction;
    private ActionFactory.IWorkbenchAction prevPerspectiveAction;
    private ActionFactory.IWorkbenchAction activateEditorAction;
    private ActionFactory.IWorkbenchAction maximizePartAction;
    private ActionFactory.IWorkbenchAction minimizePartAction;
    private ActionFactory.IWorkbenchAction switchToEditorAction;
    private ActionFactory.IWorkbenchAction workbookEditorsAction;
    private ActionFactory.IWorkbenchAction quickAccessAction;
    private ActionFactory.IWorkbenchAction backwardHistoryAction;
    private ActionFactory.IWorkbenchAction forwardHistoryAction;
    private ActionFactory.IWorkbenchAction undoAction;
    private ActionFactory.IWorkbenchAction redoAction;
    private ActionFactory.IWorkbenchAction cutAction;
    private ActionFactory.IWorkbenchAction copyAction;
    private ActionFactory.IWorkbenchAction pasteAction;
    private ActionFactory.IWorkbenchAction deleteAction;
    private ActionFactory.IWorkbenchAction selectAllAction;
    private ActionFactory.IWorkbenchAction findAction;
    private ActionFactory.IWorkbenchAction printAction;
    private ActionFactory.IWorkbenchAction revertAction;
    private ActionFactory.IWorkbenchAction refreshAction;
    private ActionFactory.IWorkbenchAction propertiesAction;
    private ActionFactory.IWorkbenchAction quitAction;
    private ActionFactory.IWorkbenchAction moveAction;
    private ActionFactory.IWorkbenchAction renameAction;
    private ActionFactory.IWorkbenchAction goIntoAction;
    private ActionFactory.IWorkbenchAction backAction;
    private ActionFactory.IWorkbenchAction forwardAction;
    private ActionFactory.IWorkbenchAction upAction;
    private ActionFactory.IWorkbenchAction nextAction;
    private ActionFactory.IWorkbenchAction previousAction;
    private ActionFactory.IWorkbenchAction openWorkspaceAction;
    private ActionFactory.IWorkbenchAction projectPropertyDialogAction;
    private ActionFactory.IWorkbenchAction newWizardAction;
    private ActionFactory.IWorkbenchAction newWizardDropDownAction;
    private ActionFactory.IWorkbenchAction importResourcesAction;
    private ActionFactory.IWorkbenchAction exportResourcesAction;
    ActionFactory.IWorkbenchAction buildAllAction;
    private ActionFactory.IWorkbenchAction cleanAction;
    private ActionFactory.IWorkbenchAction toggleAutoBuildAction;
    MenuManager buildWorkingSetMenu;
    private ActionFactory.IWorkbenchAction quickStartAction;
    private ActionFactory.IWorkbenchAction tipsAndTricksAction;
    private QuickMenuAction showInQuickMenu;
    private QuickMenuAction newQuickMenu;
    private ActionFactory.IWorkbenchAction introAction;
    private ActionFactory.IWorkbenchAction addBookmarkAction;
    private ActionFactory.IWorkbenchAction addTaskAction;
    ActionFactory.IWorkbenchAction buildProjectAction;
    private ActionFactory.IWorkbenchAction openProjectAction;
    private ActionFactory.IWorkbenchAction closeProjectAction;
    private NewWizardMenu newWizardMenu;
    private IContributionItem pinEditorContributionItem;
    private StatusLineContributionItem statusLineItem;
    private Preferences.IPropertyChangeListener prefListener;
    private IPropertyChangeListener propPrefListener;
    private IPageListener pageListener;
    private IResourceChangeListener resourceListener;
    private boolean isDisposed = false;
    private MenuManager coolbarPopupMenuManager;
    static /* synthetic */ Class class$0;

    public WorkbenchActionBuilder(IActionBarConfigurer configurer) {
        super(configurer);
        this.window = configurer.getWindowConfigurer().getWindow();
    }

    private IWorkbenchWindow getWindow() {
        return this.window;
    }

    private void hookListeners() {
        this.pageListener = new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
            }

            public void pageClosed(IWorkbenchPage page) {
            }

            public void pageOpened(IWorkbenchPage page) {
                BuildAction buildHandler = new BuildAction(page.getWorkbenchWindow().getShell(), 10);
                ((RetargetActionWithDefault)WorkbenchActionBuilder.this.buildProjectAction).setDefaultHandler((IAction)buildHandler);
            }
        };
        this.getWindow().addPageListener(this.pageListener);
        this.prefListener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                if (event.getProperty().equals("description.autobuilding")) {
                    WorkbenchActionBuilder.this.updateBuildActions(false);
                }
            }
        };
        ResourcesPlugin.getPlugin().getPluginPreferences().addPropertyChangeListener(this.prefListener);
        this.propPrefListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("REUSE_OPEN_EDITORS_BOOLEAN") && WorkbenchActionBuilder.this.window.getShell() != null && !WorkbenchActionBuilder.this.window.getShell().isDisposed()) {
                    WorkbenchActionBuilder.this.window.getShell().getDisplay().syncExec(new Runnable(this){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            3.access$0(this.this$1).updatePinActionToolbar();
                        }
                    });
                }
            }

            static /* synthetic */ WorkbenchActionBuilder access$0(3 var0) {
                return var0.WorkbenchActionBuilder.this;
            }
        };
        WorkbenchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propPrefListener);
        this.resourceListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                if (delta == null) {
                    return;
                }
                IResourceDelta[] projectDeltas = delta.getAffectedChildren();
                int i = 0;
                while (i < projectDeltas.length) {
                    boolean changed;
                    int kind = projectDeltas[i].getKind();
                    boolean bl = changed = (projectDeltas[i].getFlags() & 0x84000) != 0;
                    if (kind != 4 || changed) {
                        WorkbenchActionBuilder.this.updateBuildActions(false);
                        return;
                    }
                    ++i;
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener, 1);
    }

    public void fillActionBars(int flags) {
        super.fillActionBars(flags);
        if ((flags & 1) == 0) {
            this.updateBuildActions(true);
            this.hookListeners();
        }
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        IActionBarConfigurer2 actionBarConfigurer = (IActionBarConfigurer2)this.getActionBarConfigurer();
        this.coolbarPopupMenuManager = new MenuManager();
        this.coolbarPopupMenuManager.add((IContributionItem)new ActionContributionItem((IAction)this.lockToolBarAction));
        this.coolbarPopupMenuManager.add((IContributionItem)new ActionContributionItem((IAction)this.editActionSetAction));
        coolBar.setContextMenuManager((IMenuManager)this.coolbarPopupMenuManager);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.menus.IMenuService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMenuService menuService = (IMenuService)this.window.getService((Class)clazz);
        menuService.populateContributionManager((ContributionManager)this.coolbarPopupMenuManager, "popup:windowCoolbarContextMenu");
        coolBar.add((IContributionItem)new GroupMarker("group.file"));
        IToolBarManager fileToolBar = actionBarConfigurer.createToolBarManager();
        fileToolBar.add((IContributionItem)new Separator("new.group"));
        fileToolBar.add((IAction)this.newWizardDropDownAction);
        fileToolBar.add((IContributionItem)new GroupMarker("new.ext"));
        fileToolBar.add((IContributionItem)new GroupMarker("save.group"));
        fileToolBar.add((IAction)this.saveAction);
        fileToolBar.add((IContributionItem)new GroupMarker("save.ext"));
        fileToolBar.add((IAction)this.printAction);
        fileToolBar.add((IContributionItem)new GroupMarker("print.ext"));
        fileToolBar.add((IContributionItem)new Separator("build.group"));
        fileToolBar.add((IContributionItem)new GroupMarker("build.ext"));
        fileToolBar.add((IContributionItem)new Separator("additions"));
        coolBar.add((IContributionItem)actionBarConfigurer.createToolBarContributionItem(fileToolBar, "org.eclipse.ui.workbench.file"));
        coolBar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)new GroupMarker("group.nav"));
        IToolBarManager navToolBar = actionBarConfigurer.createToolBarManager();
        navToolBar.add((IContributionItem)new Separator("history.group"));
        navToolBar.add((IContributionItem)new GroupMarker("group.application"));
        navToolBar.add((IAction)this.backwardHistoryAction);
        navToolBar.add((IAction)this.forwardHistoryAction);
        navToolBar.add((IContributionItem)new Separator("pin.group"));
        navToolBar.add(this.pinEditorContributionItem);
        coolBar.add((IContributionItem)actionBarConfigurer.createToolBarContributionItem(navToolBar, "org.eclipse.ui.workbench.navigate"));
        coolBar.add((IContributionItem)new GroupMarker("group.editor"));
        coolBar.add((IContributionItem)new GroupMarker("group.help"));
        IToolBarManager helpToolBar = actionBarConfigurer.createToolBarManager();
        helpToolBar.add((IContributionItem)new Separator("group.help"));
        helpToolBar.add((IContributionItem)new GroupMarker("group.application"));
        coolBar.add((IContributionItem)actionBarConfigurer.createToolBarContributionItem(helpToolBar, "org.eclipse.ui.workbench.help"));
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        menuBar.add((IContributionItem)this.createFileMenu());
        menuBar.add((IContributionItem)this.createEditMenu());
        menuBar.add((IContributionItem)this.createNavigateMenu());
        menuBar.add((IContributionItem)this.createProjectMenu());
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        menuBar.add((IContributionItem)this.createWindowMenu());
        menuBar.add((IContributionItem)this.createHelpMenu());
    }

    private MenuManager createFileMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_file, "file");
        menu.add((IContributionItem)new GroupMarker("fileStart"));
        String newText = IDEWorkbenchMessages.Workbench_new;
        String newId = ActionFactory.NEW.getId();
        MenuManager newMenu = new MenuManager(newText, newId){

            public String getMenuText() {
                String result = super.getMenuText();
                if (WorkbenchActionBuilder.this.newQuickMenu == null) {
                    return result;
                }
                String shortCut = WorkbenchActionBuilder.this.newQuickMenu.getShortCutString();
                if (shortCut == null) {
                    return result;
                }
                return String.valueOf(result) + "\t" + shortCut;
            }
        };
        newMenu.add((IContributionItem)new Separator(newId));
        this.newWizardMenu = new NewWizardMenu(this.getWindow());
        newMenu.add((IContributionItem)this.newWizardMenu);
        newMenu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)newMenu);
        menu.add((IContributionItem)new GroupMarker("new.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.closeAction);
        menu.add((IAction)this.closeAllAction);
        menu.add((IContributionItem)new GroupMarker("close.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.saveAction);
        menu.add((IAction)this.saveAsAction);
        menu.add((IAction)this.saveAllAction);
        menu.add((IAction)this.revertAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.moveAction);
        menu.add((IAction)this.renameAction);
        menu.add((IAction)this.refreshAction);
        menu.add((IContributionItem)new GroupMarker("save.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.printAction);
        menu.add((IContributionItem)new GroupMarker("print.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.openWorkspaceAction);
        menu.add((IContributionItem)new GroupMarker("open.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.importResourcesAction);
        menu.add((IAction)this.exportResourcesAction);
        menu.add((IContributionItem)new GroupMarker("import.ext"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.propertiesAction);
        menu.add(ContributionItemFactory.REOPEN_EDITORS.create(this.getWindow()));
        menu.add((IContributionItem)new GroupMarker("mru"));
        menu.add((IContributionItem)new Separator());
        ActionContributionItem quitItem = new ActionContributionItem((IAction)this.quitAction);
        quitItem.setVisible(!"carbon".equals(SWT.getPlatform()));
        menu.add((IContributionItem)quitItem);
        menu.add((IContributionItem)new GroupMarker("fileEnd"));
        return menu;
    }

    private MenuManager createEditMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_edit, "edit");
        menu.add((IContributionItem)new GroupMarker("editStart"));
        menu.add((IAction)this.undoAction);
        menu.add((IAction)this.redoAction);
        menu.add((IContributionItem)new GroupMarker("undo.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.cutAction);
        menu.add((IAction)this.copyAction);
        menu.add((IAction)this.pasteAction);
        menu.add((IContributionItem)new GroupMarker("cut.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.deleteAction);
        menu.add((IAction)this.selectAllAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.findAction);
        menu.add((IContributionItem)new GroupMarker("find.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.addBookmarkAction);
        menu.add((IAction)this.addTaskAction);
        menu.add((IContributionItem)new GroupMarker("add.ext"));
        menu.add((IContributionItem)new GroupMarker("editEnd"));
        menu.add((IContributionItem)new Separator("additions"));
        return menu;
    }

    private MenuManager createNavigateMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_navigate, "navigate");
        menu.add((IContributionItem)new GroupMarker("navStart"));
        menu.add((IAction)this.goIntoAction);
        MenuManager goToSubMenu = new MenuManager(IDEWorkbenchMessages.Workbench_goTo, "goTo");
        menu.add((IContributionItem)goToSubMenu);
        goToSubMenu.add((IAction)this.backAction);
        goToSubMenu.add((IAction)this.forwardAction);
        goToSubMenu.add((IAction)this.upAction);
        goToSubMenu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("open.ext"));
        int i = 2;
        while (i < 5) {
            menu.add((IContributionItem)new Separator("open.ext" + i));
            ++i;
        }
        menu.add((IContributionItem)new Separator("show.ext"));
        MenuManager showInSubMenu = new MenuManager(IDEWorkbenchMessages.Workbench_showIn, "showIn"){

            public String getMenuText() {
                String result = super.getMenuText();
                if (WorkbenchActionBuilder.this.showInQuickMenu == null) {
                    return null;
                }
                String shortCut = WorkbenchActionBuilder.this.showInQuickMenu.getShortCutString();
                if (shortCut == null) {
                    return result;
                }
                return String.valueOf(result) + "\t" + shortCut;
            }
        };
        showInSubMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getWindow()));
        menu.add((IContributionItem)showInSubMenu);
        i = 2;
        while (i < 5) {
            menu.add((IContributionItem)new Separator("show.ext" + i));
            ++i;
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.nextAction);
        menu.add((IAction)this.previousAction);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new GroupMarker("navEnd"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.backwardHistoryAction);
        menu.add((IAction)this.forwardHistoryAction);
        return menu;
    }

    private MenuManager createProjectMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_project, "project");
        menu.add((IContributionItem)new Separator("projStart"));
        menu.add((IAction)this.openProjectAction);
        menu.add((IAction)this.closeProjectAction);
        menu.add((IContributionItem)new GroupMarker("open.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.buildAllAction);
        menu.add((IAction)this.buildProjectAction);
        this.addWorkingSetBuildActions(menu);
        menu.add((IAction)this.cleanAction);
        menu.add((IAction)this.toggleAutoBuildAction);
        menu.add((IContributionItem)new GroupMarker("build.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new GroupMarker("projEnd"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.projectPropertyDialogAction);
        return menu;
    }

    private MenuManager createWindowMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_window, "window");
        menu.add((IAction)this.newWindowAction);
        menu.add((IAction)this.newEditorAction);
        menu.add((IContributionItem)new Separator());
        this.addPerspectiveActions(menu);
        menu.add((IContributionItem)new Separator());
        this.addKeyboardShortcuts(menu);
        menu.add((IContributionItem)new Separator("additions"));
        ActionContributionItem openPreferencesItem = new ActionContributionItem((IAction)this.openPreferencesAction);
        openPreferencesItem.setVisible(!"carbon".equals(SWT.getPlatform()));
        menu.add((IContributionItem)openPreferencesItem);
        menu.add(ContributionItemFactory.OPEN_WINDOWS.create(this.getWindow()));
        return menu;
    }

    private void addPerspectiveActions(MenuManager menu) {
        String openText = IDEWorkbenchMessages.Workbench_openPerspective;
        MenuManager changePerspMenuMgr = new MenuManager(openText, "openPerspective");
        IContributionItem changePerspMenuItem = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(this.getWindow());
        changePerspMenuMgr.add(changePerspMenuItem);
        menu.add((IContributionItem)changePerspMenuMgr);
        MenuManager showViewMenuMgr = new MenuManager(IDEWorkbenchMessages.Workbench_showView, "showView");
        IContributionItem showViewMenu = ContributionItemFactory.VIEWS_SHORTLIST.create(this.getWindow());
        showViewMenuMgr.add(showViewMenu);
        menu.add((IContributionItem)showViewMenuMgr);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.editActionSetAction);
        menu.add((IAction)this.savePerspectiveAction);
        menu.add((IAction)this.resetPerspectiveAction);
        menu.add((IAction)this.closePerspAction);
        menu.add((IAction)this.closeAllPerspsAction);
    }

    private void addWorkingSetBuildActions(MenuManager menu) {
        this.buildWorkingSetMenu = new MenuManager(IDEWorkbenchMessages.Workbench_buildSet);
        BuildSetMenu workingSetBuilds = new BuildSetMenu(this.window, this.getActionBarConfigurer());
        this.buildWorkingSetMenu.add((IContributionItem)workingSetBuilds);
        menu.add((IContributionItem)this.buildWorkingSetMenu);
    }

    private void addKeyboardShortcuts(MenuManager menu) {
        MenuManager subMenu = new MenuManager(IDEWorkbenchMessages.Workbench_shortcuts, "shortcuts");
        menu.add((IContributionItem)subMenu);
        subMenu.add((IAction)this.showPartPaneMenuAction);
        subMenu.add((IAction)this.showViewMenuAction);
        subMenu.add((IAction)this.quickAccessAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.maximizePartAction);
        subMenu.add((IAction)this.minimizePartAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.activateEditorAction);
        subMenu.add((IAction)this.nextEditorAction);
        subMenu.add((IAction)this.prevEditorAction);
        subMenu.add((IAction)this.switchToEditorAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.nextPartAction);
        subMenu.add((IAction)this.prevPartAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.nextPerspectiveAction);
        subMenu.add((IAction)this.prevPerspectiveAction);
    }

    private MenuManager createHelpMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_help, "help");
        this.addSeparatorOrGroupMarker(menu, "group.intro");
        if (this.introAction != null) {
            menu.add((IAction)this.introAction);
        } else if (this.quickStartAction != null) {
            menu.add((IAction)this.quickStartAction);
        }
        menu.add((IContributionItem)new GroupMarker("group.intro.ext"));
        this.addSeparatorOrGroupMarker(menu, "group.main");
        menu.add((IAction)this.helpContentsAction);
        menu.add((IAction)this.helpSearchAction);
        menu.add((IAction)this.dynamicHelpAction);
        this.addSeparatorOrGroupMarker(menu, "group.assist");
        if (this.tipsAndTricksAction != null) {
            menu.add((IAction)this.tipsAndTricksAction);
        }
        menu.add((IContributionItem)new GroupMarker("helpStart"));
        menu.add((IContributionItem)new GroupMarker("group.main.ext"));
        this.addSeparatorOrGroupMarker(menu, "group.tutorials");
        this.addSeparatorOrGroupMarker(menu, "group.tools");
        this.addSeparatorOrGroupMarker(menu, "group.updates");
        menu.add((IContributionItem)new GroupMarker("helpEnd"));
        this.addSeparatorOrGroupMarker(menu, "additions");
        menu.add((IContributionItem)new Separator("group.about"));
        ActionContributionItem aboutItem = new ActionContributionItem((IAction)this.aboutAction);
        aboutItem.setVisible(!"carbon".equals(SWT.getPlatform()));
        menu.add((IContributionItem)aboutItem);
        menu.add((IContributionItem)new GroupMarker("group.about.ext"));
        return menu;
    }

    private void addSeparatorOrGroupMarker(MenuManager menu, String groupId) {
        String prefId = "useSeparator." + menu.getId() + "." + groupId;
        boolean addExtraSeparators = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean(prefId);
        if (addExtraSeparators) {
            menu.add((IContributionItem)new Separator(groupId));
        } else {
            menu.add((IContributionItem)new GroupMarker(groupId));
        }
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.menus.IMenuService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMenuService menuService = (IMenuService)this.window.getService((Class)clazz);
        menuService.releaseContributions((ContributionManager)this.coolbarPopupMenuManager);
        this.coolbarPopupMenuManager.dispose();
        this.getActionBarConfigurer().getStatusLineManager().remove((IContributionItem)this.statusLineItem);
        if (this.pageListener != null) {
            this.window.removePageListener(this.pageListener);
            this.pageListener = null;
        }
        if (this.prefListener != null) {
            ResourcesPlugin.getPlugin().getPluginPreferences().removePropertyChangeListener(this.prefListener);
            this.prefListener = null;
        }
        if (this.propPrefListener != null) {
            WorkbenchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propPrefListener);
            this.propPrefListener = null;
        }
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
            this.resourceListener = null;
        }
        this.pinEditorContributionItem.dispose();
        this.showInQuickMenu.dispose();
        this.newQuickMenu.dispose();
        this.closeAction = null;
        this.closeAllAction = null;
        this.closeAllSavedAction = null;
        this.closeOthersAction = null;
        this.saveAction = null;
        this.saveAllAction = null;
        this.newWindowAction = null;
        this.newEditorAction = null;
        this.helpContentsAction = null;
        this.helpSearchAction = null;
        this.dynamicHelpAction = null;
        this.aboutAction = null;
        this.openPreferencesAction = null;
        this.saveAsAction = null;
        this.hideShowEditorAction = null;
        this.savePerspectiveAction = null;
        this.resetPerspectiveAction = null;
        this.editActionSetAction = null;
        this.closePerspAction = null;
        this.lockToolBarAction = null;
        this.closeAllPerspsAction = null;
        this.showViewMenuAction = null;
        this.showPartPaneMenuAction = null;
        this.nextPartAction = null;
        this.prevPartAction = null;
        this.nextEditorAction = null;
        this.prevEditorAction = null;
        this.nextPerspectiveAction = null;
        this.prevPerspectiveAction = null;
        this.activateEditorAction = null;
        this.maximizePartAction = null;
        this.minimizePartAction = null;
        this.switchToEditorAction = null;
        this.quickAccessAction = null;
        this.backwardHistoryAction = null;
        this.forwardHistoryAction = null;
        this.undoAction = null;
        this.redoAction = null;
        this.cutAction = null;
        this.copyAction = null;
        this.pasteAction = null;
        this.deleteAction = null;
        this.selectAllAction = null;
        this.findAction = null;
        this.printAction = null;
        this.revertAction = null;
        this.refreshAction = null;
        this.propertiesAction = null;
        this.quitAction = null;
        this.moveAction = null;
        this.renameAction = null;
        this.goIntoAction = null;
        this.backAction = null;
        this.forwardAction = null;
        this.upAction = null;
        this.nextAction = null;
        this.previousAction = null;
        this.openWorkspaceAction = null;
        this.projectPropertyDialogAction = null;
        this.newWizardAction = null;
        this.newWizardDropDownAction = null;
        this.importResourcesAction = null;
        this.exportResourcesAction = null;
        this.buildAllAction = null;
        this.cleanAction = null;
        this.toggleAutoBuildAction = null;
        this.buildWorkingSetMenu = null;
        this.quickStartAction = null;
        this.tipsAndTricksAction = null;
        this.showInQuickMenu = null;
        this.newQuickMenu = null;
        this.addBookmarkAction = null;
        this.addTaskAction = null;
        this.buildProjectAction = null;
        this.openProjectAction = null;
        this.closeProjectAction = null;
        this.newWizardMenu = null;
        this.pinEditorContributionItem = null;
        this.statusLineItem = null;
        this.prefListener = null;
        this.propPrefListener = null;
        this.introAction = null;
        super.dispose();
    }

    void updateModeLine(String text) {
        this.statusLineItem.setText(text);
    }

    public boolean isApplicationMenu(String menuId) {
        if (menuId.equals("file")) {
            return true;
        }
        return menuId.equals("window");
    }

    public boolean isWorkbenchCoolItemId(String id) {
        if ("org.eclipse.ui.workbench.file".equalsIgnoreCase(id)) {
            return true;
        }
        return "org.eclipse.ui.workbench.navigate".equalsIgnoreCase(id);
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
        statusLine.add((IContributionItem)this.statusLineItem);
    }

    protected void makeActions(final IWorkbenchWindow window) {
        this.statusLineItem = new StatusLineContributionItem("ModeContributionItem");
        this.newWizardAction = ActionFactory.NEW.create(window);
        this.register((IAction)this.newWizardAction);
        this.newWizardDropDownAction = IDEActionFactory.NEW_WIZARD_DROP_DOWN.create(window);
        this.register((IAction)this.newWizardDropDownAction);
        this.importResourcesAction = ActionFactory.IMPORT.create(window);
        this.register((IAction)this.importResourcesAction);
        this.exportResourcesAction = ActionFactory.EXPORT.create(window);
        this.register((IAction)this.exportResourcesAction);
        this.buildAllAction = IDEActionFactory.BUILD.create(window);
        this.register((IAction)this.buildAllAction);
        this.cleanAction = IDEActionFactory.BUILD_CLEAN.create(window);
        this.register((IAction)this.cleanAction);
        this.toggleAutoBuildAction = IDEActionFactory.BUILD_AUTOMATICALLY.create(window);
        this.register((IAction)this.toggleAutoBuildAction);
        this.saveAction = ActionFactory.SAVE.create(window);
        this.register((IAction)this.saveAction);
        this.saveAsAction = ActionFactory.SAVE_AS.create(window);
        this.register((IAction)this.saveAsAction);
        this.saveAllAction = ActionFactory.SAVE_ALL.create(window);
        this.register((IAction)this.saveAllAction);
        this.newWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(this.getWindow());
        this.newWindowAction.setText(IDEWorkbenchMessages.Workbench_openNewWindow);
        this.register((IAction)this.newWindowAction);
        this.newEditorAction = ActionFactory.NEW_EDITOR.create(window);
        this.register((IAction)this.newEditorAction);
        this.undoAction = ActionFactory.UNDO.create(window);
        this.register((IAction)this.undoAction);
        this.redoAction = ActionFactory.REDO.create(window);
        this.register((IAction)this.redoAction);
        this.cutAction = ActionFactory.CUT.create(window);
        this.register((IAction)this.cutAction);
        this.copyAction = ActionFactory.COPY.create(window);
        this.register((IAction)this.copyAction);
        this.pasteAction = ActionFactory.PASTE.create(window);
        this.register((IAction)this.pasteAction);
        this.printAction = ActionFactory.PRINT.create(window);
        this.register((IAction)this.printAction);
        this.selectAllAction = ActionFactory.SELECT_ALL.create(window);
        this.register((IAction)this.selectAllAction);
        this.findAction = ActionFactory.FIND.create(window);
        this.register((IAction)this.findAction);
        this.closeAction = ActionFactory.CLOSE.create(window);
        this.register((IAction)this.closeAction);
        this.closeAllAction = ActionFactory.CLOSE_ALL.create(window);
        this.register((IAction)this.closeAllAction);
        this.closeOthersAction = ActionFactory.CLOSE_OTHERS.create(window);
        this.register((IAction)this.closeOthersAction);
        this.closeAllSavedAction = ActionFactory.CLOSE_ALL_SAVED.create(window);
        this.register((IAction)this.closeAllSavedAction);
        this.helpContentsAction = ActionFactory.HELP_CONTENTS.create(window);
        this.register((IAction)this.helpContentsAction);
        this.helpSearchAction = ActionFactory.HELP_SEARCH.create(window);
        this.register((IAction)this.helpSearchAction);
        this.dynamicHelpAction = ActionFactory.DYNAMIC_HELP.create(window);
        this.register((IAction)this.dynamicHelpAction);
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.aboutAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_OBJS_DEFAULT_PROD"));
        this.register((IAction)this.aboutAction);
        this.openPreferencesAction = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.openPreferencesAction);
        this.addBookmarkAction = IDEActionFactory.BOOKMARK.create(window);
        this.register((IAction)this.addBookmarkAction);
        this.addTaskAction = IDEActionFactory.ADD_TASK.create(window);
        this.register((IAction)this.addTaskAction);
        this.deleteAction = ActionFactory.DELETE.create(window);
        this.register((IAction)this.deleteAction);
        this.makeFeatureDependentActions(window);
        this.showViewMenuAction = ActionFactory.SHOW_VIEW_MENU.create(window);
        this.register((IAction)this.showViewMenuAction);
        this.showPartPaneMenuAction = ActionFactory.SHOW_PART_PANE_MENU.create(window);
        this.register((IAction)this.showPartPaneMenuAction);
        this.nextEditorAction = ActionFactory.NEXT_EDITOR.create(window);
        this.register((IAction)this.nextEditorAction);
        this.prevEditorAction = ActionFactory.PREVIOUS_EDITOR.create(window);
        this.register((IAction)this.prevEditorAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextEditorAction, (ActionFactory.IWorkbenchAction)this.prevEditorAction);
        this.nextPartAction = ActionFactory.NEXT_PART.create(window);
        this.register((IAction)this.nextPartAction);
        this.prevPartAction = ActionFactory.PREVIOUS_PART.create(window);
        this.register((IAction)this.prevPartAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextPartAction, (ActionFactory.IWorkbenchAction)this.prevPartAction);
        this.nextPerspectiveAction = ActionFactory.NEXT_PERSPECTIVE.create(window);
        this.register((IAction)this.nextPerspectiveAction);
        this.prevPerspectiveAction = ActionFactory.PREVIOUS_PERSPECTIVE.create(window);
        this.register((IAction)this.prevPerspectiveAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextPerspectiveAction, (ActionFactory.IWorkbenchAction)this.prevPerspectiveAction);
        this.activateEditorAction = ActionFactory.ACTIVATE_EDITOR.create(window);
        this.register((IAction)this.activateEditorAction);
        this.maximizePartAction = ActionFactory.MAXIMIZE.create(window);
        this.register((IAction)this.maximizePartAction);
        this.minimizePartAction = ActionFactory.MINIMIZE.create(window);
        this.register((IAction)this.minimizePartAction);
        this.switchToEditorAction = ActionFactory.SHOW_OPEN_EDITORS.create(window);
        this.register((IAction)this.switchToEditorAction);
        this.workbookEditorsAction = ActionFactory.SHOW_WORKBOOK_EDITORS.create(window);
        this.register((IAction)this.workbookEditorsAction);
        this.quickAccessAction = ActionFactory.SHOW_QUICK_ACCESS.create(window);
        this.hideShowEditorAction = ActionFactory.SHOW_EDITOR.create(window);
        this.register((IAction)this.hideShowEditorAction);
        this.savePerspectiveAction = ActionFactory.SAVE_PERSPECTIVE.create(window);
        this.register((IAction)this.savePerspectiveAction);
        this.editActionSetAction = ActionFactory.EDIT_ACTION_SETS.create(window);
        this.register((IAction)this.editActionSetAction);
        this.lockToolBarAction = ActionFactory.LOCK_TOOL_BAR.create(window);
        this.register((IAction)this.lockToolBarAction);
        this.resetPerspectiveAction = ActionFactory.RESET_PERSPECTIVE.create(window);
        this.register((IAction)this.resetPerspectiveAction);
        this.closePerspAction = ActionFactory.CLOSE_PERSPECTIVE.create(window);
        this.register((IAction)this.closePerspAction);
        this.closeAllPerspsAction = ActionFactory.CLOSE_ALL_PERSPECTIVES.create(window);
        this.register((IAction)this.closeAllPerspsAction);
        this.forwardHistoryAction = ActionFactory.FORWARD_HISTORY.create(window);
        this.register((IAction)this.forwardHistoryAction);
        this.backwardHistoryAction = ActionFactory.BACKWARD_HISTORY.create(window);
        this.register((IAction)this.backwardHistoryAction);
        this.revertAction = ActionFactory.REVERT.create(window);
        this.register((IAction)this.revertAction);
        this.refreshAction = ActionFactory.REFRESH.create(window);
        this.register((IAction)this.refreshAction);
        this.propertiesAction = ActionFactory.PROPERTIES.create(window);
        this.register((IAction)this.propertiesAction);
        this.quitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.quitAction);
        this.moveAction = ActionFactory.MOVE.create(window);
        this.register((IAction)this.moveAction);
        this.renameAction = ActionFactory.RENAME.create(window);
        this.register((IAction)this.renameAction);
        this.goIntoAction = ActionFactory.GO_INTO.create(window);
        this.register((IAction)this.goIntoAction);
        this.backAction = ActionFactory.BACK.create(window);
        this.register((IAction)this.backAction);
        this.forwardAction = ActionFactory.FORWARD.create(window);
        this.register((IAction)this.forwardAction);
        this.upAction = ActionFactory.UP.create(window);
        this.register((IAction)this.upAction);
        this.nextAction = ActionFactory.NEXT.create(window);
        this.nextAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_NEXT_NAV"));
        this.register((IAction)this.nextAction);
        this.previousAction = ActionFactory.PREVIOUS.create(window);
        this.previousAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_PREVIOUS_NAV"));
        this.register((IAction)this.previousAction);
        this.buildProjectAction = IDEActionFactory.BUILD_PROJECT.create(window);
        this.register((IAction)this.buildProjectAction);
        this.openProjectAction = IDEActionFactory.OPEN_PROJECT.create(window);
        this.register((IAction)this.openProjectAction);
        this.closeProjectAction = IDEActionFactory.CLOSE_PROJECT.create(window);
        this.register((IAction)this.closeProjectAction);
        this.openWorkspaceAction = IDEActionFactory.OPEN_WORKSPACE.create(window);
        this.register((IAction)this.openWorkspaceAction);
        this.projectPropertyDialogAction = IDEActionFactory.OPEN_PROJECT_PROPERTIES.create(window);
        this.register((IAction)this.projectPropertyDialogAction);
        if (window.getWorkbench().getIntroManager().hasIntro()) {
            this.introAction = ActionFactory.INTRO.create(window);
            this.register((IAction)this.introAction);
        }
        String showInQuickMenuId = "org.eclipse.ui.navigate.showInQuickMenu";
        this.showInQuickMenu = new QuickMenuAction(showInQuickMenuId){

            protected void fillMenu(IMenuManager menu) {
                menu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(window));
            }
        };
        this.register((IAction)this.showInQuickMenu);
        this.newQuickMenu = new QuickMenuAction("org.eclipse.ui.file.newQuickMenu"){

            protected void fillMenu(IMenuManager menu) {
                menu.add((IContributionItem)new NewWizardMenu(window));
            }
        };
        this.register((IAction)this.newQuickMenu);
        this.pinEditorContributionItem = ContributionItemFactory.PIN_EDITOR.create(window);
    }

    private void makeFeatureDependentActions(IWorkbenchWindow window) {
        AboutInfo[] infos = null;
        IPreferenceStore prefs = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String stateKey = "platformState";
        String prevState = prefs.getString(stateKey);
        String currentState = String.valueOf(Platform.getStateStamp());
        boolean sameState = currentState.equals(prevState);
        if (!sameState) {
            prefs.putValue(stateKey, currentState);
        }
        String quickStartKey = IDEActionFactory.QUICK_START.getId();
        String showQuickStart = prefs.getString(quickStartKey);
        if (sameState && "true".equals(showQuickStart)) {
            this.quickStartAction = IDEActionFactory.QUICK_START.create(window);
            this.register((IAction)this.quickStartAction);
        } else if (!sameState || !"false".equals(showQuickStart)) {
            infos = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
            boolean found = this.hasWelcomePage(infos);
            prefs.setValue(quickStartKey, found);
            if (found) {
                this.quickStartAction = IDEActionFactory.QUICK_START.create(window);
                this.register((IAction)this.quickStartAction);
            }
        }
        String tipsAndTricksKey = IDEActionFactory.TIPS_AND_TRICKS.getId();
        String showTipsAndTricks = prefs.getString(tipsAndTricksKey);
        if (sameState && "true".equals(showTipsAndTricks)) {
            this.tipsAndTricksAction = IDEActionFactory.TIPS_AND_TRICKS.create(window);
            this.register((IAction)this.tipsAndTricksAction);
        } else if (!sameState || !"false".equals(showTipsAndTricks)) {
            if (infos == null) {
                infos = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
            }
            boolean found = this.hasTipsAndTricks(infos);
            prefs.setValue(tipsAndTricksKey, found);
            if (found) {
                this.tipsAndTricksAction = IDEActionFactory.TIPS_AND_TRICKS.create(window);
                this.register((IAction)this.tipsAndTricksAction);
            }
        }
    }

    private boolean hasWelcomePage(AboutInfo[] infos) {
        int i = 0;
        while (i < infos.length) {
            if (infos[i].getWelcomePageURL() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasTipsAndTricks(AboutInfo[] infos) {
        int i = 0;
        while (i < infos.length) {
            if (infos[i].getTipsAndTricksHref() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void updateBuildActions(boolean immediately) {
        Runnable update = new Runnable(){

            public void run() {
                boolean found;
                if (WorkbenchActionBuilder.this.isDisposed) {
                    return;
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject[] projects = workspace.getRoot().getProjects();
                boolean enabled = BuildUtilities.isEnabled(projects, 10);
                WorkbenchActionBuilder.this.buildAllAction.setEnabled(enabled);
                WorkbenchActionBuilder.this.buildProjectAction.setEnabled(enabled);
                WorkbenchActionBuilder.this.toggleAutoBuildAction.setChecked(workspace.isAutoBuilding());
                WorkbenchActionBuilder.this.cleanAction.setEnabled(BuildUtilities.isEnabled(projects, 15));
                ICoolBarManager coolBarManager = WorkbenchActionBuilder.this.getActionBarConfigurer().getCoolBarManager();
                IContributionItem cbItem = coolBarManager.find("org.eclipse.ui.workbench.file");
                if (!(cbItem instanceof IToolBarContributionItem)) {
                    IDEWorkbenchPlugin.log("File toolbar contribution item is missing");
                    return;
                }
                IToolBarContributionItem toolBarItem = (IToolBarContributionItem)cbItem;
                IToolBarManager toolBarManager = toolBarItem.getToolBarManager();
                if (toolBarManager == null) {
                    IDEWorkbenchPlugin.log("File toolbar is missing");
                    return;
                }
                boolean bl = found = toolBarManager.find(WorkbenchActionBuilder.this.buildAllAction.getId()) != null;
                if (enabled && !found) {
                    toolBarManager.appendToGroup("build.group", (IAction)WorkbenchActionBuilder.this.buildAllAction);
                    toolBarManager.update(false);
                    toolBarItem.update("size");
                } else if (WorkbenchActionBuilder.this.buildAllAction != null && found && !enabled) {
                    toolBarManager.remove(WorkbenchActionBuilder.this.buildAllAction.getId());
                    toolBarManager.update(false);
                    toolBarItem.update("size");
                }
            }
        };
        if (immediately) {
            update.run();
        } else {
            Shell shell = this.window.getShell();
            if (shell != null && !shell.isDisposed()) {
                shell.getDisplay().asyncExec(update);
            }
        }
    }

    void updatePinActionToolbar() {
        ICoolBarManager coolBarManager = this.getActionBarConfigurer().getCoolBarManager();
        IContributionItem cbItem = coolBarManager.find("org.eclipse.ui.workbench.navigate");
        if (!(cbItem instanceof IToolBarContributionItem)) {
            IDEWorkbenchPlugin.log("Navigation toolbar contribution item is missing");
            return;
        }
        IToolBarContributionItem toolBarItem = (IToolBarContributionItem)cbItem;
        IToolBarManager toolBarManager = toolBarItem.getToolBarManager();
        if (toolBarManager == null) {
            IDEWorkbenchPlugin.log("Navigate toolbar is missing");
            return;
        }
        toolBarManager.update(false);
        toolBarItem.update("size");
    }
}

