/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.draw;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import jp.sourceforge.akjrcp.text_douga.item.TextDougaTextUtils;

public class TextLinesLayout {
    private String[] texts;
    private TextLayout[] textLayouts;
    private Font font;
    private int lineMargin = 6;
    private Shape[] shapes;

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public TextLinesLayout(Graphics2D g2, Font font, String text, int maxWidth) {
        this(g2, font, text, maxWidth, maxWidth);
    }

    public TextLinesLayout(Graphics2D g2, Font font, String text, int firstWidth, int maxWidth) {
        this.font = font;
        this.texts = this.wrapText(font, text, firstWidth, maxWidth);
        int i = 0;
        while (i < this.texts.length) {
            if (this.texts[i].equals("")) {
                this.texts[i] = " ";
            }
            ++i;
        }
        this.textLayouts = new TextLayout[this.texts.length];
        i = 0;
        while (i < this.textLayouts.length) {
            this.textLayouts[i] = this.makeStringLaytou(this.getTextAt(i), font, g2);
            ++i;
        }
    }

    public String getTextAt(int index) {
        return this.texts[index];
    }

    public TextLayout getTextLayoutAt(int index) {
        return this.textLayouts[index];
    }

    public TextLayout makeStringLaytou(String text, Font font, Graphics2D g2) {
        TextLayout textLayout = new TextLayout(text, font, g2.getFontRenderContext());
        return textLayout;
    }

    public String[] wrapText(Font font, String text, int firstWidth, int maxwidth) {
        return TextDougaTextUtils.wrapText(text, font, firstWidth, maxwidth);
    }

    public Shape[] getShapes() {
        if (this.shapes == null) {
            this.shapes = new Shape[this.textLayouts.length];
            int i = 0;
            while (i < this.shapes.length) {
                this.shapes[i] = this.textLayouts[i].getOutline(new AffineTransform());
                ++i;
            }
        }
        return this.shapes;
    }

    public Rectangle getBounds() {
        Rectangle rect = new Rectangle();
        rect.height = this.textLayouts.length * this.font.getSize() + (this.textLayouts.length - 1) * this.lineMargin;
        int i = 0;
        while (i < this.textLayouts.length) {
            rect.width = (int)Math.max((double)rect.width, this.textLayouts[i].getBounds().getWidth() + this.textLayouts[i].getBounds().getX());
            ++i;
        }
        return rect;
    }

    public TextLayout[] getTextLayouts() {
        return this.textLayouts;
    }

    public String[] getTexts() {
        return this.texts;
    }
}

