/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.audio;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.math.BigDecimal;
import javax.sound.sampled.UnsupportedAudioFileException;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPCMPipeReader;
import jp.sourceforge.akjrcp.ffmpeg.ProcessListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AudioInput
implements ProcessListener {
    public static Log log = LogFactory.getLog(AudioInput.class);
    private int rate = 48000;
    private int channel = 2;
    public static final int NOT_SPECIFIED = -1;
    private String ffmpegPath;
    private String inputPath;
    private double startTime;
    private double duration = -1.0;
    private PipedInputStream inputStream;
    private PipedOutputStream outputStream;
    private boolean copying;
    private boolean canceling;
    private FFMpegPCMPipeReader ffreader;

    public AudioInput(String ffmpegPath, String inputPath) throws IOException {
        this(ffmpegPath, inputPath, 0.0, -1.0);
    }

    public AudioInput(String ffmpegPath, String inputPath, double start, double duration) throws IOException {
        this.ffmpegPath = ffmpegPath;
        this.inputPath = inputPath;
        this.startTime = start;
        this.duration = duration;
        this.outputStream = new PipedOutputStream();
        this.inputStream = new PipedInputStream(this.outputStream);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void startInput() {
        this.ffreader = new FFMpegPCMPipeReader(this.ffmpegPath, this.inputPath, this.rate, this.channel);
        Thread t = new Thread((Runnable)this.ffreader);
        this.ffreader.setProcessListener((ProcessListener)this);
        t.start();
        this.copying = true;
    }

    public void finished() {
        log.info((Object)"finish loading");
    }

    /*
     * Unable to fully structure code
     */
    public void started() {
        try {
            try {
                binput = new BufferedInputStream(this.ffreader.getPCMPipeReader().getInputStream());
                skipbyte = 0L;
                if (this.startTime != 0.0) {
                    skipbyte = new BigDecimal("" + this.startTime).multiply(new BigDecimal(this.rate * (2 * this.channel))).longValue();
                }
                AudioInput.log.info((Object)("should skipbyte:" + skipbyte + " " + this.startTime + "s"));
                mustread = 0L;
                if (this.duration != -1.0) {
                    dB = new BigDecimal("" + this.duration);
                    mustread = dB.multiply(new BigDecimal(this.rate)).longValue();
                    mustread *= (long)(2 * this.channel);
                }
                AudioInput.log.info((Object)("mustread:" + mustread));
                skipped = 0L;
                bts2 = new byte[1024];
                while (skipped < skipbyte) {
                    r = skipped + (long)bts2.length < skipbyte ? bts2.length : (int)(skipbyte - skipped);
                    readed = binput.read(bts2, 0, r);
                    skipped += (long)readed;
                    if (readed == -1) break;
                }
                if (skipped > 0L) {
                    AudioInput.log.info((Object)("skipped:" + skipped));
                }
                bytes = new byte[1024];
                readed = 0L;
                read = 0;
                while (read != -1) {
                    if (this.canceling) break;
                    read = binput.read(bytes, 0, bytes.length);
                    if (read == -1) continue;
                    if (this.duration == -1.0) ** GOTO lbl40
                    if (readed + (long)read < mustread) {
                        this.outputStream.write(bytes, 0, read);
                    } else {
                        canwrite = (int)(mustread - readed);
                        this.outputStream.write(bytes, 0, canwrite);
                        readed += (long)canwrite;
                        AudioInput.log.info((Object)"over duration:");
                        break;
lbl40:
                        // 1 sources

                        this.outputStream.write(bytes, 0, read);
                    }
                    readed += (long)read;
                }
                AudioInput.log.info((Object)("audio readed:" + readed + " " + readed / 2L / (long)this.channel / (long)this.rate + "s"));
                if (!this.canceling && this.duration != -1.0) {
                    bts = new byte[1024];
                    writed = readed;
                    while (writed < mustread) {
                        w = writed + (long)bts.length < mustread ? bts.length : (int)(mustread - writed);
                        this.outputStream.write(bts, 0, w);
                        writed += (long)w;
                    }
                    AudioInput.log.info((Object)("fill 0 data:" + (writed - readed) + " " + (writed - readed) / 2L / (long)this.channel / (long)this.rate + "s"));
                }
                this.outputStream.flush();
                this.outputStream.close();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.ffreader.getProcess().destroy();
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
                this.copying = false;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.copying = false;
            }
        }
        finally {
            this.copying = false;
        }
    }

    public boolean isCanceling() {
        return this.canceling;
    }

    public void setCanceling(boolean canceling) {
        this.canceling = canceling;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public boolean isCopying() {
        return this.copying;
    }

    public void setCopying(boolean copying) {
        this.copying = copying;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public String getFfmpegPath() {
        return this.ffmpegPath;
    }

    public void setFfmpegPath(String ffmpegPath) {
        this.ffmpegPath = ffmpegPath;
    }

    public FFMpegPCMPipeReader getFfreader() {
        return this.ffreader;
    }

    public void setFfreader(FFMpegPCMPipeReader ffreader) {
        this.ffreader = ffreader;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(String inputPath) {
        this.inputPath = inputPath;
    }

    public PipedOutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(PipedOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public int getRate() {
        return this.rate;
    }

    public void setRate(int rate) {
        this.rate = rate;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public void setInputStream(PipedInputStream inputStream) {
        this.inputStream = inputStream;
    }
}

