/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.video;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import jp.sourceforge.akjrcp.text_douga.AudioData;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.VideoWriter;
import jp.sourceforge.akjrcp.text_douga.video.EffectableVideoData;
import jp.sourceforge.akjrcp.text_douga.video.PipedVideoWriter;
import jp.sourceforge.akjrcp.text_douga.video.TextDougaVideoUtils;

public class CopyVideoData
extends EffectableVideoData {
    private double duration = 3.0;
    private AudioData audioData;
    private boolean fitSize = true;
    private int bgColor = 0;

    public String toString() {
        return "duration=" + this.duration;
    }

    public double getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(double duration) {
        this.duration = duration;
    }

    @Override
    public int writeData(File dir, DougaPreference preference, int startIndex, int maxframe) throws IOException {
        File jpegFile;
        BufferedImage bgImage;
        int wf = 0;
        if (this.startEffect != null) {
            this.startEffect.setKeyFrame(startIndex);
        }
        if (startIndex > 0 && (bgImage = ImageIO.read(jpegFile = new File(dir, TextDougaVideoUtils.toFileName("", startIndex - 1, 5, "jpg")))) != null) {
            int frames;
            if (this.duration == -1.0) {
                frames = maxframe;
            } else {
                frames = (int)(preference.getFps() * this.duration);
                if (maxframe != 0 && maxframe < frames) {
                    frames = maxframe;
                }
            }
            wf = TextDougaVideoUtils.copyImage(bgImage, dir, startIndex, frames);
        }
        if (this.audioData != null) {
            this.audioData.setSynchLength((double)wf / preference.getFps());
        }
        if (wf > 0) {
            if (this.endEffect != null) {
                this.endEffect.setKeyFrame(startIndex + wf - 1);
            }
        } else if (this.startEffect != null) {
            this.startEffect.setKeyFrame(-9999);
        }
        return wf;
    }

    @Override
    public AudioData getAudioData() {
        return this.audioData;
    }

    @Override
    public void setAudioData(AudioData audioData) {
        this.audioData = audioData;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    public boolean isFitSize() {
        return this.fitSize;
    }

    public void setFitSize(boolean fitSize) {
        this.fitSize = fitSize;
    }

    @Override
    public double getTotalTime() {
        return this.duration;
    }

    @Override
    public int writeData(VideoWriter writer, DougaPreference preference) throws IOException {
        int maxframe = Math.max(0, writer.getMaxFrame() - writer.getWrited());
        int startIndex = writer.getWrited() + 1;
        if (this.startEffect != null) {
            this.startEffect.setKeyFrame(startIndex);
        }
        int wf = 0;
        if (startIndex > 1) {
            BufferedImage bgImage = null;
            if (writer instanceof PipedVideoWriter) {
                bgImage = ((PipedVideoWriter)writer).getLastImage();
            }
            if (bgImage != null) {
                int frames;
                if (this.duration == -1.0) {
                    frames = maxframe;
                } else {
                    frames = (int)(preference.getFps() * this.duration);
                    if (maxframe != 0 && maxframe < frames) {
                        frames = maxframe;
                    }
                }
                wf = TextDougaVideoUtils.copyImage(bgImage, this, writer, frames);
            }
        } else {
            log.warn((Object)"dont start copy first");
        }
        if (this.audioData != null) {
            this.audioData.setSynchLength((double)wf / preference.getFps());
        }
        if (wf > 0) {
            if (this.endEffect != null) {
                this.endEffect.setKeyFrame(startIndex + wf - 1);
            }
        } else if (this.startEffect != null) {
            this.startEffect.setKeyFrame(-9999);
        }
        return wf;
    }
}

