/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.views.syncsubimages;

import com.akjava.lib.commons.time.TimeUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;
import jp.sourceforge.akjrcp.subtitle.StandardSubObject;
import jp.sourceforge.akjrcp.text_douga.views.syncsubimages.SyncSubImageView;

public class SyncSubBuilder {
    private List<SyncImageData> syncImageDataList = new ArrayList<SyncImageData>();
    private File[] beforeFiles;
    String audioPath;
    String ffmpegPath;
    private int expandTime = 4;
    private long audioOffset;

    public List<ResultData> buildText() {
        ArrayList<ResultData> results = new ArrayList<ResultData>();
        double audioTime = (double)this.getAudioDuration() / 1000.0;
        SyncSubImageView.log.info((Object)("audioTime:" + audioTime));
        SyncImageData[] syncDatas = this.syncImageDataList.toArray(new SyncImageData[this.syncImageDataList.size()]);
        int index = 0;
        if (this.beforeFiles != null) {
            double startTime = 0.0;
            double endTime = this.expandTime;
            boolean finded = false;
            int i = index;
            while (i < syncDatas.length) {
                SyncImageData sdata = syncDatas[i];
                if (sdata.haveInsideFiles()) {
                    endTime = sdata.getSubtitle().getStartTimeAsDouble();
                    finded = true;
                    break;
                }
                if (sdata.haveAfterFiles()) {
                    endTime = sdata.getSubtitle().getEndTimeAsDouble();
                    finded = true;
                    break;
                }
                if (!finded) {
                    ++index;
                }
                ++i;
            }
            if (!finded && audioTime != 0.0) {
                endTime = audioTime;
            }
            this.toTexts(results, this.beforeFiles, startTime, endTime);
        }
        int j = index;
        while (j < syncDatas.length) {
            SyncImageData sdata2;
            int i;
            boolean finded;
            SyncImageData sdata = syncDatas[j];
            File[] insides = sdata.getInsideFiles();
            File[] afters = sdata.getAfterFiles();
            if (sdata.haveInsideFiles()) {
                if (sdata.haveAfterFiles()) {
                    this.toTexts(results, insides, sdata.getSubtitle().getStartTimeAsDouble(), sdata.getSubtitle().getEndTimeAsDouble());
                    double startTime = sdata.getSubtitle().getEndTimeAsDouble();
                    double endTime = sdata.getSubtitle().getEndTimeAsDouble() + (double)this.expandTime;
                    finded = false;
                    i = j + 1;
                    while (i < syncDatas.length) {
                        sdata2 = syncDatas[i];
                        if (sdata2.haveInsideFiles()) {
                            endTime = sdata2.getSubtitle().getStartTimeAsDouble();
                            finded = true;
                            break;
                        }
                        if (sdata2.haveAfterFiles()) {
                            endTime = sdata2.getSubtitle().getEndTimeAsDouble();
                            finded = true;
                            break;
                        }
                        ++i;
                    }
                    if (!finded && audioTime > 0.0 && audioTime > sdata.getSubtitle().getEndTimeAsDouble()) {
                        endTime = audioTime;
                    }
                    this.toTexts(results, afters, startTime, endTime);
                } else {
                    double startTime = sdata.getSubtitle().getStartTimeAsDouble();
                    double endTime = sdata.getSubtitle().getEndTimeAsDouble();
                    finded = false;
                    i = j + 1;
                    while (i < syncDatas.length) {
                        sdata2 = syncDatas[i];
                        if (sdata2.haveInsideFiles()) {
                            endTime = sdata2.getSubtitle().getStartTimeAsDouble();
                            finded = true;
                            break;
                        }
                        if (sdata2.haveAfterFiles()) {
                            endTime = sdata2.getSubtitle().getEndTimeAsDouble();
                            finded = true;
                            break;
                        }
                        ++i;
                    }
                    if (!finded && audioTime > endTime) {
                        endTime = audioTime;
                    }
                    SyncSubImageView.log.trace((Object)("endtime:" + endTime));
                    this.toTexts(results, insides, startTime, endTime);
                }
            } else if (sdata.haveAfterFiles()) {
                double startTime = sdata.getSubtitle().getEndTimeAsDouble();
                double endTime = sdata.getSubtitle().getEndTimeAsDouble() + (double)this.expandTime;
                finded = false;
                i = j + 1;
                while (i < syncDatas.length) {
                    sdata2 = syncDatas[i];
                    if (sdata2.haveInsideFiles()) {
                        endTime = sdata2.getSubtitle().getStartTimeAsDouble();
                        finded = true;
                        break;
                    }
                    if (sdata2.haveAfterFiles()) {
                        endTime = sdata2.getSubtitle().getEndTimeAsDouble();
                        finded = true;
                        break;
                    }
                    ++i;
                }
                if (!finded && audioTime > 0.0 && audioTime > sdata.getSubtitle().getEndTimeAsDouble()) {
                    endTime = audioTime;
                }
                this.toTexts(results, afters, startTime, endTime);
            }
            ++j;
        }
        return results;
    }

    public File[] getBeforeFiles() {
        return this.beforeFiles;
    }

    public String getAudioPath() {
        return this.audioPath;
    }

    public long getAudioDuration() {
        FFMpegFLVParser parser;
        FLVInfomation info;
        long ret = 0L;
        if (this.audioPath != null && (info = (parser = new FFMpegFLVParser(this.ffmpegPath)).parseFile(new File(this.audioPath))).getDuration() != null) {
            int[] vs = TimeUtils.toHourMinSecMilliSecond((String)info.getDuration());
            if (vs[3] < 100) {
                vs[3] = vs[3] * 10;
            }
            ret = TimeUtils.toMillisecond((int)vs[0], (int)vs[1], (int)vs[2], (int)vs[3]);
            ret -= this.audioOffset;
        }
        return ret;
    }

    public void toTexts(List<ResultData> results, File[] files, double start, double end) {
        if (files != null && files.length > 0) {
            double d = (end - start) / (double)files.length;
            double duration = TimeUtils.toBigDecimalTime((double)d);
            double current = 0.0;
            int i = 0;
            while (i < files.length) {
                double startValue = start + current;
                double durationValue = i == files.length - 1 ? end - (current + start) : duration;
                current += duration;
                results.add(new ResultData(files[i].getAbsolutePath(), startValue, durationValue));
                ++i;
            }
        }
    }

    public List<SyncImageData> getSyncImageDatas() {
        return this.syncImageDataList;
    }

    public void setSyncImageDatas(List<SyncImageData> syncImageDatas) {
        this.syncImageDataList = syncImageDatas;
    }

    public void setBeforeFiles(File[] beforeFiles) {
        this.beforeFiles = beforeFiles;
    }

    public void setAudioPath(String audioPath) {
        this.audioPath = audioPath;
    }

    public String getFfmpegPath() {
        return this.ffmpegPath;
    }

    public void setFfmpegPath(String ffmpegPath) {
        this.ffmpegPath = ffmpegPath;
    }

    public long getAudioOffset() {
        return this.audioOffset;
    }

    public void setAudioOffset(long audioOffset) {
        this.audioOffset = audioOffset;
    }

    public static class ResultData {
        private double start;
        private double duration;
        private String path;

        public ResultData(String path, double start, double duration) {
            this.start = start;
            this.duration = duration;
            this.path = path;
        }

        public String toString() {
            String header = "#start=" + TimeUtils.toBigDecimalTime((double)this.start) + ",duration=" + TimeUtils.toBigDecimalTime((double)this.duration) + "\n";
            header = String.valueOf(header) + this.path + "\n";
            return header;
        }

        public boolean equals(Object data) {
            if (data instanceof ResultData) {
                ResultData rd = (ResultData)data;
                String rdT = rd.path;
                return rd.start == this.start && rd.duration == this.duration && rdT.equals(this.path);
            }
            return false;
        }
    }

    public static class SyncImageData {
        private StandardSubObject subtitle;
        private File[] insideFiles;
        private File[] afterFiles;

        public SyncImageData(StandardSubObject subtitle, File[] insideFiles, File[] afterFiles) {
            this.subtitle = subtitle;
            this.insideFiles = insideFiles;
            this.afterFiles = afterFiles;
        }

        public StandardSubObject getSubtitle() {
            return this.subtitle;
        }

        public File[] getInsideFiles() {
            return this.insideFiles;
        }

        public boolean haveInsideFiles() {
            return this.insideFiles != null && this.insideFiles.length > 0;
        }

        public File[] getAfterFiles() {
            return this.afterFiles;
        }

        public boolean haveAfterFiles() {
            return this.afterFiles != null && this.afterFiles.length > 0;
        }
    }
}

