/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.views.syncsubimages;

import com.akjava.lib.swt.images.cashe.ResizedImageCache;
import com.akjava.lib.swt.ui.param.ParamTime;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.sourceforge.akjrcp.commons.ui.AbstractFileDirChoicer;
import jp.sourceforge.akjrcp.commons.ui.EditableFileList;
import jp.sourceforge.akjrcp.commons.ui.FileDirChoicer;
import jp.sourceforge.akjrcp.commons.ui.widget.LayoutDataBuilder;
import jp.sourceforge.akjrcp.commons.ui.widget.WidgetBuilder;
import jp.sourceforge.akjrcp.commons.util.ClipboardUtil;
import jp.sourceforge.akjrcp.commons.util.FileNameUtils;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUI;
import jp.sourceforge.akjrcp.subtitle.StandardSubObject;
import jp.sourceforge.akjrcp.subtitle.SubtitleUtils;
import jp.sourceforge.akjrcp.subtitle.srt.SRTList;
import jp.sourceforge.akjrcp.text_douga.parser.ParserUtils;
import jp.sourceforge.akjrcp.text_douga.parser.PropertyUtils;
import jp.sourceforge.akjrcp.text_douga.rcp.Messages;
import jp.sourceforge.akjrcp.text_douga.rcp.TextDougaView;
import jp.sourceforge.akjrcp.text_douga.views.syncsubimages.SyncSubBuilder;
import jp.sourceforge.akjrcp.util.TimeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class SyncSubImageView
extends ViewPart {
    public static Log log = LogFactory.getLog(SyncSubImageView.class);
    public static final String ID = SyncSubImageView.class.getName();
    private CCombo size;
    private CCombo fps;
    private int imageIndex;
    private FileDirChoicer inputSubtitle;
    private ScrolledComposite scroll;
    private Composite composite;
    private Composite baseComposite;
    private EditableFileList beforeFiles;
    private FileDirChoicer inputAudio;
    private Button execButton;
    private ResizedImageCache imageCache;
    private int imgWidth = 240;
    private int imgHeight = 135;
    private Menu popUpMenu;
    private double audioOffset;
    private ParamTime offsetTime;

    public String getSize() {
        return this.size.getText();
    }

    public String getFps() {
        return this.fps.getText();
    }

    public void createPartControl(Composite parent) {
        this.imageCache = new ResizedImageCache();
        this.imageCache.setWidth(this.imgWidth);
        this.imageCache.setHeight(this.imgHeight);
        this.imageCache.setMaxSize(100);
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout());
        Composite fields = WidgetBuilder.createTwoGridLayoutComposite((Composite)base, (int)0);
        this.size = this.createCCombo(fields, Messages.getString("exportimg.size"), new String[]{"", "160x120", "320x240", "640x480", "", "720x480", "", "320x180", "720x405", "1280x720", "", "320x176", "640x352"}, 0);
        this.size.setText("320x176");
        this.fps = this.createCCombo(fields, Messages.getString("exportimg.fps"), new String[]{"", "1", "5", "10", "12", "14.895", "15", "20", "24", "25", "29.97", "30"}, 0);
        this.fps.setText("5");
        this.inputSubtitle = new FileDirChoicer(base, 0, 0, Messages.getString("syncsub.subtitle"));
        this.inputSubtitle.setLayoutData((Object)LayoutDataBuilder.fillHorizontalGridData());
        this.inputSubtitle.setFilterExtensions(FileNameUtils.toMixFilterExtensions((String[])new String[]{"srt", "txt"}));
        this.inputSubtitle.addFileListChangeListener(new AbstractFileDirChoicer.FileStatusChangeListener(){

            public void addList(AbstractFileDirChoicer.FileStatusChangeEvent event) {
                SyncSubImageView.this.loadSubtitleFile();
            }

            public void removeList(AbstractFileDirChoicer.FileStatusChangeEvent event) {
            }
        });
        this.inputAudio = new FileDirChoicer(base, 0, 0, Messages.getString("syncsub.audio"));
        this.inputAudio.setLayoutData((Object)LayoutDataBuilder.fillHorizontalGridData());
        this.inputAudio.setFilterExtensions(FileNameUtils.toMixFilterExtensions((String[])ParserUtils.audios));
        this.baseComposite = new Composite(base, 0);
        this.baseComposite.setLayoutData((Object)new GridData(768));
        this.baseComposite.setLayout((Layout)new GridLayout(2, true));
        WidgetBuilder.createLabel((Composite)this.baseComposite, (String)Messages.getString("syncsub.before"));
        Composite otherControler = WidgetBuilder.createGridLayoutComposite((Composite)this.baseComposite, (int)0, (int)2, (boolean)false);
        Composite files = WidgetBuilder.createGridLayoutComposite((Composite)this.baseComposite, (int)0, (int)2, (boolean)false);
        files.setLayoutData((Object)new GridData(768));
        Label imgLabel = new Label(files, 2048);
        this.beforeFiles = WidgetBuilder.createFileList((Composite)files, (int)0, (String)"*.gif;*.png;*.jpg;*.bmp");
        this.beforeFiles.setLayoutData(LayoutDataBuilder.hintGridData((int)-1, (int)-1));
        this.beforeFiles.setShowNameOnly(true);
        this.beforeFiles.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SyncSubImageView.this.updateStatus();
            }
        });
        this.offsetTime = new ParamTime(otherControler, 2048, "time", Messages.getString("syncsub.offsettime"));
        imgLabel.setLayoutData((Object)LayoutDataBuilder.hintGridData((int)this.imgWidth, (int)this.imgHeight));
        UpdateLabelListener labelListener = new UpdateLabelListener(this.beforeFiles, imgLabel);
        this.beforeFiles.addPropertyChangeListener((IPropertyChangeListener)labelListener);
        this.beforeFiles.addSelectionChangedListener((ISelectionChangedListener)labelListener);
        this.scroll = new ScrolledComposite(base, 2560);
        GridData gdata = new GridData(1808);
        gdata.grabExcessVerticalSpace = true;
        this.scroll.setLayoutData((Object)gdata);
        this.composite = new Composite((Composite)this.scroll, 0);
        this.composite.setLayoutData((Object)new GridData(1808));
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.scroll.setContent((Control)this.composite);
        this.scroll.setMinSize(-1, 250);
        this.scroll.setExpandHorizontal(true);
        this.scroll.setExpandVertical(true);
        this.execButton = WidgetBuilder.createButton((Composite)base, (String)"exec");
        this.execButton.setEnabled(false);
        this.execButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SyncSubImageView.this.exec();
            }
        });
        this.createPopupMenus(base);
    }

    private void createPopupMenus(Composite base) {
        this.popUpMenu = new Menu((Decorations)this.getSite().getShell(), 8);
        base.setMenu(this.popUpMenu);
        MenuItem loadData = WidgetBuilder.createPushMenu((Menu)this.popUpMenu, (String)"load from clipboard");
        loadData.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String text = ClipboardUtil.getCurrentText((Display)SyncSubImageView.this.getSite().getShell().getDisplay());
                text = text.replace("\r\n", "\n");
                SyncSubImageView.this.loadText(text);
            }
        });
    }

    public void loadSubtitleFile() {
        File file = this.inputSubtitle.getFile();
        if (file.getName().toLowerCase().endsWith(".srt")) {
            try {
                this.beforeFiles.clear();
                SRTList list = SubtitleUtils.loadSrt((File)file, (String)"MS932");
                List subs = list.convertStandardSubtitleDataList();
                Control[] controls = this.composite.getChildren();
                int i = 0;
                while (i < controls.length) {
                    controls[i].dispose();
                    ++i;
                }
                log.info((Object)"disposed all");
                i = 0;
                while (i < subs.size()) {
                    SubtitleData data = new SubtitleData(this.composite, 2048);
                    data.setData((StandardSubObject)subs.get(i));
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.composite.layout();
            Control[] controls = this.composite.getChildren();
            int total = 0;
            int i = 0;
            while (i < controls.length) {
                total += controls[i].getBounds().height;
                ++i;
            }
            this.scroll.setMinSize(-1, total += 6 * controls.length);
        }
    }

    public void exec() {
        TextDougaView view = (TextDougaView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(TextDougaView.ID);
        view.setExportType(0);
        view.setExportMode(0);
        String text = "";
        text = this.getSize().length() > 0 ? String.valueOf(text) + "#export_size=" + this.getSize() : String.valueOf(text) + "#export_size=1280x736";
        text = String.valueOf(text) + "\n";
        text = this.getFps().length() > 0 ? String.valueOf(text) + "#export_fps=" + this.getFps() : String.valueOf(text) + "#export_fps=15";
        text = String.valueOf(text) + "\n";
        text = String.valueOf(text) + this.toTextDougaText();
        view.setText(text);
        view.updateUndoRedo();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)view);
    }

    protected void updateStatus() {
        boolean hasfile = false;
        if (this.beforeFiles.getFileList() != null && this.beforeFiles.getFileList().length > 0) {
            hasfile = true;
        }
        if (!hasfile) {
            Control[] controls = this.composite.getChildren();
            int i = 0;
            while (i < controls.length) {
                SubtitleData sdata = (SubtitleData)controls[i];
                if (sdata.getInsideFiles().getFileList() != null && sdata.getInsideFiles().getFileList().length > 0 || sdata.getAfterFiles().getFileList() != null && sdata.getAfterFiles().getFileList().length > 0) {
                    hasfile = true;
                    break;
                }
                ++i;
            }
        }
        if (hasfile) {
            this.execButton.setEnabled(true);
        } else {
            this.execButton.setEnabled(false);
        }
    }

    public String toTextDougaText() {
        String[] wh;
        SyncSubBuilder builder = new SyncSubBuilder();
        builder.setAudioOffset(this.offsetTime.getTime());
        builder.setFfmpegPath(FFMpegUI.getFFmpegOrPureFFMpeg());
        String text = "";
        if (!this.inputAudio.getAbsoluteFilePath().equals("")) {
            if (this.offsetTime.getTime() != 0L) {
                text = String.valueOf(text) + "#start=" + (double)this.offsetTime.getTime() / 1000.0 + "\n";
            }
            text = String.valueOf(text) + this.inputAudio.getAbsoluteFilePath() + "\n";
            builder.setAudioPath(this.inputAudio.getAbsoluteFilePath());
        } else {
            builder.setAudioPath(null);
        }
        text = String.valueOf(text) + "#default,fadein=0,fadeout=0";
        if (this.getSize().length() > 0 && (wh = this.getSize().split("x")).length > 1) {
            text = String.valueOf(text) + ",width=" + wh[0] + ",height=" + wh[1];
        }
        text = String.valueOf(text) + "\n";
        builder.setBeforeFiles(this.beforeFiles.getFileList());
        Control[] controls = this.composite.getChildren();
        ArrayList<SyncSubBuilder.SyncImageData> syncImageDataList = new ArrayList<SyncSubBuilder.SyncImageData>();
        int i = 0;
        while (i < controls.length) {
            SubtitleData sdata = (SubtitleData)controls[i];
            syncImageDataList.add(new SyncSubBuilder.SyncImageData(sdata.getData(), sdata.getInsideFiles().getFileList(), sdata.getAfterFiles().getFileList()));
            ++i;
        }
        builder.setSyncImageDatas(syncImageDataList);
        List<SyncSubBuilder.ResultData> resultDatas = builder.buildText();
        int i2 = 0;
        while (i2 < resultDatas.size()) {
            text = String.valueOf(text) + resultDatas.get(i2).toString();
            ++i2;
        }
        text = String.valueOf(text) + this.toSaveText();
        return text;
    }

    public double toDouble(String num, double defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        double ret = defaultValue;
        try {
            ret = Double.parseDouble(num);
        }
        catch (Exception exception) {}
        System.out.println(ret);
        return ret;
    }

    private CCombo createCCombo(Composite parent, String label, String[] values, int style) {
        Composite p2 = WidgetBuilder.createTwoGridLayoutComposite((Composite)parent, (int)0);
        WidgetBuilder.createLabel((Composite)p2, (String)label);
        CCombo combo = new CCombo(p2, style);
        combo.setLayoutData((Object)LayoutDataBuilder.hintGridData((int)100, (int)0));
        int i = 0;
        while (i < values.length) {
            combo.add(values[i]);
            ++i;
        }
        return combo;
    }

    public void setFocus() {
    }

    public void loadText(String text) {
        String[] lines = text.split("\n");
        boolean header = false;
        int index = 0;
        Control[] controls = null;
        int i = 0;
        while (i < lines.length) {
            if (!header) {
                if (lines[i].startsWith(";#syncsub")) {
                    header = true;
                    String[] paths = lines[i].split(",");
                    this.inputAudio.setFilePath(paths[1]);
                    if (paths[2].length() > 0) {
                        this.inputSubtitle.setFilePath(paths[2]);
                        this.loadSubtitleFile();
                    }
                    if (paths.length > 2) {
                        String last = lines[i].substring(paths[0].length() + paths[1].length() + 2);
                        Map<String, String> map = ParserUtils.lineToMap(last, "");
                        if (map.get("start") != null) {
                            double startTime = PropertyUtils.getDoubleValue(map.get("start"), 0.0);
                            this.offsetTime.setValue("" + startTime);
                        } else {
                            this.offsetTime.setValue("0");
                        }
                    }
                    controls = this.composite.getChildren();
                    this.beforeFiles.clear();
                    String[] befores = lines[++i].split(";");
                    int j = 0;
                    while (j < befores.length) {
                        if (befores[j].length() > 0) {
                            this.beforeFiles.addFilePath(befores[j]);
                        }
                        ++j;
                    }
                }
            } else if (lines[i].startsWith(";")) {
                String tmp = lines[i].substring(1);
                String[] in_af = tmp.split(",");
                if (controls != null && controls.length > index && in_af.length > 0) {
                    String[] insides = in_af[0].split(";");
                    int j = 0;
                    while (j < insides.length) {
                        SubtitleData sdata = (SubtitleData)controls[index];
                        if (insides[j].length() > 0) {
                            sdata.getInsideFiles().addFilePath(insides[j]);
                            sdata.layout();
                        }
                        ++j;
                    }
                    if (in_af.length > 1) {
                        String[] afters = in_af[1].split(";");
                        int j2 = 0;
                        while (j2 < afters.length) {
                            SubtitleData sdata = (SubtitleData)controls[index];
                            if (afters[j2].length() > 0) {
                                sdata.getAfterFiles().addFilePath(afters[j2]);
                                sdata.layout();
                            }
                            ++j2;
                        }
                    }
                }
                ++index;
            }
            ++i;
        }
    }

    public String toSaveText() {
        String text = ";#syncsub1.0,";
        String options = "";
        if (this.offsetTime.getTime() != 0L) {
            options = String.valueOf(options) + ",start=" + (double)this.offsetTime.getTime() / 1000.0;
        }
        text = String.valueOf(text) + this.inputAudio.getAbsoluteFilePath() + "," + this.inputSubtitle.getAbsoluteFilePath() + options + "\n";
        String befores = "";
        File[] file = this.beforeFiles.getFileList();
        int j = 0;
        while (j < file.length) {
            befores = String.valueOf(befores) + file[j].getAbsolutePath();
            if (j != file.length - 1) {
                befores = String.valueOf(befores) + ";";
            }
            ++j;
        }
        text = String.valueOf(text) + ";" + befores + "\n";
        Control[] controls = this.composite.getChildren();
        int i = 0;
        while (i < controls.length) {
            SubtitleData sdata = (SubtitleData)controls[i];
            String insides = "";
            if (sdata.getInsideFiles().getFileList() != null) {
                File[] files = sdata.getInsideFiles().getFileList();
                int j2 = 0;
                while (j2 < files.length) {
                    insides = String.valueOf(insides) + files[j2].getAbsolutePath();
                    if (j2 != files.length - 1) {
                        insides = String.valueOf(insides) + ";";
                    }
                    ++j2;
                }
            }
            String afters = "";
            if (sdata.getAfterFiles().getFileList() != null) {
                File[] files = sdata.getAfterFiles().getFileList();
                int j3 = 0;
                while (j3 < files.length) {
                    afters = String.valueOf(afters) + files[j3].getAbsolutePath();
                    if (j3 != files.length - 1) {
                        afters = String.valueOf(afters) + ";";
                    }
                    ++j3;
                }
            }
            text = String.valueOf(text) + ";" + insides + "," + afters + "\n";
            ++i;
        }
        return text;
    }

    public class SubtitleData
    extends Composite {
        private EditableFileList insideFiles;
        private EditableFileList afterFiles;
        private Label startTime;
        private Label text;
        private Label endTime;
        StandardSubObject data;

        public SubtitleData(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new GridLayout());
            this.setLayoutData(new GridData(768));
            this.text = new Label((Composite)this, 2048);
            this.text.setLayoutData((Object)new GridData(768));
            Composite centerSplit = WidgetBuilder.createGridLayoutComposite((Composite)this, (int)0, (int)2, (boolean)true);
            centerSplit.setLayoutData((Object)new GridData(768));
            Composite files1 = WidgetBuilder.createGridLayoutComposite((Composite)centerSplit, (int)0, (int)2, (boolean)false);
            Composite files2 = WidgetBuilder.createGridLayoutComposite((Composite)centerSplit, (int)0, (int)2, (boolean)false);
            files1.setLayoutData((Object)new GridData(768));
            files2.setLayoutData((Object)new GridData(768));
            Composite timeAndImage = WidgetBuilder.createGridLayoutComposite((Composite)files1, (int)0);
            this.startTime = new Label(timeAndImage, 0);
            Label imgLabel = new Label(timeAndImage, 2048);
            this.insideFiles = WidgetBuilder.createFileList((Composite)files1, (int)0, (String)"*.gif;*.png;*.jpg;*.bmp");
            this.insideFiles.setShowNameOnly(true);
            this.insideFiles.setLayoutData(LayoutDataBuilder.hintGridData((int)-1, (int)-1));
            this.insideFiles.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    SyncSubImageView.this.updateStatus();
                }
            });
            imgLabel.setLayoutData((Object)LayoutDataBuilder.hintGridData((int)SyncSubImageView.this.imgWidth, (int)SyncSubImageView.this.imgHeight));
            UpdateLabelListener labelListener = new UpdateLabelListener(this.insideFiles, imgLabel);
            this.insideFiles.addPropertyChangeListener((IPropertyChangeListener)labelListener);
            this.insideFiles.addSelectionChangedListener((ISelectionChangedListener)labelListener);
            Composite timeAndImage2 = WidgetBuilder.createGridLayoutComposite((Composite)files2, (int)0);
            this.endTime = new Label(timeAndImage2, 0);
            Label imgLabel2 = new Label(timeAndImage2, 2048);
            this.afterFiles = WidgetBuilder.createFileList((Composite)files2, (int)0, (String)"*.gif;*.png;*.jpg;*.bmp");
            this.afterFiles.setLayoutData(LayoutDataBuilder.hintGridData((int)-1, (int)-1));
            this.afterFiles.setShowNameOnly(true);
            this.afterFiles.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    SyncSubImageView.this.updateStatus();
                }
            });
            imgLabel2.setLayoutData((Object)LayoutDataBuilder.hintGridData((int)SyncSubImageView.this.imgWidth, (int)SyncSubImageView.this.imgHeight));
            UpdateLabelListener labelListener2 = new UpdateLabelListener(this.afterFiles, imgLabel2);
            this.afterFiles.addPropertyChangeListener((IPropertyChangeListener)labelListener2);
            this.afterFiles.addSelectionChangedListener((ISelectionChangedListener)labelListener2);
        }

        public void setData(StandardSubObject subObject) {
            this.text.setText(subObject.getText());
            this.startTime.setText(TimeUtils.toTimeText((long)subObject.getStartTime()));
            this.endTime.setText(TimeUtils.toTimeText((long)subObject.getEndTime()));
            this.data = subObject;
        }

        public StandardSubObject getData() {
            return this.data;
        }

        public EditableFileList getInsideFiles() {
            return this.insideFiles;
        }

        public EditableFileList getAfterFiles() {
            return this.afterFiles;
        }
    }

    public class UpdateLabelListener
    implements IPropertyChangeListener,
    ISelectionChangedListener {
        private Label target;
        private EditableFileList fileList;

        public UpdateLabelListener(EditableFileList fileList, Label target) {
            this.target = target;
            this.fileList = fileList;
        }

        public void updateImage() {
            if (this.fileList.getFileList() == null || this.fileList.getFileList().length == 0) {
                log.trace((Object)"no image");
                this.target.setImage(null);
            } else {
                log.info((Object)("property change:" + this.fileList.getFileList().length));
                File[] selections = this.fileList.getSelectionFiles();
                Image img = selections.length == 0 ? SyncSubImageView.this.imageCache.loadImage(this.fileList.getFileList()[this.fileList.getFileList().length - 1]) : SyncSubImageView.this.imageCache.loadImage(selections[0]);
                if (img != null) {
                    log.trace((Object)img.getBounds());
                }
                this.target.setImage(img);
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            this.updateImage();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.updateImage();
        }
    }
}

