/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.wizards.tmp;

import java.io.File;
import java.io.IOException;
import java.util.List;
import jp.sourceforge.akjrcp.commons.ui.AbstractFileDirChoicer;
import jp.sourceforge.akjrcp.commons.ui.EditableFileList;
import jp.sourceforge.akjrcp.commons.ui.FileDirChoicer;
import jp.sourceforge.akjrcp.commons.ui.widget.LayoutDataBuilder;
import jp.sourceforge.akjrcp.commons.ui.widget.WidgetBuilder;
import jp.sourceforge.akjrcp.commons.util.FileNameUtils;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUI;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;
import jp.sourceforge.akjrcp.subtitle.StandardSubObject;
import jp.sourceforge.akjrcp.subtitle.SubtitleUtils;
import jp.sourceforge.akjrcp.subtitle.srt.SRTList;
import jp.sourceforge.akjrcp.text_douga.parser.ParserUtils;
import jp.sourceforge.akjrcp.text_douga.rcp.Messages;
import jp.sourceforge.akjrcp.util.TimeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SubtitleSyncPage
extends WizardPage {
    public static Log log = LogFactory.getLog(SubtitleSyncPage.class);
    private int imageIndex;
    private FileDirChoicer inputSubtitle;
    private ScrolledComposite scroll;
    private Composite composite;
    private Composite baseComposite;
    private EditableFileList beforeFiles;
    private EditableFileList afterFiles;
    private FileDirChoicer inputAudio;

    protected SubtitleSyncPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString("importimg.input_title"));
        this.setDescription(Messages.getString("importimg.input_description"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout());
        this.setControl((Control)base);
        this.inputSubtitle = new FileDirChoicer(base, 0, 0, Messages.getString("syncsub.subtitle"));
        this.inputSubtitle.setLayoutData((Object)LayoutDataBuilder.fillHorizontalGridData());
        this.inputSubtitle.setFilterExtensions(FileNameUtils.toMixFilterExtensions((String[])new String[]{"srt", "txt"}));
        this.inputSubtitle.addFileListChangeListener(new AbstractFileDirChoicer.FileStatusChangeListener(){

            public void addList(AbstractFileDirChoicer.FileStatusChangeEvent event) {
                File file = SubtitleSyncPage.this.inputSubtitle.getFile();
                if (file.getName().toLowerCase().endsWith(".srt")) {
                    try {
                        SRTList list = SubtitleUtils.loadSrt((File)file, (String)"MS932");
                        List subs = list.convertStandardSubtitleDataList();
                        Control[] controls = SubtitleSyncPage.this.composite.getChildren();
                        int i = 0;
                        while (i < controls.length) {
                            controls[i].dispose();
                            ++i;
                        }
                        log.info((Object)"disposed all");
                        i = 0;
                        while (i < subs.size()) {
                            SubtitleData data = new SubtitleData(SubtitleSyncPage.this.composite, 2048);
                            data.setData((StandardSubObject)subs.get(i));
                            ++i;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    SubtitleSyncPage.this.composite.layout();
                    Control[] controls = SubtitleSyncPage.this.composite.getChildren();
                    int total = 0;
                    int i = 0;
                    while (i < controls.length) {
                        total += controls[i].getBounds().height;
                        ++i;
                    }
                    SubtitleSyncPage.this.scroll.setMinSize(-1, total += 6 * controls.length);
                }
            }

            public void removeList(AbstractFileDirChoicer.FileStatusChangeEvent event) {
            }
        });
        this.inputAudio = new FileDirChoicer(base, 0, 0, Messages.getString("syncsub.audio"));
        this.inputAudio.setLayoutData((Object)LayoutDataBuilder.fillHorizontalGridData());
        this.inputAudio.setFilterExtensions(FileNameUtils.toMixFilterExtensions((String[])ParserUtils.audios));
        this.baseComposite = new Composite(base, 0);
        this.baseComposite.setLayoutData((Object)new GridData(768));
        this.baseComposite.setLayout((Layout)new GridLayout(2, true));
        WidgetBuilder.createLabel((Composite)this.baseComposite, (String)Messages.getString("syncsub.before"));
        WidgetBuilder.createLabel((Composite)this.baseComposite, (String)Messages.getString("syncsub.after"));
        this.beforeFiles = WidgetBuilder.createFileList((Composite)this.baseComposite, (int)0, (String)"*.gif;*.png;*.jpg;*.bmp");
        this.beforeFiles.setLayoutData(new GridData(768));
        this.beforeFiles.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SubtitleSyncPage.this.updateStatus();
            }
        });
        this.afterFiles = WidgetBuilder.createFileList((Composite)this.baseComposite, (int)0, (String)"*.gif;*.png;*.jpg;*.bmp");
        this.afterFiles.setLayoutData(new GridData(768));
        this.afterFiles.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SubtitleSyncPage.this.updateStatus();
            }
        });
        this.scroll = new ScrolledComposite(base, 2560);
        GridData gdata = new GridData(1808);
        gdata.grabExcessVerticalSpace = true;
        this.scroll.setLayoutData((Object)gdata);
        this.composite = new Composite((Composite)this.scroll, 0);
        this.composite.setLayoutData((Object)new GridData(1808));
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.scroll.setContent((Control)this.composite);
        this.scroll.setMinSize(-1, 250);
        this.scroll.setExpandHorizontal(true);
        this.scroll.setExpandVertical(true);
    }

    protected void updateStatus() {
        boolean hasfile = false;
        if (this.beforeFiles.getFileList() != null && this.beforeFiles.getFileList().length > 0 || this.afterFiles.getFileList() != null && this.afterFiles.getFileList().length > 0) {
            hasfile = true;
        }
        if (!hasfile) {
            Control[] controls = this.composite.getChildren();
            int i = 0;
            while (i < controls.length) {
                SubtitleData sdata = (SubtitleData)controls[i];
                if (sdata.getInsideFiles().getFileList() != null && sdata.getInsideFiles().getFileList().length > 0 || sdata.getAfterFiles().getFileList() != null && sdata.getAfterFiles().getFileList().length > 0) {
                    hasfile = true;
                    break;
                }
                ++i;
            }
        }
        if (hasfile) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    public String getTimingText() {
        String text = "";
        if (!this.inputAudio.getAbsoluteFilePath().equals("")) {
            text = String.valueOf(text) + this.inputAudio.getAbsoluteFilePath() + "\n";
        }
        Control[] controls = this.composite.getChildren();
        File[] befores = this.beforeFiles.getFileList();
        if (befores != null) {
            double firstSubTime = 0.0;
            firstSubTime = controls.length == 0 ? 4.0 : (double)((SubtitleData)controls[0]).getData().getStartTime() / 1000.0;
            if (firstSubTime != 0.0) {
                double duration = firstSubTime / (double)befores.length;
                double current = 0.0;
                int i = 0;
                while (i < befores.length) {
                    String header = "#start=" + current + ",duration=";
                    header = i == befores.length - 1 ? String.valueOf(header) + (firstSubTime - current) : String.valueOf(header) + duration;
                    current += duration;
                    text = String.valueOf(text) + header + "\n";
                    text = String.valueOf(text) + befores[i].getAbsolutePath() + "\n";
                    ++i;
                }
            }
        }
        int i = 0;
        while (i < controls.length) {
            SubtitleData cfr_ignored_0 = (SubtitleData)controls[i];
            ++i;
        }
        File[] afters = this.afterFiles.getFileList();
        if (afters != null) {
            double lastSubTime = 0.0;
            double lastSubDuration = 4.0;
            lastSubTime = controls.length == 0 ? 4.0 : (double)((SubtitleData)controls[controls.length - 1]).getData().getEndTime() / 1000.0;
            double audioTime = (double)this.getAudioDuration() / 1000.0;
            log.info((Object)audioTime);
            if (audioTime != 0.0 && audioTime > lastSubTime) {
                lastSubDuration = audioTime - lastSubTime;
            }
            if (lastSubTime != 0.0) {
                double duration = lastSubDuration / (double)afters.length;
                double current = lastSubTime;
                int i2 = 0;
                while (i2 < afters.length) {
                    String header = "#start=" + current + ",duration=";
                    header = i2 == afters.length - 1 ? String.valueOf(header) + (lastSubDuration - duration * (double)i2) : String.valueOf(header) + duration;
                    current += duration;
                    text = String.valueOf(text) + header + "\n";
                    text = String.valueOf(text) + afters[i2].getAbsolutePath() + "\n";
                    ++i2;
                }
            }
        }
        return text;
    }

    public double toDouble(String num, double defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        double ret = defaultValue;
        try {
            ret = Double.parseDouble(num);
        }
        catch (Exception exception) {}
        System.out.println(ret);
        return ret;
    }

    public long getAudioDuration() {
        FFMpegFLVParser parser;
        FLVInfomation info;
        long ret = 0L;
        if (!this.inputAudio.getAbsoluteFilePath().equals("") && (info = (parser = new FFMpegFLVParser(FFMpegUI.getFFmpegOrPureFFMpeg())).parseFile(this.inputAudio.getFile())).getDuration() != null) {
            int[] vs = TimeUtils.toHourMinSecMilliSecond((String)info.getDuration());
            if (vs[3] < 100) {
                vs[3] = vs[3] * 10;
            }
            ret = TimeUtils.toMillisecond((int)vs[0], (int)vs[1], (int)vs[2], (int)vs[3]);
        }
        return ret;
    }

    public class SubtitleData
    extends Composite {
        private EditableFileList insideFiles;
        private EditableFileList afterFiles;
        private Label startTime;
        private Label text;
        private Label endTime;
        StandardSubObject data;

        public SubtitleData(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new GridLayout());
            this.setLayoutData(new GridData(768));
            this.text = new Label((Composite)this, 2048);
            this.text.setLayoutData((Object)new GridData(768));
            Composite files = WidgetBuilder.createGridLayoutComposite((Composite)this, (int)0, (int)2, (boolean)true);
            files.setLayoutData((Object)new GridData(768));
            this.startTime = new Label(files, 0);
            this.startTime.setLayoutData((Object)new GridData(768));
            this.endTime = new Label(files, 0);
            this.startTime.setLayoutData((Object)new GridData(768));
            this.insideFiles = WidgetBuilder.createFileList((Composite)files, (int)0, (String)"*.gif;*.png;*.jpg;*.bmp");
            this.insideFiles.setLayoutData(new GridData(768));
            this.insideFiles.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    SubtitleSyncPage.this.updateStatus();
                }
            });
            this.afterFiles = WidgetBuilder.createFileList((Composite)files, (int)0, (String)"*.gif;*.png;*.jpg;*.bmp");
            this.afterFiles.setLayoutData(new GridData(768));
            this.afterFiles.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    SubtitleSyncPage.this.updateStatus();
                }
            });
        }

        public void setData(StandardSubObject subObject) {
            this.text.setText(subObject.getText());
            this.startTime.setText(TimeUtils.toTimeText((long)subObject.getStartTime()));
            this.endTime.setText(TimeUtils.toTimeText((long)subObject.getEndTime()));
            this.data = subObject;
        }

        public StandardSubObject getData() {
            return this.data;
        }

        public EditableFileList getInsideFiles() {
            return this.insideFiles;
        }

        public EditableFileList getAfterFiles() {
            return this.afterFiles;
        }
    }
}

