/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.lib.standards.ffmpeg.parser;

import com.akjava.lib.commons.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.NumberUtils;

public class FFMpegInfomation {
    private String ffmpegVersion;
    private byte fileSize;
    private String inputName;
    private List<AudioInfomation> audioInfomationList = new ArrayList<AudioInfomation>();
    private VideoInfomation video;
    private String durationText;
    private String format;
    private long playTime;
    private String text;

    public int countAudios() {
        return this.audioInfomationList.size();
    }

    public AudioInfomation getAudio(int index) {
        return this.audioInfomationList.get(index);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(null, ToStringStyle.MULTI_LINE_STYLE);
        builder.append("video", (Object)this.getVideo());
        int i = 0;
        while (i < this.countAudios()) {
            builder.append("audio", (Object)this.getAudio(i));
            ++i;
        }
        builder.append("duration", (Object)this.getDurationText());
        builder.append("format", (Object)this.getFormat());
        return builder.toString();
    }

    public byte getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(byte fileSize) {
        this.fileSize = fileSize;
    }

    public long getPlayTime() {
        return this.playTime;
    }

    public void setPlayTime(long playTime) {
        this.playTime = playTime;
    }

    public boolean isHaveAudio() {
        return this.countAudios() > 0;
    }

    public boolean isHaveVideo() {
        return this.video != null;
    }

    public String getRawText() {
        return this.text;
    }

    public void setRawText(String text) {
        this.text = text;
    }

    public VideoInfomation getVideo() {
        return this.video;
    }

    public void setVideo(VideoInfomation video) {
        this.video = video;
    }

    public String getDurationText() {
        return this.durationText;
    }

    public void setDurationText(String durationText) {
        this.durationText = durationText;
    }

    public void addAudio(AudioInfomation audio) {
        this.audioInfomationList.add(audio);
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFFmpegVersion() {
        return this.ffmpegVersion;
    }

    public void setFFmpegVersion(String ffmpegVersion) {
        this.ffmpegVersion = ffmpegVersion;
    }

    public int getFFmpegVersionNumber() {
        if (this.ffmpegVersion == null) {
            return 0;
        }
        String number = TextUtils.getDigitsText((String)this.ffmpegVersion);
        return NumberUtils.toInt((String)number, (int)0);
    }

    public boolean isSuccessed() {
        return this.text != null && (this.text.indexOf("Must supply at least one output file") != -1 || this.text.indexOf("At least one output file must be specified") != -1);
    }

    public static class AudioInfomation {
        private String audioCodec;
        private int audioChannel;
        private int audioRate;
        private int audioBitrate;

        public String getAudioCodec() {
            return this.audioCodec;
        }

        public void setAudioCodec(String audioCodec) {
            this.audioCodec = audioCodec;
        }

        public int getAudioChannel() {
            return this.audioChannel;
        }

        public void setAudioChannel(int audioChannel) {
            this.audioChannel = audioChannel;
        }

        public int getAudioRate() {
            return this.audioRate;
        }

        public void setAudioRate(int audioRate) {
            this.audioRate = audioRate;
        }

        public int getAudioBitrate() {
            return this.audioBitrate;
        }

        public void setAudioBitrate(int audioBitrate) {
            this.audioBitrate = audioBitrate;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }

        public boolean equals(Object object) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)object);
        }
    }

    public static class VideoInfomation {
        private String videoCodec;
        private int width;
        private int height;
        private int bitrate;
        private String aspectRatio;
        private double videoRate;

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }

        public boolean equals(Object object) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)object);
        }

        public String getVideoCodec() {
            return this.videoCodec;
        }

        public void setVideoCodec(String videoCodec) {
            this.videoCodec = videoCodec;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int getBitrate() {
            return this.bitrate;
        }

        public void setBitrate(int bitrate) {
            this.bitrate = bitrate;
        }

        public String getAspectRatio() {
            return this.aspectRatio;
        }

        public void setAspectRatio(String aspectRatio) {
            this.aspectRatio = aspectRatio;
        }

        public double getVideoRate() {
            return this.videoRate;
        }

        public void setVideoRate(double videoRate) {
            this.videoRate = videoRate;
        }
    }
}

