/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.lib.standards.ffmpeg.parser;

import com.akjava.lib.standards.ffmpeg.parser.FFMpegInfomation;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FFMpegInfomationParser {
    public static Log log = LogFactory.getLog(FFMpegInfomationParser.class);
    private int audioIndex;
    private String logText;
    private long maxoverwait = 3000L;
    private static final Pattern ratePattern = Pattern.compile("Seems that stream.*-> (.*) \\(.*");
    private static final Pattern ratePattern2 = Pattern.compile("Seems stream .* codec frame rate differs from container frame rate:.*-> (.*) \\(.*");
    private static final Pattern videoPattern = Pattern.compile(".*Stream #.* Video:(.*)$");
    private static final Pattern audioPattern = Pattern.compile(".*Stream #.* Audio:(.*)$");

    public FFMpegInfomation parseString(String logText) {
        this.audioIndex = 0;
        FFMpegInfomation info = new FFMpegInfomation();
        FFMpegInfomation.VideoInfomation video = new FFMpegInfomation.VideoInfomation();
        info.setRawText(StringUtils.replace((String)logText, (String)"\n", (String)"\r\n"));
        if (logText == null) {
            return null;
        }
        String[] lines = logText.split("\n");
        int i = 0;
        while (i < lines.length) {
            block35: {
                Matcher match = ratePattern.matcher(lines[i]);
                Matcher match2 = ratePattern2.matcher(lines[i]);
                int matchDuration = lines[i].indexOf("Duration:");
                if (match.matches()) {
                    video.setVideoRate(Double.parseDouble(match.group(1)));
                } else if (match2.matches()) {
                    video.setVideoRate(Double.parseDouble(match2.group(1)));
                } else if (matchDuration != -1) {
                    String[] d_s_b = lines[i].split(",");
                    String duration = d_s_b[0].substring(matchDuration + "Duration: ".length());
                    if (duration.equals("N/A")) {
                        duration = "00:00:00.0";
                    }
                    info.setDurationText(duration);
                } else if (lines[i].startsWith("Input ")) {
                    String[] tmp = lines[i].split(",");
                    if (tmp.length > 1) {
                        info.setFormat(StringUtils.deleteWhitespace((String)tmp[1]));
                    }
                } else if (lines[i].indexOf("FFmpeg version") != -1) {
                    String[] tmps = lines[i].split(",");
                    String v = tmps[0].substring("FFmpeg version".length());
                    info.setFFmpegVersion(StringUtils.deleteWhitespace((String)v));
                } else {
                    match = videoPattern.matcher(lines[i]);
                    if (match.matches()) {
                        try {
                            log.trace((Object)lines[i]);
                            info.setVideo(video);
                            String[] values = match.group(1).replaceAll(" ", "").split(",");
                            if (values.length < 3) break block35;
                            this.parseVideoCodec(video, values[0]);
                            this.parseVideoSize(video, values[2]);
                            if (values.length < 4) break block35;
                            if (values[3].endsWith("fps(r)")) {
                                this.parseVideoRate(video, values[3]);
                                break block35;
                            }
                            if (values[3].endsWith("tb(r)")) {
                                this.parseVideoRateForNewVersion(video, values[3]);
                                break block35;
                            }
                            if (values.length < 5) break block35;
                            if (values[4].endsWith("tb(r)")) {
                                this.parseVideoRateForNewVersion(video, values[4]);
                                break block35;
                            }
                            this.parseVideoRate(video, values[4]);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            log.warn((Object)e.getMessage());
                        }
                    } else {
                        match = audioPattern.matcher(lines[i]);
                        if (match.matches()) {
                            try {
                                log.trace((Object)lines[i]);
                                FFMpegInfomation.AudioInfomation audio = new FFMpegInfomation.AudioInfomation();
                                info.addAudio(audio);
                                String[] values = match.group(1).replaceAll(" ", "").split(",");
                                audio.setAudioCodec(values[0]);
                                if (values.length > 1) {
                                    int audioRate = values[1].toLowerCase().endsWith("hz") ? Integer.parseInt(values[1].substring(0, values[1].length() - 2)) : (values[1].toLowerCase().endsWith("kbhz") ? Integer.parseInt(values[1].substring(0, values[1].length() - 4)) : (values[1].toLowerCase().endsWith("kb/s") ? Integer.parseInt(values[1].substring(0, values[1].length() - 4)) : 0));
                                    audio.setAudioRate(audioRate);
                                    if (values.length > 2) {
                                        int audioChannel = 0;
                                        if (values[2].equals("stereo")) {
                                            audioChannel = 2;
                                        } else if (values[2].equals("mono")) {
                                            audioChannel = 1;
                                        } else {
                                            log.warn((Object)("unknown channel:" + values[2]));
                                        }
                                        audio.setAudioChannel(audioChannel);
                                        if (values.length > 3) {
                                            String bitString = null;
                                            if (values[3].toLowerCase().endsWith("kb/s")) {
                                                bitString = values[3];
                                            } else if (values.length > 4 && values[4].toLowerCase().endsWith("kb/s")) {
                                                bitString = values[4];
                                            }
                                            if (bitString != null) {
                                                int audioBitrate = Integer.parseInt(bitString.substring(0, bitString.length() - 4));
                                                audio.setAudioBitrate(audioBitrate);
                                            }
                                        }
                                    }
                                }
                                ++this.audioIndex;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                log.warn((Object)e.getMessage());
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return info;
    }

    private void parseVideoRate(FFMpegInfomation.VideoInfomation info, String string) {
        String value = StringUtils.replace((String)string, (String)"fps(r)", (String)"");
        try {
            info.setVideoRate(Double.parseDouble(value));
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
    }

    private void parseVideoRateForNewVersion(FFMpegInfomation.VideoInfomation info, String string) {
        String value = StringUtils.replace((String)string, (String)"tb(r)", (String)"");
        try {
            info.setVideoRate(Double.parseDouble(value));
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
    }

    private void parseVideoSize(FFMpegInfomation.VideoInfomation info, String string) {
        String[] wh = string.split("x");
        if (wh.length == 2) {
            info.setWidth(Integer.parseInt(wh[0]));
            if (wh[1].indexOf("[") != -1) {
                String[] h_info = wh[1].split("\\[");
                info.setHeight(Integer.parseInt(h_info[0]));
                if (string.indexOf("DAR16:9") != -1) {
                    info.setAspectRatio("16:9");
                } else if (string.indexOf("DAR4:3") != -1) {
                    info.setAspectRatio("4:3");
                }
            } else {
                info.setHeight(Integer.parseInt(wh[1]));
            }
        }
    }

    private void parseVideoCodec(FFMpegInfomation.VideoInfomation info, String string) {
        info.setVideoCodec(string);
    }

    public String getLogText() {
        return this.logText;
    }

    public long getMaxoverwait() {
        return this.maxoverwait;
    }

    public void setMaxoverwait(long maxoverwait) {
        this.maxoverwait = maxoverwait;
    }
}

