/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.lib.standards.ffmpeg.parser;

import com.akjava.lib.standards.process.ProcessMonitor;
import com.akjava.lib.standards.process.SimpleProcessPrinter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FFMpegParserExecuter {
    public static Log log = LogFactory.getLog(FFMpegParserExecuter.class);
    private String ffmpegPath;
    private long maxoverwait = 3000L;

    public FFMpegParserExecuter(String ffmpegPath) {
        this.ffmpegPath = ffmpegPath;
    }

    public String getInfomationText(String filePath) throws IOException {
        String[] command = new String[]{this.ffmpegPath, "-i", filePath};
        return this.getText(command);
    }

    public String getInfomationText(String filePath, String[] options) throws IOException {
        String[] newCommand = new String[options.length + 3];
        newCommand[0] = this.ffmpegPath;
        newCommand[1] = "-i";
        newCommand[2] = filePath;
        int i = 0;
        while (i < options.length) {
            newCommand[i + 3] = options[i];
            ++i;
        }
        return this.getText(newCommand);
    }

    private String getText(String[] command) throws IOException {
        if (command[0] == null || command[0].equals("") || !new File(command[0]).exists()) {
            throw new IOException("ffmpeg not found:" + command[0]);
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(command);
            SimpleProcessPrinter printer = new SimpleProcessPrinter();
            ProcessMonitor monitor = new ProcessMonitor(process, printer);
            monitor.startMonitor();
            try {
                process.waitFor();
                long c = System.currentTimeMillis();
                while (System.currentTimeMillis() < c + this.maxoverwait) {
                    if (!monitor.isErrorClosed() || !monitor.isInputClosed()) {
                        log.trace((Object)"wait:input reading");
                        Thread.sleep(100L);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                log.warn((Object)"wait:input reading");
                e.printStackTrace();
            }
            return printer.getLog();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFormatText() throws IOException {
        String[] command = new String[]{this.ffmpegPath, "-format"};
        return this.getText(command);
    }

    public String getHelpText() throws IOException {
        String[] command = new String[]{this.ffmpegPath, "-h"};
        return this.getText(command);
    }
}

