/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.lib.standards.images;

import com.akjava.lib.standards.images.ImageTurner;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;

public class ImageUtils {
    private static String[] imageExtensions = new String[]{"png", "jpg", "jpeg", "gif"};

    public static BufferedImage toRGB(BufferedImage img) {
        BufferedImage ret = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        ret.getGraphics().drawImage(img, 0, 0, null);
        return ret;
    }

    public static void writeJpegWithQuality(BufferedImage image, File file, float quality) throws IOException {
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> imageWriterIterator = ImageIO.getImageWritersByFormatName("jpeg");
        if (imageWriterIterator.hasNext()) {
            imageWriter = imageWriterIterator.next();
        }
        if (imageWriter == null) {
            throw new IOException("imageWriter not found");
        }
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);
        imageWriter.setOutput(imageOutputStream);
        IIOImage iioImage = new IIOImage(image, null, null);
        JPEGImageWriteParam imageWriteParam = new JPEGImageWriteParam(null);
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionQuality(quality);
        imageWriter.write(null, iioImage, imageWriteParam);
        imageOutputStream.close();
        imageWriter.dispose();
    }

    public static void writeJpegWithQuality(BufferedImage image, OutputStream output, float quality) throws IOException {
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> imageWriterIterator = ImageIO.getImageWritersByFormatName("jpeg");
        if (imageWriterIterator.hasNext()) {
            imageWriter = imageWriterIterator.next();
        }
        if (imageWriter == null) {
            throw new IOException("imageWriter not found");
        }
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(output);
        imageWriter.setOutput(imageOutputStream);
        IIOImage iioImage = new IIOImage(image, null, null);
        JPEGImageWriteParam imageWriteParam = new JPEGImageWriteParam(null);
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionQuality(quality);
        imageWriter.write(null, iioImage, imageWriteParam);
        imageOutputStream.flush();
    }

    public static BufferedImage getBluredImage(BufferedImage image, int size) {
        float[] elements = new float[size * size];
        float v = 1.0f / (float)elements.length;
        int i = 0;
        while (i < elements.length) {
            elements[i] = v;
            ++i;
        }
        BufferedImage base = new BufferedImage(image.getWidth() + size * 2, image.getHeight() + size * 2, 1);
        base.getGraphics().drawImage(image, size, size, null);
        base.getGraphics().copyArea(size, size, size, image.getHeight(), -size, 0);
        base.getGraphics().copyArea(image.getWidth() + size - size, size, size, image.getHeight(), size, 0);
        base.getGraphics().copyArea(0, size, image.getWidth() + size * 2, size, 0, -size);
        base.getGraphics().copyArea(0, image.getHeight() + size - size, image.getWidth() + size * 2, size, 0, size);
        BufferedImage bimg = new BufferedImage(image.getWidth() + size * 2, image.getHeight() + size * 2, 1);
        Kernel kernel = new Kernel(size, size, elements);
        ConvolveOp cop = new ConvolveOp(kernel, 1, null);
        cop.filter(base, bimg);
        return bimg;
    }

    public static boolean isImageFile(String path) {
        if (path == null) {
            return false;
        }
        int i = 0;
        while (i < imageExtensions.length) {
            if (path.toLowerCase().endsWith("." + imageExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isJpegFile(String path) {
        return path.toLowerCase().endsWith(".jpg") || path.toLowerCase().endsWith(".jpeg");
    }

    public static boolean isPngFile(String path) {
        return path.toLowerCase().endsWith(".gif");
    }

    public static boolean isGifFile(String path) {
        return path.toLowerCase().endsWith(".png");
    }

    public static BufferedImage resizeImage(BufferedImage baseImage, int width, int height) {
        ImageTurner.log.trace((Object)("baseW=" + baseImage.getWidth() + " baseH=" + baseImage.getHeight()));
        int dw = width;
        int dh = height;
        if (dw != 0 && dh != 0) {
            double haspect;
            double waspect = (double)dw / (double)baseImage.getWidth();
            if (waspect > (haspect = (double)dh / (double)baseImage.getHeight())) {
                dw = (int)((double)baseImage.getWidth() * haspect);
            } else {
                dh = (int)((double)baseImage.getHeight() * waspect);
            }
            ImageTurner.log.trace((Object)("waspect=" + waspect + " haspect=" + haspect + " dw=" + dw + " dh=" + dh));
        }
        BufferedImage image = new BufferedImage(dw, dh, 2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        int dx = 0;
        int dy = 0;
        ImageTurner.log.trace((Object)("dx=" + dx + ",dy=" + dy));
        g2.drawImage(baseImage, dx, dy, dw + dx, dh + dy, 0, 0, baseImage.getWidth(), baseImage.getHeight(), null);
        return image;
    }

    public static BufferedImage fitImage(BufferedImage baseImage, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        ImageTurner.log.trace((Object)("baseW=" + baseImage.getWidth() + " baseH=" + baseImage.getHeight()));
        int dw = width;
        int dh = height;
        if (dw != 0 && dh != 0) {
            double haspect;
            double waspect = (double)dw / (double)baseImage.getWidth();
            if (waspect > (haspect = (double)dh / (double)baseImage.getHeight())) {
                dw = (int)((double)baseImage.getWidth() * haspect);
            } else {
                dh = (int)((double)baseImage.getHeight() * waspect);
            }
            ImageTurner.log.trace((Object)("waspect=" + waspect + " haspect=" + haspect + " dw=" + dw + " dh=" + dh));
        }
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        int dx = (width - dw) / 2;
        int dy = (height - dh) / 2;
        ImageTurner.log.trace((Object)("dx=" + dx + ",dy=" + dy));
        g2.drawImage(baseImage, dx, dy, dw + dx, dh + dy, 0, 0, baseImage.getWidth(), baseImage.getHeight(), null);
        return image;
    }

    public static BufferedImage clipImage(BufferedImage baseImage, int x, int y, int width, int height, Color bgColor) throws IOException {
        BufferedImage clipImage = new BufferedImage(width, height, 1);
        Graphics g = clipImage.getGraphics();
        if (bgColor != null) {
            g.setColor(bgColor);
            g.fillRect(0, 0, width, height);
        }
        g.drawImage(baseImage, -x, -y, null);
        return clipImage;
    }
}

