/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.lib.standards.images.thread;

import com.akjava.lib.standards.images.ImageUtils;
import com.akjava.lib.standards.images.thread.BackgroundImageWriteListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BackgroundImageWriter {
    public static Log log = LogFactory.getLog(BackgroundImageWriter.class);
    private File outputFile;
    private BufferedImage image;
    private List<BackgroundImageWriteListener> listeners = new ArrayList<BackgroundImageWriteListener>();

    public BackgroundImageWriter(File outputFile, BufferedImage image) {
        this.outputFile = outputFile;
        this.image = image;
    }

    public void addBackgroundImageWriteListener(BackgroundImageWriteListener listener) {
        this.listeners.add(listener);
    }

    public void removeBackgroundImageWriteListener(BackgroundImageWriteListener listener) {
        this.listeners.remove(listener);
    }

    public void run() {
        try {
            if (ImageUtils.isPngFile(this.outputFile.getName())) {
                ImageIO.write((RenderedImage)this.image, "png", this.outputFile);
            } else if (ImageUtils.isJpegFile(this.outputFile.getName())) {
                ImageIO.write((RenderedImage)this.image, "jpeg", this.outputFile);
            }
        }
        catch (IOException e) {
            log.warn((Object)e.getMessage());
        }
        for (BackgroundImageWriteListener listener : this.listeners) {
            listener.imageSaved(this.outputFile);
        }
        this.image = null;
    }
}

