/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.lib.standards.process;

import com.akjava.lib.standards.process.ProcessMonitor;
import com.akjava.lib.standards.process.ProcessPrinter;
import com.akjava.lib.standards.process.SimpleProcessPrinter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleCommandExecuter {
    public static Log log = LogFactory.getLog(SimpleCommandExecuter.class);
    protected String[] command;
    protected String oneLineCommand;
    private Process process;
    private ProcessPrinter printer;
    private long waitForCloseStream = 10000L;

    public SimpleCommandExecuter(String[] command) {
        this.command = command;
        this.printer = new SimpleProcessPrinter();
    }

    public SimpleCommandExecuter(String command) {
        this.oneLineCommand = command;
        this.printer = new SimpleProcessPrinter();
    }

    public void execute() {
        Runtime runtime = Runtime.getRuntime();
        try {
            this.process = this.oneLineCommand != null ? runtime.exec(this.oneLineCommand) : runtime.exec(this.command);
            ProcessMonitor monitor = new ProcessMonitor(this.process, this.printer);
            monitor.startMonitor();
            try {
                this.process.waitFor();
                long c = System.currentTimeMillis();
                while (System.currentTimeMillis() < c + this.waitForCloseStream) {
                    if (!monitor.isErrorClosed() || !monitor.isInputClosed()) {
                        log.warn((Object)"wait:input reading");
                        Thread.sleep(100L);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public ProcessPrinter getPrinter() {
        return this.printer;
    }

    public void setPrinter(ProcessPrinter printer) {
        this.printer = printer;
    }

    public Process getProcess() {
        return this.process;
    }

    public void cancel() {
        if (this.process != null) {
            this.process.destroy();
        }
    }
}

