/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.mecab;

import com.akjava.mecab.MecabData;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.commons.util.JapaneseUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Mecab {
    public static Log log = LogFactory.getLog(Mecab.class.getClass());
    private String exePath = "C:\\Program Files\\MeCab\\bin\\mecab.exe";
    private Process process;

    public Mecab() {
    }

    public boolean exist() {
        return !this.exePath.equals("") && new File(this.exePath).exists();
    }

    public Mecab(String exePath) {
        this.exePath = exePath;
    }

    public String getExePath() {
        return this.exePath;
    }

    public void setExePath(String exePath) {
        this.exePath = exePath;
    }

    public String[] wakati(String text) {
        ArrayList<String> valueList = new ArrayList<String>();
        text = text.replace("\r\n", "\n");
        text = text.replace("\r", "\n");
        String[] lines = text.split("\n");
        int j = 0;
        while (j < lines.length) {
            try {
                log.trace((Object)lines[j]);
                MecabData[] datas = this.analyze(lines[j]);
                int i = 0;
                while (i < datas.length) {
                    valueList.add(datas[i].getWord());
                    log.trace((Object)datas[i]);
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (j != lines.length - 1) {
                valueList.add("\r\n");
            }
            ++j;
        }
        return valueList.toArray(new String[valueList.size()]);
    }

    public String[] kana(String text) {
        try {
            MecabData[] datas = this.analyze(text);
            String[] ret = new String[datas.length];
            int i = 0;
            while (i < ret.length) {
                ret[i] = datas[i].getRead();
                ++i;
            }
            return ret;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] pronounce(String text) {
        try {
            MecabData[] datas = this.analyze(text);
            String[] ret = new String[datas.length];
            int i = 0;
            while (i < ret.length) {
                ret[i] = datas[i].getPronounce();
                ++i;
            }
            return ret;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MecabData[] analyze(String text) throws IOException {
        Mecab mecab;
        ArrayList<MecabData> dataList = new ArrayList<MecabData>();
        if (this.exePath.equals("") || !new File(this.exePath).exists()) {
            throw new IOException("mecab.exe not found:" + this.exePath);
        }
        Runtime runtime = Runtime.getRuntime();
        this.process = runtime.exec(new String[]{this.exePath});
        PrintWriter writer = null;
        if (this.process != null) {
            Mecab mecab2 = this;
            synchronized (mecab2) {
                if (this.process != null) {
                    writer = new PrintWriter(this.process.getOutputStream());
                    writer.write(String.valueOf(text) + "\r\n");
                    writer.flush();
                }
            }
        }
        String line = null;
        BufferedReader reader = null;
        if (this.process != null) {
            mecab = this;
            synchronized (mecab) {
                if (this.process != null) {
                    reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                }
            }
        }
        if (reader != null) {
            while ((line = reader.readLine()) != null && this.process != null) {
                if (line.equals("EOS")) {
                    reader.close();
                    if (this.process != null) {
                        mecab = this;
                        synchronized (mecab) {
                            if (this.process != null) {
                                this.process.destroy();
                            }
                        }
                    }
                    this.process = null;
                    break;
                }
                String[] tmp = line.split("\t");
                if (tmp.length <= 1) continue;
                String[] values = tmp[1].split(",");
                if (values.length > 8) {
                    MecabData data = new MecabData(tmp[0], values[7], values[8]);
                    dataList.add(data);
                    continue;
                }
                String k = JapaneseUtils.ganaToKana(tmp[0]);
                if (JapaneseUtils.isKanaAll(k, true)) {
                    MecabData data = new MecabData(tmp[0], k, k);
                    dataList.add(data);
                    continue;
                }
                log.warn((Object)("not much:" + line));
            }
        }
        return dataList.toArray(new MecabData[dataList.size()]);
    }
}

