/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.commons.ui;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.akjrcp.commons.Messages;
import jp.sourceforge.akjrcp.commons.util.FileNameUtils;
import jp.sourceforge.akjrcp.commons.util.WildCard;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class EditableFileList
extends TableViewer {
    public static Log log = LogFactory.getLog(EditableFileList.class);
    protected ArrayList<File> fileList = new ArrayList();
    private MenuItem moveTop;
    private MenuItem moveBottom;
    private MenuItem moveUp;
    private MenuItem moveDown;
    private MenuItem removeFile;
    private boolean showNameOnly = false;
    private List<IPropertyChangeListener> propertyChangeListeners = new ArrayList<IPropertyChangeListener>();
    private String filterExtension;
    private boolean allowDoplicate = false;
    protected FilenameFilter filenameFilter;
    private MenuItem addfile;
    public static final String ACTION_ADD = "add";
    public static final String ACTION_REMOVE = "remove";
    public static final String ACTION_MOVE = "move";
    private Menu popUpMenu;

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    public void removeFile() {
        log.trace((Object)ACTION_REMOVE);
        File[] files = this.getSelectionFiles();
        int i = 0;
        while (i < files.length) {
            this.fileList.remove(files[i]);
            ++i;
        }
        if (files.length >= 0) {
            this.firePropertyChanged(ACTION_REMOVE);
        }
    }

    public void clear() {
        log.trace((Object)ACTION_REMOVE);
        File[] files = this.getFileList();
        int i = 0;
        while (i < files.length) {
            this.fileList.remove(files[i]);
            ++i;
        }
        this.firePropertyChanged(ACTION_REMOVE);
    }

    public void moveUp() {
        File[] files = this.getSelectionFiles();
        if (files.length == 1) {
            int index = this.fileList.indexOf(files[0]);
            this.fileList.remove(files[0]);
            this.fileList.add(Math.max(0, index - 1), files[0]);
            this.firePropertyChanged(ACTION_MOVE);
        }
    }

    public void moveDown() {
        File[] files = this.getSelectionFiles();
        if (files.length == 1) {
            int index = this.fileList.indexOf(files[0]);
            this.fileList.remove(files[0]);
            this.fileList.add(Math.min(this.fileList.size(), index + 1), files[0]);
            this.firePropertyChanged(ACTION_MOVE);
        }
    }

    public void moveTop() {
        File[] files = this.getSelectionFiles();
        if (files.length == 1) {
            this.fileList.remove(files[0]);
            this.fileList.add(0, files[0]);
            this.firePropertyChanged(ACTION_MOVE);
        }
    }

    public void moveBottom() {
        File[] files = this.getSelectionFiles();
        if (files.length == 1) {
            this.fileList.remove(files[0]);
            this.fileList.add(files[0]);
            this.firePropertyChanged(ACTION_MOVE);
        }
    }

    public EditableFileList(Composite parent, int style) {
        super(parent, style);
        this.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.setContentProvider((IContentProvider)new ViewContentProvider());
        MenuSelection selection = new MenuSelection();
        this.popUpMenu = new Menu((Control)this.getTable());
        this.getTable().setMenu(this.popUpMenu);
        this.addfile = new MenuItem(this.popUpMenu, 8);
        this.addfile.setText(Messages.getString("FileListTable.addfile"));
        this.addfile.addSelectionListener((SelectionListener)selection);
        new MenuItem(this.popUpMenu, 2);
        this.moveTop = new MenuItem(this.popUpMenu, 8);
        this.moveTop.setText(Messages.getString("FileListTable.moveTop"));
        this.moveTop.addSelectionListener((SelectionListener)selection);
        this.moveBottom = new MenuItem(this.popUpMenu, 8);
        this.moveBottom.setText(Messages.getString("FileListTable.moveBottom"));
        this.moveBottom.addSelectionListener((SelectionListener)selection);
        this.moveUp = new MenuItem(this.popUpMenu, 8);
        this.moveUp.setText(Messages.getString("FileListTable.moveUp"));
        this.moveUp.addSelectionListener((SelectionListener)selection);
        this.moveDown = new MenuItem(this.popUpMenu, 8);
        this.moveDown.setText(Messages.getString("FileListTable.moveDown"));
        this.moveDown.addSelectionListener((SelectionListener)selection);
        new MenuItem(this.popUpMenu, 2);
        this.removeFile = new MenuItem(this.popUpMenu, 8);
        this.removeFile.setText(Messages.getString("FileListTable.removeFile"));
        this.removeFile.addSelectionListener((SelectionListener)selection);
        this.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 127) {
                    EditableFileList.this.removeFile();
                    EditableFileList.this.refresh(true);
                }
            }
        });
        Transfer[] types = new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance()};
        int operations = 3;
        DragSource source1 = new DragSource((Control)this.getTable(), operations);
        source1.setTransfer(types);
        source1.addDragListener((DragSourceListener)new DragMonitor());
        DropTarget target2 = new DropTarget((Control)this.getTable(), operations);
        target2.setTransfer(types);
        target2.addDropListener((DropTargetListener)new DropMonitor());
        this.getTable().setLinesVisible(true);
    }

    public void add(Object object) {
        super.add(object);
    }

    public void addFile(File file) {
        if (this.filenameFilter != null) {
            if (this.filenameFilter.accept(file.getParentFile(), file.getName())) {
                this.innerAddFile(file);
            }
        } else {
            this.innerAddFile(file);
        }
    }

    public void addFilePath(String path) {
        this.addFile(new File(path));
    }

    public EditableFileList(Composite parent) {
        this(parent, 0);
    }

    public void openFile() {
        FileDialog dialog = new FileDialog(this.getTable().getShell(), 4098);
        dialog.setFilterExtensions(new String[]{this.filterExtension});
        String path = dialog.open();
        if (path != null) {
            String[] names = dialog.getFileNames();
            int i = 0;
            while (i < names.length) {
                this.addFilePath(names[i]);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void innerAddFile(File file) {
        if (!this.allowDoplicate) {
            EditableFileList editableFileList = this;
            synchronized (editableFileList) {
                File[] files = this.getFileList();
                int i = 0;
                while (i < files.length) {
                    if (files[i].getAbsolutePath().equals(file.getAbsolutePath())) {
                        log.info((Object)"duplicate not allowed");
                        return;
                    }
                    ++i;
                }
            }
        }
        this.fileList.add(file);
        this.firePropertyChanged(ACTION_ADD);
        this.refresh(true);
    }

    public void firePropertyChanged(String type) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, type, null, null);
        IPropertyChangeListener[] listenres = this.propertyChangeListeners.toArray(new IPropertyChangeListener[this.propertyChangeListeners.size()]);
        int i = 0;
        while (i < listenres.length) {
            listenres[i].propertyChange(event);
            ++i;
        }
    }

    protected FilenameFilter getFilenameFilter() {
        return this.filenameFilter;
    }

    protected void setFilenameFilter(FilenameFilter filenameFilter) {
        this.filenameFilter = filenameFilter;
    }

    public File[] getFileList() {
        return this.fileList.toArray(new File[0]);
    }

    public int countFiles() {
        return this.fileList.size();
    }

    public File[] getSelectionFiles() {
        ISelection selection = this.getSelection();
        return ((IStructuredSelection)selection).toList().toArray(new File[0]);
    }

    public void setLayoutData(GridData layoutData) {
        this.getTable().setLayoutData((Object)layoutData);
    }

    public String getFilterExtension() {
        return this.filterExtension;
    }

    public void setFilterExtension(String filterExtension) {
        this.filterExtension = filterExtension;
        if (filterExtension != null) {
            this.setFilenameFilter(new ExtensionFilenameFilter(filterExtension));
        }
    }

    public boolean isAllowDoplicate() {
        return this.allowDoplicate;
    }

    public void setAllowDoplicate(boolean allowDoplicate) {
        this.allowDoplicate = allowDoplicate;
    }

    public Menu getPopUpMenu() {
        return this.popUpMenu;
    }

    public void setPopUpMenu(Menu popUpMenu) {
        this.popUpMenu = popUpMenu;
    }

    public boolean isShowNameOnly() {
        return this.showNameOnly;
    }

    public void setShowNameOnly(boolean showNameOnly) {
        this.showNameOnly = showNameOnly;
    }

    public class DragMonitor
    extends DragSourceAdapter {
        public void dragStart(DragSourceEvent event) {
            if (EditableFileList.this.getSelectionFiles().length > 0) {
                event.doit = true;
            }
        }

        public void dragFinished(DragSourceEvent event) {
            if (event.detail != 0) {
                EditableFileList.this.removeFile();
                EditableFileList.this.refresh();
            }
        }

        public void dragSetData(DragSourceEvent event) {
            if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                File[] selections = EditableFileList.this.getSelectionFiles();
                String[] paths = new String[selections.length];
                int i = 0;
                while (i < paths.length) {
                    paths[i] = selections[i].getAbsolutePath();
                    ++i;
                }
                event.data = paths;
            }
        }
    }

    public class DropMonitor
    extends DropTargetAdapter {
        public void dragOperationChanged(DropTargetEvent event) {
            System.out.println("changed");
        }

        public void dropAccept(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            String[] files = (String[])event.data;
            if (files.length == 1 && EditableFileList.this.getSelectionFiles().length == 1 && files[0].equals(EditableFileList.this.getSelectionFiles()[0].getAbsolutePath())) {
                event.detail = 0;
            }
            int i = 0;
            while (i < files.length) {
                EditableFileList.this.addFilePath(files[i]);
                ++i;
            }
        }
    }

    public static class ExtensionFilenameFilter
    implements FilenameFilter {
        private WildCard[] wildcards;

        public ExtensionFilenameFilter(String extensions) {
            if (extensions.indexOf(",") != -1) {
                log.warn((Object)"now , not supported");
            }
            this.wildcards = WildCard.parseExtensions(extensions);
            int i = 0;
            while (i < this.wildcards.length) {
                ++i;
            }
        }

        @Override
        public boolean accept(File dir, String name) {
            int i = 0;
            while (i < this.wildcards.length) {
                if (this.wildcards[i].match(name)) {
                    return true;
                }
                log.trace((Object)(String.valueOf(this.wildcards[i].getPattern()) + ":not much " + name));
                ++i;
            }
            log.info((Object)(":not much any pattern " + name));
            return false;
        }
    }

    public class MenuSelection
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == EditableFileList.this.addfile) {
                EditableFileList.this.openFile();
            } else if (e.getSource() == EditableFileList.this.moveTop) {
                EditableFileList.this.moveTop();
            } else if (e.getSource() == EditableFileList.this.moveBottom) {
                EditableFileList.this.moveBottom();
            } else if (e.getSource() == EditableFileList.this.moveUp) {
                EditableFileList.this.moveUp();
            } else if (e.getSource() == EditableFileList.this.moveDown) {
                EditableFileList.this.moveDown();
            } else if (e.getSource() == EditableFileList.this.removeFile) {
                EditableFileList.this.removeFile();
            }
            EditableFileList.this.refresh(true);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            log.trace((Object)"input changed not supported");
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return EditableFileList.this.fileList.toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (EditableFileList.this.showNameOnly) {
                return ((File)obj).getName();
            }
            return FileNameUtils.shortenFileName(((File)obj).getAbsolutePath());
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

