/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.subtitle.srt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.sourceforge.akjrcp.subtitle.StandardSubObject;
import jp.sourceforge.akjrcp.subtitle.srt.SRTObject;
import jp.sourceforge.akjrcp.subtitle.srt.TimeData;

public class SRTList {
    private String encoding;
    private int index = 1;
    List<SRTObject> srtList = new ArrayList<SRTObject>();

    public int size() {
        return this.srtList.size();
    }

    public void add(SRTObject object) {
        this.add(object, false);
    }

    public synchronized void add(SRTObject object, boolean isIndexChange) {
        if (isIndexChange) {
            object.setIndex(this.index);
            this.srtList.add(object);
            ++this.index;
        } else {
            this.srtList.add(object);
            this.index = object.getIndex() + 1;
        }
    }

    public synchronized void add(TimeData start, TimeData end, String text) {
        SRTObject object = new SRTObject();
        object.setStartTime(start);
        object.setEnd(end);
        object.setIndex(this.index);
        object.setText(text);
        this.srtList.add(object);
        ++this.index;
    }

    public SRTObject getSRTObjectAt(int index) {
        return this.srtList.get(index);
    }

    public List<StandardSubObject> convertStandardSubtitleDataList() {
        ArrayList<StandardSubObject> list = new ArrayList<StandardSubObject>();
        int i = 0;
        while (i < this.srtList.size()) {
            SRTObject srt = this.srtList.get(i);
            StandardSubObject standard = new StandardSubObject();
            standard.setStartTime(srt.getStart().getTime());
            standard.setEndTime(srt.getEnd().getTime());
            if (SRTList.isImageFile(srt.getText())) {
                standard.setImagePath(srt.getText());
            } else if (srt.getText() != null) {
                standard.setText(srt.getText());
            }
            list.add(standard);
            ++i;
        }
        return list;
    }

    static boolean isImageFile(String text) {
        if (text == null) {
            return false;
        }
        String[] extensions = new String[]{".png", ".gif", ".bmp", ".jpg"};
        int i = 0;
        while (i < extensions.length) {
            if (text.toLowerCase().endsWith(extensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void sort() {
        Object[] srtObjects = this.srtList.toArray(new SRTObject[this.srtList.size()]);
        Arrays.sort(srtObjects);
        this.srtList.removeAll(this.srtList);
        int i = 0;
        while (i < srtObjects.length) {
            this.srtList.add((SRTObject)srtObjects[i]);
            ++i;
        }
    }

    public void reindex() {
        SRTObject[] srtObjects = this.srtList.toArray(new SRTObject[this.srtList.size()]);
        int i = 0;
        while (i < srtObjects.length) {
            srtObjects[i].setIndex(i + 1);
            ++i;
        }
    }

    public void offset(long time) {
        SRTObject[] srtObjects = this.srtList.toArray(new SRTObject[this.srtList.size()]);
        int i = 0;
        while (i < srtObjects.length) {
            srtObjects[i].setStartTime(srtObjects[i].getStart().getTime() + time);
            srtObjects[i].setEndTime(srtObjects[i].getEnd().getTime() + time);
            ++i;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        SRTObject[] srtObjects = this.srtList.toArray(new SRTObject[this.srtList.size()]);
        int i = 0;
        while (i < srtObjects.length) {
            buffer.append(srtObjects[i].toString());
            buffer.append("\r\n");
            ++i;
        }
        return buffer.toString();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

