/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.subtitle.srt;

import jp.sourceforge.akjrcp.subtitle.StandardSubObject;
import jp.sourceforge.akjrcp.subtitle.srt.SRTList;
import jp.sourceforge.akjrcp.subtitle.srt.TimeData;

public class SRTObject
implements Comparable {
    private TimeData startTime;
    private TimeData endTime;
    private int index;
    private String text = null;

    public SRTObject() {
    }

    public SRTObject(StandardSubObject object) {
        this.setText(object.getText());
        this.setStartTime(object.getStartTime());
        this.setEndTime(object.getEndTime());
    }

    public String toString() {
        String result = this.index + "\r\n";
        result = String.valueOf(result) + this.startTime + " --> " + this.endTime + "\r\n";
        result = String.valueOf(result) + this.text + "\r\n";
        return result;
    }

    public TimeData getEnd() {
        return this.endTime;
    }

    public long getEndTime() {
        return this.endTime.getTime();
    }

    public int getIndex() {
        return this.index;
    }

    public TimeData getStart() {
        return this.startTime;
    }

    public long getStartTime() {
        return this.startTime.getTime();
    }

    public String getText() {
        return this.text;
    }

    public void setEnd(TimeData data) {
        this.endTime = data;
    }

    public void setEndTime(long time) {
        this.endTime = new TimeData(time);
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public void setStartTime(TimeData data) {
        this.startTime = data;
    }

    public StandardSubObject toStandardSubObject() {
        StandardSubObject standard = new StandardSubObject();
        standard.setStartTime(this.getStart().getTime());
        standard.setEndTime(this.getEnd().getTime());
        if (SRTList.isImageFile(this.getText())) {
            standard.setImagePath(this.getText());
        } else if (this.getText() != null) {
            standard.setText(this.getText());
        }
        return standard;
    }

    public void setStartTime(long time) {
        this.startTime = new TimeData(time);
    }

    public void setText(String string) {
        this.text = string;
    }

    public int compareTo(Object o) {
        if (o instanceof SRTObject) {
            SRTObject srt = (SRTObject)o;
            if (srt.getStart().getTime() == this.getStart().getTime()) {
                if (srt.getEnd().getTime() > this.getEnd().getTime()) {
                    return -1;
                }
                return 1;
            }
            if (srt.getStart().getTime() > this.getStart().getTime()) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SRTObject)) {
            return false;
        }
        SRTObject srt = (SRTObject)object;
        return this.getStart().getTime() == srt.getStart().getTime() && this.getEnd().getTime() == srt.getEnd().getTime() && this.getText().equals(srt.getText());
    }

    public boolean intersect(SRTObject srt) {
        if (srt == null) {
            return false;
        }
        if (srt.getEnd().getTime() > this.getStart().getTime() && srt.getEnd().getTime() < this.getEnd().getTime()) {
            return true;
        }
        return srt.getStart().getTime() > this.getStart().getTime() && srt.getStart().getTime() < this.getEnd().getTime();
    }
}

