/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.lib.swt.images;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class SWTImageUtils {
    public static Image createThumbnail(Image img, int width, int height) {
        Image retImage = new Image(null, width, height);
        GC gc = new GC((Drawable)retImage);
        gc.setBackground(new Color(null, 255, 255, 255));
        gc.fillRectangle(0, 0, retImage.getBounds().width, retImage.getBounds().height);
        if (img.getBounds().width > retImage.getBounds().width || img.getBounds().height > retImage.getBounds().height) {
            int overw = img.getBounds().width - retImage.getBounds().width;
            int overh = img.getBounds().height - retImage.getBounds().height;
            double ratio = 0.0;
            ratio = overw > overh ? (double)retImage.getBounds().width / (double)img.getBounds().width : (double)retImage.getBounds().height / (double)img.getBounds().height;
            int dw = (int)((double)img.getBounds().width * ratio);
            int dh = (int)((double)img.getBounds().height * ratio);
            int cx = (retImage.getBounds().width - dw) / 2;
            int cy = (retImage.getBounds().height - dh) / 2;
            gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, cx, cy, dw, dh);
        } else {
            int cx = (retImage.getBounds().width - img.getBounds().width) / 2;
            int cy = (retImage.getBounds().height - img.getBounds().height) / 2;
            gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, cx, cy, img.getBounds().width, img.getBounds().height);
        }
        gc.dispose();
        return retImage;
    }

    public static Image loadImage(Class cl, String resource) {
        Image ret = new Image((Device)Display.getCurrent(), cl.getClassLoader().getResourceAsStream(resource));
        return ret;
    }

    public static BufferedImage swtImageToAwtImage(Image image) {
        return SWTImageUtils.swtImageToAwtImage(image, 0, 0, image.getBounds().width, image.getBounds().height);
    }

    public static BufferedImage swtImageToAwtImage(Image image, int dx, int dy, int width, int height) {
        int[] defaultColor = new int[]{255, 255, 255, 255};
        ImageData data = image.getImageData();
        BufferedImage bimage = new BufferedImage(width, height, 2);
        WritableRaster raster = bimage.getRaster();
        int i = dx;
        while (i < dx + width && dx < image.getBounds().width) {
            int j = dy;
            while (j < dy + height) {
                int x = i - dx;
                int y = j - dy;
                int[] int_rgb = null;
                if (i >= 0 && j >= 0 && i < image.getBounds().width && j < image.getBounds().height) {
                    int color = data.getPixel(i, j);
                    int_rgb = data.depth == 32 ? new int[]{0xFF & color >> 8, 0xFF & color >> 16, 0xFF & color >> 24, 255} : new int[]{0xFF & color, 0xFF & color >> 8, 0xFF & color >> 16, 255};
                } else {
                    int_rgb = defaultColor;
                }
                raster.setPixel(x, y, int_rgb);
                ++j;
            }
            ++i;
        }
        return bimage;
    }
}

