/*
 * Decompiled with CFR 0.152.
 */
package com.akjava.lib.swt.log;

import com.akjava.lib.swt.images.SWTImageUtils;
import com.akjava.lib.swt.log.ExecuteLog;
import com.akjava.lib.swt.log.Messages;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ExecuteLogTableViewer
extends TableViewer {
    private List<ExecuteLog> parameterList = new ArrayList<ExecuteLog>();
    private Menu popUpMenu;
    private static Image okIcon;
    private static Image ngIcon;
    private static Image cancelIcon;

    public int getCurrentSelectionIndex() {
        return this.getTable().getSelectionIndex();
    }

    public ExecuteLog getCurrentSelection() {
        int selection = this.getTable().getSelectionIndex();
        if (selection > -1) {
            return this.getListArray().get(selection);
        }
        return null;
    }

    public ExecuteLogTableViewer(Composite parent) {
        super(parent, 68352);
        this.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.setContentProvider((IContentProvider)new ViewContentProvider());
        this.popUpMenu = new Menu((Control)this.getTable());
        this.getTable().setMenu(this.popUpMenu);
        Table table = this.getTable();
        TableColumn column3 = new TableColumn(table, 16384, 0);
        column3.setText(Messages.getString("title"));
        column3.setWidth(400);
        TableColumn column2 = new TableColumn(table, 16384, 1);
        column2.setText(Messages.getString("execName"));
        column2.setWidth(100);
        TableColumn column = new TableColumn(table, 16384, 2);
        column.setText(Messages.getString("result"));
        column.setWidth(40);
        TableColumn column4 = new TableColumn(table, 16384, 3);
        column4.setText(Messages.getString("execTime"));
        column4.setWidth(120);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        if (okIcon == null) {
            okIcon = SWTImageUtils.loadImage(((Object)((Object)this)).getClass(), "/com/akjava/lib/swt/resources/ok.png");
            ngIcon = SWTImageUtils.loadImage(((Object)((Object)this)).getClass(), "/com/akjava/lib/swt/resources/ng.png");
            cancelIcon = SWTImageUtils.loadImage(((Object)((Object)this)).getClass(), "/com/akjava/lib/swt/resources/cancel.png");
        }
    }

    public String toTimeLabel(long t) {
        SimpleDateFormat format = new SimpleDateFormat("hh:mm:ss MM/dd");
        return format.format(new Date(t));
    }

    public List<ExecuteLog> getListArray() {
        return this.parameterList;
    }

    public Menu getPopUpMenu() {
        return this.popUpMenu;
    }

    public void setPopUpMenu(Menu popUpMenu) {
        this.popUpMenu = popUpMenu;
    }

    public void moveTop(int index) {
        ExecuteLog setting = this.getListArray().get(index);
        this.getListArray().remove(setting);
        this.getListArray().add(0, setting);
        this.refresh();
    }

    public void moveUp(int index) {
        ExecuteLog setting = this.getListArray().get(index);
        this.getListArray().remove(setting);
        this.getListArray().add(Math.max(0, index - 1), setting);
        this.refresh();
    }

    public void moveDown(int index) {
        ExecuteLog setting = this.getListArray().get(index);
        this.getListArray().remove(setting);
        this.getListArray().add(Math.min(this.getListArray().size(), index + 1), setting);
        this.refresh();
    }

    public void moveBottom(int index) {
        ExecuteLog setting = this.getListArray().get(index);
        this.getListArray().remove(setting);
        this.getListArray().add(this.getListArray().size(), setting);
        this.refresh();
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            ExecuteLogTableViewer.this.parameterList = (List)newInput;
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((List)parent).toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            ExecuteLog elog = (ExecuteLog)obj;
            if (index == 2) {
                return "";
            }
            if (index == 1) {
                return elog.getExecName();
            }
            if (index == 0) {
                return elog.getTitle();
            }
            if (index == 3) {
                return ExecuteLogTableViewer.this.toTimeLabel(elog.getExecTime());
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 2) {
                ExecuteLog elog = (ExecuteLog)obj;
                if (elog.getResult() == 2) {
                    return okIcon;
                }
                if (elog.getResult() == 1) {
                    return ngIcon;
                }
                if (elog.getResult() == 3) {
                    return cancelIcon;
                }
            }
            return null;
        }
    }
}

