/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.subtitle.sub;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Vector;
import jp.sourceforge.akjrcp.subtitle.StandardSubObject;
import jp.sourceforge.akjrcp.subtitle.SubtitleUtils;
import jp.sourceforge.akjrcp.subtitle.sub.SUBObject;
import jp.sourceforge.akjrcp.subtitle.sub.TextObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;

public class SUBParser {
    List subList = new Vector();
    String baseDir;
    private double frameRate = 29.97;
    private String[] imageExtensions = SubtitleUtils.getDefaultImageExtensions();

    public long getFrameTime(int frame) {
        long result = -1L;
        result = (long)((double)((long)frame * 1000L) / this.frameRate);
        return result;
    }

    private void parseLine(String line) {
        if (line.startsWith("{")) {
            SUBObject data = new SUBObject();
            String[] splitValue = SUBParser.parseSplit(line);
            if (splitValue != null) {
                int start = Integer.parseInt(splitValue[0]);
                int end = Integer.parseInt(splitValue[1]);
                data.setStartFrame(start);
                data.setEndFrame(end);
                data.setText(splitValue[2]);
                this.subList.add(data);
            }
        } else {
            if (line.startsWith("FrameRate=")) {
                this.setFrameRate(Double.parseDouble(line.substring("FrameRate=".length())));
            }
            TextObject text = new TextObject();
            text.setText(line);
            this.subList.add(text);
        }
    }

    public List getSubDataList() {
        Vector<StandardSubObject> list = new Vector<StandardSubObject>();
        int i = 0;
        while (i < this.subList.size()) {
            if (this.subList.get(i) instanceof SUBObject) {
                SUBObject subobject = (SUBObject)this.subList.get(i);
                StandardSubObject standard = new StandardSubObject();
                standard.setStartTime(this.getFrameTime(subobject.getStartFrame()));
                standard.setEndTime(this.getFrameTime(subobject.getEndFrame()));
                String text = subobject.getText();
                if (this.isImagePath(text)) {
                    String path = this.getInText(text);
                    standard.setImagePath(path);
                }
                list.add(standard);
            }
            ++i;
        }
        return list;
    }

    private String getInText(String text) {
        if (text.startsWith("{") && text.endsWith("}")) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    private boolean isImagePath(String line) {
        String text = this.getInText(line);
        int i = 0;
        while (i < this.imageExtensions.length) {
            if (text.toLowerCase().endsWith(this.imageExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] parseSplit(String line) {
        String[] result = new String[3];
        int f1 = line.indexOf("}{", 1);
        if (f1 != -1) {
            result[0] = line.substring(1, f1);
            int f2 = line.indexOf("}{", f1 + 2);
            if (f2 != -1) {
                result[1] = line.substring(f1 + 2, f2);
                int f3 = line.indexOf("}", f2 + 2);
                if (f3 != -1) {
                    result[2] = line.substring(f2 + 2, f3);
                }
            }
        }
        return result;
    }

    public void parse(File file) {
        this.baseDir = file.getParent();
        try {
            String text = IOUtils.toString((Reader)new FileReader(file));
            String[] lines = text.split(SystemUtils.LINE_SEPARATOR);
            int i = 0;
            while (i < lines.length) {
                this.parseLine(lines[i]);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(double frameRate) {
        this.frameRate = frameRate;
    }

    public String[] getImageExtensions() {
        return this.imageExtensions;
    }

    public void setImageExtensions(String[] imageExtensions) {
        this.imageExtensions = imageExtensions;
    }

    public List getSubList() {
        return this.subList;
    }

    public void setSubList(List subList) {
        this.subList = subList;
    }
}

