/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.audiotools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegCommandUtil;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUI;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ffmpeg.SimpleCommandExecuter;
import jp.sourceforge.akjrcp.snack.ESPS;
import jp.sourceforge.akjrcp.snack.PitchExecuter;
import jp.sourceforge.akjrcp.snack.PitchToMIDI;
import jp.sourceforge.akjrcp.subtitle.StandardSubObject;
import jp.sourceforge.akjrcp.subtitle.srt.SRTList;
import jp.sourceforge.akjrcp.subtitle.srt.SRTParser;
import jp.sourceforge.akjrcp.ui.FileDirChoicer;
import jp.sourceforge.akjrcp.ui.WidgetBuilder;
import jp.sourceforge.akjrcp.ui.param.ParamBoolean;
import jp.sourceforge.akjrcp.ui.param.ParamCombo;
import jp.sourceforge.akjrcp.ui.param.ParamScale;
import jp.sourceforge.akjrcp.ui.param.ParamSpinnerAndScale;
import jp.sourceforge.akjrcp.ui.param.ParamText;
import jp.sourceforge.akjrcp.ui.param.ParamTextArea;
import jp.sourceforge.akjrcp.util.ExecutingControler;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import jp.sourceforge.akjrcp.util.StatusBarUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class WavToMidiViewer
extends ViewPart {
    public static Log log = LogFactory.getLog(WavToMidiViewer.class);
    public static final String ID = WavToMidiViewer.class.getName();
    private ParamCombo min_picth;
    private ParamCombo max_pitch;
    private FileDirChoicer tmpDirChooser;
    private FileDirChoicer inputWavFileChooser;
    private FileDirChoicer inputSrtFileChooser;
    private FileDirChoicer outputFileChooser;
    private WavToMIDIExecute wavToMidiExecuter;
    private ParamSpinnerAndScale minVolumeScale;
    private ParamScale noteShiftScale;
    private Label statusLabel;
    private ParamBoolean forceInsertSubtile;
    private ParamBoolean ignoreOffsetBoolean;
    private ParamScale strechTimeSale;

    public void createPartControl(Composite parent) {
        this.wavToMidiExecuter = new WavToMIDIExecute();
        parent.setLayout((Layout)new GridLayout(1, false));
        FileSelected selectedListener = new FileSelected();
        this.tmpDirChooser = new FileDirChoicer(parent, 2048, 1, Messages.getString("spumux.tmp_dir"));
        this.tmpDirChooser.setToolTipText(Messages.getString("spumux.tmp_dir_tooltips"));
        this.tmpDirChooser.setLayoutData(new GridData(768));
        this.tmpDirChooser.addFileListChangeListener(selectedListener);
        this.tmpDirChooser.setFilePath(Akj_betasPlugin.getDefault().getPreferenceStore().getString("videotools.ascii_tmpdir"));
        this.tmpDirChooser.addFileListChangeListener(new FileDirChoicer.FileStatusChangeListener(){

            public void addList(FileDirChoicer.FileStatusChangeEvent event) {
                Akj_betasPlugin.getDefault().getPreferenceStore().setValue("videotools.ascii_tmpdir", WavToMidiViewer.this.tmpDirChooser.getAbsoluteFilePath());
            }

            public void removeList(FileDirChoicer.FileStatusChangeEvent event) {
                Akj_betasPlugin.getDefault().getPreferenceStore().setValue("videotools.ascii_tmpdir", WavToMidiViewer.this.tmpDirChooser.getAbsoluteFilePath());
            }
        });
        Composite s1 = this.createSplitComposite(parent, 2, true, new GridData(768));
        this.max_pitch = new ParamCombo(s1, 0, "max_pitch", Messages.getString("wav2midi.max_pitch"), new String[]{"400", "600", "800", "1000", "1200", "1400"});
        this.max_pitch.setValue("1000");
        this.max_pitch.setToolTipText(Messages.getString("wav2midi.max_pitch_tooltip"));
        this.min_picth = new ParamCombo(s1, 0, "ignore_end", Messages.getString("wav2midi.min_pitch"), new String[]{"0", "40", "60", "60", "100", "150", "200", "300", "400", "500", "600"});
        this.min_picth.setValue("60");
        this.min_picth.setToolTipText(Messages.getString("wav2midi.min_pitch_tooltip"));
        this.noteShiftScale = new ParamScale(s1, 0, "note_shift", Messages.getString("wav2midi.note_shift"));
        this.noteShiftScale.setOffset(-24);
        this.noteShiftScale.setMaximum(48);
        this.noteShiftScale.setValue(0);
        this.noteShiftScale.setToolTipText(Messages.getString("wav2midi.note_shift_tooltip"));
        this.minVolumeScale = new ParamSpinnerAndScale(s1, 0, "min_volume", Messages.getString("wav2midi.min_volume"));
        this.minVolumeScale.setMinimum(1.0);
        this.minVolumeScale.setMaximum(9000.0);
        this.minVolumeScale.setValue("600");
        this.minVolumeScale.getSpinnerAndScale().getSpinner().setPageIncrement(10);
        this.minVolumeScale.setToolTipText(Messages.getString("wav2midi.min_volume_tooltip"));
        Composite s2 = this.createSplitComposite(parent, 3, false, new GridData(768));
        this.strechTimeSale = new ParamScale(s2, 0, "strech_time", Messages.getString("wav2midi.strech_time")){

            protected String toValue(String n) {
                double num = Integer.parseInt(n);
                String ret = "" + (double)this.getScale().getSelection() / 10.0;
                while ((double)ret.length() < num) {
                    ret = " " + ret;
                }
                return ret;
            }
        };
        this.strechTimeSale.setMinimum(3);
        this.strechTimeSale.setMaximum(30);
        this.strechTimeSale.setValue(10);
        this.ignoreOffsetBoolean = new ParamBoolean(s2, 0, "ignore_offset", Messages.getString("wav2midi.ignore_offset"));
        this.ignoreOffsetBoolean.setValue("1");
        this.forceInsertSubtile = new ParamBoolean(s2, 0, "force_intsert", Messages.getString("wav2midi.force_intsert"));
        this.forceInsertSubtile.setValue("1");
        this.inputWavFileChooser = new FileDirChoicer(parent, 2048, 0, Messages.getString("wav2midi.wave"));
        this.inputWavFileChooser.setLayoutData(new GridData(768));
        this.inputWavFileChooser.addFileListChangeListener(selectedListener);
        this.inputWavFileChooser.setFilterExtensions(new String[]{"*.wav"});
        this.inputWavFileChooser.addFileListChangeListener(new ExportFileSet());
        this.inputSrtFileChooser = new FileDirChoicer(parent, 2048, 0, Messages.getString("wav2midi.srt"), true);
        this.inputSrtFileChooser.setLayoutData(new GridData(768));
        this.inputSrtFileChooser.addFileListChangeListener(selectedListener);
        this.inputSrtFileChooser.setFilterExtensions(new String[]{"*.srt"});
        this.outputFileChooser = new FileDirChoicer(parent, 2048, 2, Messages.getString("wav2midi.midi"), true);
        this.outputFileChooser.setLayoutData(new GridData(768));
        this.outputFileChooser.setFilterExtensions(new String[]{"*.mid"});
        this.outputFileChooser.addFileListChangeListener(selectedListener);
        this.wavToMidiExecuter.addControl((Control)this.inputWavFileChooser);
        this.wavToMidiExecuter.addControl((Control)this.inputSrtFileChooser);
        this.wavToMidiExecuter.addControl((Control)this.outputFileChooser);
        Composite exec_label = WidgetBuilder.createGridLayoutComposite(parent, 0, 2, false);
        new ExecutingControler.ExecutingControlButton(exec_label, 0, this.wavToMidiExecuter, Messages.getString("wav2midi.convert_midi"), Messages.getString("cancel"));
        this.statusLabel = new Label(exec_label, 0);
        this.statusLabel.setForeground(new Color(null, new RGB(255, 0, 0)));
        this.updateStatus();
        new DropMonitor(parent);
    }

    public void setFocus() {
    }

    public void updateStatus() {
        if (this.wavToMidiExecuter.canExecute()) {
            this.statusLabel.setText("");
        } else if (this.tmpDirChooser.getAbsoluteFilePath().equals("") || !FileNameUtils.isAsciiFileName(this.tmpDirChooser.getAbsoluteFilePath())) {
            this.statusLabel.setText(Messages.getString("wav2midi.choose_tmpdir"));
        } else if (this.inputWavFileChooser.getAbsoluteFilePath().equals("")) {
            this.statusLabel.setText(Messages.getString("wav2midi.choose_input"));
        } else if (this.outputFileChooser.getAbsoluteFilePath().equals("")) {
            this.statusLabel.setText(Messages.getString("wav2midi.choose_output"));
        }
        this.wavToMidiExecuter.updateControlSwitch();
    }

    private Composite createSplitComposite(Composite parent, int split, boolean same, Object data) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(split, same));
        if (data != null) {
            composite.setLayoutData(data);
        }
        return composite;
    }

    private ParamTextArea createGridTextAreaGroup(Composite parent, String key, String label, Object data) {
        ParamTextArea text = new ParamTextArea(parent, 0, key, label, -1);
        text.setLayoutData(data);
        return text;
    }

    private ParamText createLabeldText(Composite parent, String key, String label, Object data) {
        ParamText text = new ParamText(parent, 0, key, label, 0);
        if (data != null) {
            text.setLayoutData(data);
        }
        return text;
    }

    public StandardSubObject[] loadSubtitles(File file) {
        if (file == null || !file.exists()) {
            return new StandardSubObject[0];
        }
        SRTParser parser = new SRTParser();
        try {
            SRTList list = parser.parse((Reader)new FileReader(file));
            List subList = list.convertStandardSubtitleDataList();
            return subList.toArray(new StandardSubObject[subList.size()]);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return new StandardSubObject[0];
        }
    }

    public void setInputWave(String path) {
        String srtPath;
        String exportPath = FileNameUtils.getChangedExtensionName(new File(path), "mid", true);
        if (!new File(exportPath).exists()) {
            this.outputFileChooser.setFilePath(exportPath);
        }
        if (new File(srtPath = FileNameUtils.getChangedExtensionName(new File(path), "srt", true)).exists()) {
            this.inputSrtFileChooser.setFilePath(srtPath);
        }
        this.updateStatus();
    }

    public class ExportFileSet
    implements FileDirChoicer.FileStatusChangeListener {
        public void addList(FileDirChoicer.FileStatusChangeEvent event) {
            String path = event.getFilePath();
            if (!path.equals("")) {
                WavToMidiViewer.this.setInputWave(path);
            } else {
                WavToMidiViewer.this.updateStatus();
            }
        }

        public void removeList(FileDirChoicer.FileStatusChangeEvent event) {
        }
    }

    public class SettingMonitor
    implements IPropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            log.info((Object)event.getProperty());
            if (event.getProperty().equals("videotools.ascii_tmpdir")) {
                WavToMidiViewer.this.updateStatus();
            }
        }
    }

    public class WavToMIDIExecute
    extends ExecutingControler {
        private int min_pitch_value;
        private int max_pitch_value;
        private int min_volume_value;
        private int note_shift_value;
        private String inputWaveFileChooser_value;
        private String inputSrtFileChooser_value;
        private String outputFileChooser_value;
        private String tmpDirChooser_value;
        private boolean forceInsert;
        private boolean ignoreOffset;
        private double strechPlayTime;

        public void afterExecute() {
        }

        public void beforeExecute() {
            try {
                this.min_pitch_value = Integer.parseInt(WavToMidiViewer.this.min_picth.getValue());
            }
            catch (Exception exception) {}
            if (this.min_pitch_value == 0) {
                this.min_pitch_value = 60;
            }
            try {
                this.max_pitch_value = Integer.parseInt(WavToMidiViewer.this.max_pitch.getValue());
            }
            catch (Exception exception) {}
            if (this.max_pitch_value == 0) {
                this.max_pitch_value = 600;
            }
            this.forceInsert = WavToMidiViewer.this.forceInsertSubtile.getBoolean();
            this.ignoreOffset = WavToMidiViewer.this.ignoreOffsetBoolean.getBoolean();
            this.strechPlayTime = Double.parseDouble(WavToMidiViewer.this.strechTimeSale.getValue()) / 10.0;
            this.min_volume_value = (int)Double.parseDouble(WavToMidiViewer.this.minVolumeScale.getValue());
            this.note_shift_value = (int)Double.parseDouble(WavToMidiViewer.this.noteShiftScale.getValue());
            this.inputWaveFileChooser_value = WavToMidiViewer.this.inputWavFileChooser.getAbsoluteFilePath();
            this.inputSrtFileChooser_value = WavToMidiViewer.this.inputSrtFileChooser.getAbsoluteFilePath();
            this.outputFileChooser_value = WavToMidiViewer.this.outputFileChooser.getAbsoluteFilePath();
            this.tmpDirChooser_value = WavToMidiViewer.this.tmpDirChooser.getAbsoluteFilePath();
        }

        public boolean canExecute() {
            if (!FileNameUtils.isAsciiFileName(WavToMidiViewer.this.tmpDirChooser.getAbsoluteFilePath())) {
                return false;
            }
            return !WavToMidiViewer.this.inputWavFileChooser.getAbsoluteFilePath().equals("") && !WavToMidiViewer.this.outputFileChooser.getAbsoluteFilePath().equals("");
        }

        public void cancelExecuting() {
        }

        public void inExecute() {
            File input;
            String pitch2ExePath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("audiotools.path_pitch2");
            if (pitch2ExePath.equals("")) {
                StatusBarUtils.showStatusBar("pitch2.exe is not setted in OtherTools setting");
                return;
            }
            File output = new File(this.outputFileChooser_value);
            File waveFile = new File(this.inputWaveFileChooser_value);
            AudioFileFormat format = null;
            try {
                format = AudioSystem.getAudioFileFormat(waveFile);
            }
            catch (UnsupportedAudioFileException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (format == null) {
                log.warn((Object)"wrong wave");
                return;
            }
            File tmp = null;
            if (FileNameUtils.isAsciiFileName(this.inputWaveFileChooser_value) && (int)format.getFormat().getSampleRate() == 48000) {
                input = new File(this.inputWaveFileChooser_value);
            } else {
                tmp = input = new File(this.tmpDirChooser_value, String.valueOf(System.currentTimeMillis()) + ".wav");
                tmp.deleteOnExit();
                if ((int)format.getFormat().getSampleRate() == 48000) {
                    try {
                        FileUtils.copyFile((File)waveFile, (File)input);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    String ffmpeg = FFMpegUI.getFFmpegOrPureFFMpeg();
                    if (ffmpeg == null) {
                        log.warn((Object)"no ffmpeg and copy");
                        try {
                            FileUtils.copyFile((File)waveFile, (File)input);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        SimpleCommandExecuter executer = new SimpleCommandExecuter(FFMpegCommandUtil.makeWaveSampleRateChangeCommand(ffmpeg, waveFile.getAbsolutePath(), input.getAbsolutePath(), 48000));
                        executer.setPrinter(Akj_betasPlugin.getDefault().getProcessPrinter());
                        executer.execute();
                        StatusBarUtils.showStatusBar("");
                    }
                }
            }
            PitchExecuter executer = new PitchExecuter();
            executer.setPitch2ExePath(pitch2ExePath);
            try {
                String[] commands = executer.getCommands(input.getAbsolutePath(), 0, 0, this.min_pitch_value, this.max_pitch_value, 0.015625);
                log.info((Object)FFMpegUtils.toPrintCommand(commands));
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("###\n" + FFMpegUtils.toPrintCommand(commands) + "\n");
                ESPS[] esps = executer.getESPS(input.getAbsolutePath(), 0, 0, this.min_pitch_value, this.max_pitch_value, 0.015625);
                PitchToMIDI p2midi = new PitchToMIDI();
                p2midi.setShiftNote(this.note_shift_value);
                p2midi.setVolumeMin(this.min_volume_value);
                p2midi.setIgnoreOffset(this.ignoreOffset);
                p2midi.setForceInsert(this.forceInsert);
                p2midi.setTempo((int)(240.0 / this.strechPlayTime));
                System.out.println(String.valueOf(this.ignoreOffset) + "," + this.forceInsert + "," + this.strechPlayTime);
                if (!this.inputSrtFileChooser_value.equals("")) {
                    StandardSubObject[] subtitles = WavToMidiViewer.this.loadSubtitles(new File(this.inputSrtFileChooser_value));
                    p2midi.makeMIDI(esps, subtitles, output);
                } else {
                    p2midi.makeMIDI(esps, output);
                }
                StatusBarUtils.showStatusBar(String.valueOf(Messages.getString("wav2midi.created")) + output.getName());
                if (tmp != null) {
                    tmp.delete();
                }
            }
            catch (IOException e) {
                StatusBarUtils.showStatusBar("faild:" + output.getName());
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(String.valueOf(e.getMessage()) + "\n");
                e.printStackTrace();
            }
            Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("###\n");
        }
    }

    public class FileSelected
    implements FileDirChoicer.FileStatusChangeListener {
        public void addList(FileDirChoicer.FileStatusChangeEvent event) {
            WavToMidiViewer.this.updateStatus();
        }

        public void removeList(FileDirChoicer.FileStatusChangeEvent event) {
            WavToMidiViewer.this.updateStatus();
        }
    }

    public class DropMonitor
    extends DropTargetAdapter {
        public DropMonitor(Composite controler) {
            Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
            int operations = 3;
            DropTarget target2 = new DropTarget((Control)controler, operations);
            target2.setTransfer(types);
            target2.addDropListener((DropTargetListener)this);
        }

        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            block1: {
                String[] files = (String[])event.data;
                int i = 0;
                if (i >= files.length) break block1;
                if (FileNameUtils.isWaveFile(files[i]) && new File(files[i]).isFile()) {
                    WavToMidiViewer.this.inputWavFileChooser.setFilePath(files[i]);
                }
                WavToMidiViewer.this.setInputWave(files[i]);
            }
        }
    }
}

