/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.audiotools.spectrogram;

import jp.sourceforge.akjrcp.audiotools.spectrogram.SpectrogramDrawInfo;
import jp.sourceforge.akjrcp.ui.draw2d.CachedImageLoader;
import jp.sourceforge.akjrcp.ui.draw2d.ScalableImageFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class SpectrogramFigure
extends ScalableImageFigure {
    private SpectrogramDrawInfo spectrogramDrawInfo;
    private Rectangle lastRectangle;

    public SpectrogramFigure(SpectrogramDrawInfo info, CachedImageLoader arg0, String arg1, int arg2, int arg3) {
        super(arg0, arg1, arg2, arg3);
        this.spectrogramDrawInfo = info;
    }

    public double calculateImageWidth() {
        if (this.lastRectangle == null) {
            Image img = this.getImage();
            if (img == null) {
                return this.defaultWidth;
            }
            this.lastRectangle = img.getBounds();
        }
        return this.wzoom * (double)this.lastRectangle.width;
    }

    public void paintFigure(Graphics g) {
        Image spectrogramImage = this.getImage();
        if (spectrogramImage != null && !spectrogramImage.isDisposed()) {
            this.lastRectangle = spectrogramImage.getBounds();
            int w = spectrogramImage.getBounds().width;
            int h = spectrogramImage.getBounds().height;
            if (w != this.defaultWidth || h != this.defaultHeight) {
                this.defaultWidth = w;
                this.defaultHeight = h;
                this.resize();
                this.getParent().revalidate();
            }
            if (this.spectrogramDrawInfo.isFit()) {
                g.drawImage(spectrogramImage, 0, 0, spectrogramImage.getBounds().width, spectrogramImage.getBounds().height, this.getClientArea().x, this.getClientArea().y, this.getSize().width, this.getSize().height);
            } else {
                int drawHeight = (int)((double)(this.spectrogramDrawInfo.getSampleRate() * this.spectrogramDrawInfo.getBaseHeight()) * this.hzoom / 48000.0);
                g.drawImage(spectrogramImage, 0, 0, spectrogramImage.getBounds().width, spectrogramImage.getBounds().height, this.getClientArea().x, this.getClientArea().y + this.getClientArea().height - drawHeight, this.getSize().width, drawHeight);
            }
        }
    }
}

