/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.dropsomething;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.dropsomething.Messages;
import jp.sourceforge.akjrcp.dropsomething.ProgressAndList;
import jp.sourceforge.akjrcp.util.ProcessPrinter;
import jp.sourceforge.akjrcp.util.StatusBarUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public abstract class DropsomethingTab
extends Composite
implements FilenameFilter {
    public static Log log = LogFactory.getLog(DropsomethingTab.class);
    private ProgressAndList plist;
    private StackLayout stack;
    private Composite controler;
    private boolean canConvert;
    private boolean cancel;
    private String preferenceKey;
    protected int progressMaxBytes;
    protected long progressMaxTime;
    protected long startTime;
    protected long progressTime;
    protected int progressKBytes;
    private ProcessPrinter processPrinter;
    private String cantConvertMessage = Messages.getString("dropsomething.err_initialized");
    private ViewPart viewPart;

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public void setPreferenceKey(String preferenceKey) {
        this.preferenceKey = preferenceKey;
    }

    public DropsomethingTab(Composite parent, int style) {
        this(parent, style, null);
    }

    public DropsomethingTab(Composite parent, int style, String preferenceKey) {
        super(parent, style);
        this.setPreferenceKey(preferenceKey);
        this.stack = new StackLayout();
        this.setLayout((Layout)this.stack);
        this.plist = new ProgressAndList(this, 0);
        this.plist.getSimpleFileList().setInput(new ArrayList());
        this.plist.getCancelButton().addSelectionListener((SelectionListener)new CancelAction());
        this.plist.setFilenameFilter(this);
        this.controler = this.createControls(this);
        this.stack.topControl = this.controler;
        new DropMonitor(this.controler);
    }

    public void progressBytes(int kByte) {
        if (kByte == 0 || this.progressMaxBytes == 0) {
            return;
        }
        int p = kByte * 100 / this.progressMaxBytes;
        this.setProgress(p);
    }

    public void progressTime(long time) {
        if (time == 0L || this.progressMaxTime == 0L) {
            return;
        }
        int p = (int)(time * 100L / this.progressMaxTime);
        this.setProgress(p);
    }

    public void setProgress(int persent) {
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new SetProgress(persent));
    }

    public void setCenterText(String text) {
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new SetCenterText(text));
    }

    public void setHeaderText(String text) {
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new SetHeaderText(text));
    }

    protected void actionCancel() {
        this.cancel = true;
        this.cancelConvert();
        this.plist.getSimpleFileList().removeFiles();
        this.releaseConvert();
        this.stack.topControl = this.controler;
        this.layout();
        this.redraw();
    }

    public abstract Composite createControls(Composite var1);

    public void startConvert() {
        this.cancel = false;
        this.plist.getSimpleFileList().getTable().select(0);
        this.initConvert();
        this.beforeConvert();
        Thread t = new Thread(new ConvertFile());
        t.start();
    }

    protected void perfomeCancel() {
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ActionCancel());
    }

    public abstract void inconvert(File var1) throws DropSomethingException;

    public abstract void beforeConvert();

    public abstract void afterConvert();

    public abstract void cancelConvert();

    public void addDragAndDropFile(String path) {
        if (this.stack.topControl == this.controler) {
            this.stack.topControl = this.plist;
            this.plist.addFile(path);
            this.layout();
            this.startConvert();
        } else {
            this.plist.addFile(path);
            this.layout();
        }
    }

    public boolean isCanConvert() {
        return this.canConvert;
    }

    public void setCanConvert(boolean canConvert) {
        this.canConvert = canConvert;
    }

    public int compare(Object object) {
        boolean cfr_ignored_0 = object instanceof DropsomethingTab;
        return -1;
    }

    public void initConvert() {
    }

    public void releaseConvert() {
    }

    public boolean accept(File parent, String name) {
        return true;
    }

    public int getProgressMaxBytes() {
        return this.progressMaxBytes;
    }

    public void setProgressMaxBytes(int progressMaxBytes) {
        this.progressMaxBytes = progressMaxBytes;
    }

    public ViewPart getViewPart() {
        return this.viewPart;
    }

    public void setViewPart(ViewPart viewPart) {
        this.viewPart = viewPart;
    }

    public ProcessPrinter getProcessPrinter() {
        return this.processPrinter;
    }

    public void setProcessPrinter(ProcessPrinter processPrinter) {
        this.processPrinter = processPrinter;
    }

    public String getCantConvertStatusbarMessage() {
        return this.cantConvertMessage;
    }

    public void setCantConvertStatusbarMessage(String cantConvertMessage) {
        this.cantConvertMessage = cantConvertMessage;
    }

    public long getProgressMaxTime() {
        return this.progressMaxTime;
    }

    public void setProgressMaxTime(long progressMaxTime) {
        this.progressMaxTime = progressMaxTime;
    }

    public void setProgressKBytes(int kbytes) {
        this.progressKBytes = kbytes;
    }

    public long getProgressTime() {
        return this.progressTime;
    }

    public void setProgressTime(long progressTime) {
        this.progressTime = progressTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public int getProgressKBytes() {
        return this.progressKBytes;
    }

    public class SetProgress
    implements Runnable {
        private int value;

        public SetProgress(int value) {
            this.value = value;
        }

        public void run() {
            DropsomethingTab.this.plist.getProgressBar().setSelection(this.value);
        }
    }

    public class SetCenterText
    implements Runnable {
        private String infoText;

        public SetCenterText(String infoText) {
            this.infoText = infoText;
        }

        public void run() {
            DropsomethingTab.this.plist.setCenterLabelText(this.infoText);
        }
    }

    public class SetHeaderText
    implements Runnable {
        private String infoText;

        public SetHeaderText(String infoText) {
            this.infoText = infoText;
        }

        public void run() {
            DropsomethingTab.this.plist.setHeaderLabelText(this.infoText);
        }
    }

    public class CancelAction
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            DropsomethingTab.this.actionCancel();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class ConvertFile
    implements Runnable {
        public void run() {
            while (true) {
                int size;
                if ((size = DropsomethingTab.this.plist.getSimpleFileList().countFiles()) == 0 || DropsomethingTab.this.cancel) break;
                File file = DropsomethingTab.this.plist.getSimpleFileList().getFileList()[0];
                try {
                    DropsomethingTab.this.inconvert(file);
                }
                catch (DropSomethingException e) {
                    StatusBarUtils.showStatusBar(e.getStatusMessage());
                    if (DropsomethingTab.this.processPrinter != null) {
                        try {
                            DropsomethingTab.this.processPrinter.printError(e.getLogMessage());
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    DropsomethingTab.this.perfomeCancel();
                    e.printStackTrace();
                }
                DropsomethingTab.this.plist.getSimpleFileList().popFile();
                PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new UpdateTable());
            }
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new FinishConvert());
        }
    }

    protected class ActionCancel
    extends Thread {
        protected ActionCancel() {
        }

        public void run() {
            DropsomethingTab.this.actionCancel();
        }
    }

    public class FinishConvert
    implements Runnable {
        public void run() {
            log.info((Object)"finish converting");
            DropsomethingTab.this.afterConvert();
            DropsomethingTab.this.releaseConvert();
            ((DropsomethingTab)DropsomethingTab.this).stack.topControl = DropsomethingTab.this.controler;
            DropsomethingTab.this.layout();
            DropsomethingTab.this.redraw();
        }
    }

    public class UpdateTable
    implements Runnable {
        public void run() {
            DropsomethingTab.this.plist.getSimpleFileList().refresh(true);
            if (DropsomethingTab.this.plist.getSimpleFileList().countFiles() > 0) {
                DropsomethingTab.this.plist.getSimpleFileList().getTable().select(0);
            }
        }
    }

    public class DropMonitor
    extends DropTargetAdapter {
        public DropMonitor(Composite controler) {
            Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
            int operations = 3;
            DropTarget target2 = new DropTarget((Control)controler, operations);
            target2.setTransfer(types);
            target2.addDropListener((DropTargetListener)this);
        }

        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            if (DropsomethingTab.this.isCanConvert()) {
                String[] files = (String[])event.data;
                int i = 0;
                while (i < files.length) {
                    DropsomethingTab.this.addDragAndDropFile(files[i]);
                    ++i;
                }
            } else {
                log.info((Object)("cant convert:" + DropsomethingTab.this.cantConvertMessage));
                StatusBarUtils.showStatusBar(DropsomethingTab.this.cantConvertMessage);
            }
        }
    }

    public class DropSomethingException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private String logMessage;
        private String statusMessage;

        public DropSomethingException(String messages, String statusMessage, String logMessage) {
            super(messages);
            this.statusMessage = statusMessage;
            this.logMessage = logMessage;
        }

        public String getLogMessage() {
            return this.logMessage;
        }

        public void setLogMessage(String logMessage) {
            this.logMessage = logMessage;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }
    }
}

