/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.flvtools.autoconvert;

import java.util.Date;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.dropsomething.FLVConvertTab;
import jp.sourceforge.akjrcp.ui.FTPInfoEditor;
import jp.sourceforge.akjrcp.ui.LogBox;
import jp.sourceforge.akjrcp.util.FTPInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class AutoConvertView
extends ViewPart {
    public static Log log = LogFactory.getLog(AutoConvertView.class);
    public static final String ID = AutoConvertView.class.getName();
    private boolean started = false;
    private StatusMonitor statusMonitor;
    private InputAndOutputMonitor inputAndOutput;
    private FLVConvertTab flvConverter;
    private LogBox logBox;

    public void createPartControl(Composite root) {
        Composite composite = new Composite(root, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.statusMonitor = new StatusMonitor(composite, 0);
        this.inputAndOutput = new InputAndOutputMonitor(composite, 0);
        this.flvConverter = new FLVConvertTab(this, composite, 0);
        this.logBox = new LogBox(composite, 0);
        this.logBox.setLayoutData(new GridData(1808));
    }

    public void setFocus() {
    }

    public void startAutoConvert() {
        if (!this.started) {
            FTPInfo input = this.inputAndOutput.getInputFTPInfo();
            FTPInfo output = this.inputAndOutput.getOutputFTPInfo();
            if (input != null && output != null) {
                this.setStartMode();
                this.startLoop();
            }
        }
    }

    public void startLoop() {
        FTPConverter t = new FTPConverter();
        t.start();
    }

    private void setStartMode() {
        this.started = true;
        this.inputAndOutput.setEnabled(false);
        this.flvConverter.setEnabled(false);
        this.statusMonitor.setStart();
    }

    private void setStopMode() {
        this.started = false;
        this.inputAndOutput.setEnabled(true);
        this.flvConverter.setEnabled(true);
        this.statusMonitor.setStop();
    }

    public void stopAutoConvert() {
        if (this.started) {
            this.setStopMode();
            this.startLoop();
        }
    }

    public void printLog(String line) {
        this.getSite().getShell().getDisplay().asyncExec((Runnable)new LogPrinter(line));
    }

    public void logging(String line) {
        Date d = new Date();
        this.logBox.add("[" + d + "] " + line);
    }

    public class InputAndOutputMonitor
    extends Composite {
        private Composite inputSource;
        private Composite outputSource;
        private CCombo inputFTP;
        private CCombo outputFTP;
        private CCombo inputType;
        private CCombo outputType;
        private StackLayout inputSourceLayout;
        private StackLayout outputSourceLayout;
        private FTPInfo[] ftpInfos;

        public InputAndOutputMonitor(Composite parent, int style) {
            super(parent, style);
            this.setLayoutData(new GridData(768));
            this.setLayout((Layout)new GridLayout(2, false));
            Group input = new Group((Composite)this, 0);
            input.setText(Messages.getString("autoconvert.input"));
            input.setLayoutData((Object)new GridData(1808));
            input.setLayout((Layout)new GridLayout(2, true));
            Group output = new Group((Composite)this, 0);
            output.setText(Messages.getString("autoconvert.output"));
            output.setLayoutData((Object)new GridData(768));
            output.setLayout((Layout)new GridLayout(2, true));
            this.inputType = this.createType((Composite)input);
            this.inputType.setLayoutData((Object)new GridData(768));
            this.outputType = this.createType((Composite)output);
            this.inputSource = new Composite((Composite)input, 0);
            this.inputSource.setLayoutData((Object)new GridData(768));
            this.outputSource = new Composite((Composite)output, 0);
            this.inputSourceLayout = new StackLayout();
            this.outputSourceLayout = new StackLayout();
            this.inputSource.setLayout((Layout)this.inputSourceLayout);
            this.outputSource.setLayout((Layout)this.outputSourceLayout);
            this.inputFTP = this.createFTP(this.inputSource);
            this.outputFTP = this.createFTP(this.outputSource);
            this.inputSourceLayout.topControl = this.inputFTP;
            this.outputSourceLayout.topControl = this.outputFTP;
            this.updateFTPValues();
            Akj_betasPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)new ValueMonitor());
        }

        private void updateFTPValues() {
            FTPInfo[] infos = FTPInfoEditor.toFTPInfos(Akj_betasPlugin.getDefault().getPreferenceStore().getString("export.ftps"));
            this.ftpInfos = infos;
            this.updateCCombo(this.inputFTP, infos);
            this.updateCCombo(this.outputFTP, infos);
        }

        private void updateCCombo(CCombo combo, FTPInfo[] infos) {
            String defaultValue = null;
            int index = combo.getSelectionIndex();
            if (index != -1) {
                defaultValue = combo.getItem(index);
            }
            combo.removeAll();
            int i = 0;
            while (i < infos.length) {
                combo.add(infos[i].getName());
                if (infos[i].getName().equals(defaultValue)) {
                    combo.select(i);
                }
                ++i;
            }
            if (defaultValue == null && infos.length > 0) {
                combo.select(0);
            }
        }

        private CCombo createFTP(Composite parent) {
            CCombo combo = new CCombo(parent, 8);
            return combo;
        }

        private CCombo createType(Composite parent) {
            CCombo combo = new CCombo(parent, 8);
            combo.add("FTP");
            combo.select(0);
            return combo;
        }

        public FTPInfo getOutputFTPInfo() {
            int index = this.outputFTP.getSelectionIndex();
            if (index != -1) {
                return this.ftpInfos[index];
            }
            return null;
        }

        public FTPInfo getInputFTPInfo() {
            int index = this.inputFTP.getSelectionIndex();
            if (index != -1) {
                return this.ftpInfos[index];
            }
            return null;
        }

        public class ValueMonitor
        implements IPropertyChangeListener {
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("export.ftps")) {
                    InputAndOutputMonitor.this.updateFTPValues();
                }
            }
        }
    }

    public class StatusMonitor
    extends Composite {
        private Label currentStatus;
        private Button controlButton;
        public final String WORKING = "working";
        public final String STOPPED = "stopped";
        public final String START_MONITOR = "start";
        public final String STOP_MONITOR = "stop";

        public StatusMonitor(Composite parent, int style) {
            super(parent, style);
            this.WORKING = "working";
            this.STOPPED = "stopped";
            this.START_MONITOR = "start";
            this.STOP_MONITOR = "stop";
            this.setLayout((Layout)new GridLayout(2, true));
            this.currentStatus = new Label((Composite)this, 0);
            this.currentStatus.setText("stopped");
            this.controlButton = new Button((Composite)this, 0);
            this.controlButton.setText("start");
            this.controlButton.addSelectionListener((SelectionListener)new ControlButtonAction());
        }

        public void setStart() {
            this.controlButton.setText("stop");
            this.currentStatus.setText("working");
        }

        public void setStop() {
            this.controlButton.setText("start");
            this.currentStatus.setText("stopped");
        }
    }

    public class FTPConverter
    extends Thread {
        public void run() {
            while (AutoConvertView.this.started) {
                AutoConvertView.this.printLog("check files");
                String[] uploadedLists = this.getUploadedList();
                String[] downloadLists = this.getDownloList();
                if (downloadLists.length == 0) {
                    AutoConvertView.this.printLog("idol");
                    this.sleepSecond(30);
                    continue;
                }
                int i = 0;
                while (i < downloadLists.length) {
                    this.shouldEncode(downloadLists[i], uploadedLists);
                    ++i;
                }
                AutoConvertView.this.printLog("wait");
                this.sleepSecond(15);
            }
        }

        private boolean shouldEncode(String string, String[] uploadedLists) {
            return false;
        }

        private String[] getDownloList() {
            return null;
        }

        private String[] getUploadedList() {
            return null;
        }

        private void sleepSecond(int second) {
            try {
                Thread.sleep(1000 * second);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public class LogPrinter
    extends Thread {
        private String line;

        public LogPrinter(String line) {
            this.line = line;
        }

        public void run() {
            Date d = new Date();
            AutoConvertView.this.logBox.add("[" + d + "] " + this.line);
        }
    }

    public class ControlButtonAction
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            if (AutoConvertView.this.started) {
                AutoConvertView.this.logging("stop");
                AutoConvertView.this.stopAutoConvert();
            } else {
                AutoConvertView.this.logging("start");
                AutoConvertView.this.startAutoConvert();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

