/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.psp.imageconvert;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.psp.PSPUtils;
import jp.sourceforge.akjrcp.psp.imageconvert.ImageChanger;
import jp.sourceforge.akjrcp.psp.imageconvert.ImageResizer;
import jp.sourceforge.akjrcp.psp.imageconvert.ImageSplitter;
import jp.sourceforge.akjrcp.psp.imageconvert.ImageTurner;
import jp.sourceforge.akjrcp.psp.imageconvert.SupportCancel;
import jp.sourceforge.akjrcp.ui.FileDirChoicer;
import jp.sourceforge.akjrcp.ui.GenericParameters;
import jp.sourceforge.akjrcp.ui.LayoutDataBuilder;
import jp.sourceforge.akjrcp.ui.WidgetBuilder;
import jp.sourceforge.akjrcp.ui.param.ParamBoolean;
import jp.sourceforge.akjrcp.ui.param.ParamCheckGroup;
import jp.sourceforge.akjrcp.ui.param.ParamCombo;
import jp.sourceforge.akjrcp.ui.param.ParamItem;
import jp.sourceforge.akjrcp.ui.param.ParamItemActionListener;
import jp.sourceforge.akjrcp.ui.param.ParamRadioComposite;
import jp.sourceforge.akjrcp.ui.param.ParamRadioContainer;
import jp.sourceforge.akjrcp.ui.param.ParamScale;
import jp.sourceforge.akjrcp.ui.param.ParamTab;
import jp.sourceforge.akjrcp.ui.param.ParamText;
import jp.sourceforge.akjrcp.ui.param.ParamTextArea;
import jp.sourceforge.akjrcp.util.ExecutingControler;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import jp.sourceforge.akjrcp.util.ProgressMonitorUtils;
import jp.sourceforge.akjrcp.util.StatusBarUtils;
import jp.sourceforge.akjrcp.util.image.ImageUtils;
import jp.sourceforge.akjrcp.videotools.dvdtoxvid.CheckToRadio;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSPImageImportViewer
extends ViewPart {
    public static Log log = LogFactory.getLog(PSPImageImportViewer.class);
    public static final String ID = PSPImageImportViewer.class.getName();
    private FileDirChoicer inputDirChooser;
    private FileDirChoicer outputDirChooser;
    private PSPImageImportExecute pspImageImportExecute;
    private ParamRadioComposite imageType;
    private ParamRadioComposite splitWidthSize;
    private ParamTab modeTab;
    private Button splitTypePixel;
    private Button splitTypeNum;
    private ParamBoolean supportDoubleSizeCheck;
    private ParamBoolean keepAspectCheck;
    private ParamScale jpegQualityScale;
    private ParamRadioComposite turnTypeRadio;
    private ParamRadioComposite turnSize;
    private ParamRadioComposite fitSizeSizeRadio;
    private ParamRadioComposite fitWidthSizeRadio;
    private ParamRadioComposite fitHeightSizeRadio;
    private ParamCombo minSupportWidthCombo;
    private ParamCombo maxSplitCombo;
    private ParamCombo overWrapSizeCombo;
    private ParamCheckGroup importImages;
    private ParamCsvUpdater paramCsvUpdater = new ParamCsvUpdater();
    String widgetKey = String.valueOf(ID) + "_widget";

    public void createPartControl(Composite parent) {
        this.pspImageImportExecute = new PSPImageImportExecute();
        parent.setLayout((Layout)new GridLayout(1, false));
        this.importImages = new ParamCheckGroup(parent, 0, "import_image", Messages.getString("pspimage.import_image"), new String[]{"JPEG", "PNG", "GIF"}, 3);
        this.importImages.setValue("JPEG+PNG+GIF");
        this.paramCsvUpdater.add(this.importImages);
        Group export = WidgetBuilder.createFillLayoutGroup(parent, 0);
        export.setLayoutData((Object)LayoutDataBuilder.fillHorizontalGridData());
        export.setText(Messages.getString("pspimage.convert_type"));
        this.modeTab = new ParamTab((Composite)export, 0, "convert_type");
        Composite splitMode = this.modeTab.createGridLayoutTab(Messages.getString("pspimage.split"), 0);
        this.paramCsvUpdater.add(this.modeTab);
        ParamRadioContainer convertTypeRadios = new ParamRadioContainer("convertType");
        this.paramCsvUpdater.add(convertTypeRadios);
        Composite splitType = WidgetBuilder.createGridLayoutComposite(splitMode, 0, 4, false);
        this.splitTypeNum = convertTypeRadios.createButton(splitType, 0, "", "splitTypeNum");
        this.maxSplitCombo = new ParamCombo(new BothLabelComposite(splitType, 0, Messages.getString("pspimage.min_split"), "").getComposite(), 0, "maxSplitCombo", "", new String[]{"3", "4", "5"});
        this.paramCsvUpdater.add(this.maxSplitCombo);
        this.maxSplitCombo.setValue("4");
        this.splitTypePixel = convertTypeRadios.createButton(splitType, 0, "", "splitTypePixel");
        this.overWrapSizeCombo = new ParamCombo(new BothLabelComposite(splitType, 0, Messages.getString("pspimage.overwrap"), "%").getComposite(), 0, "overWrapSize", "", new String[]{"50", "33", "25", "10", "5", "0"});
        this.paramCsvUpdater.add(this.overWrapSizeCombo);
        this.overWrapSizeCombo.setValue("25");
        Composite width_keep = WidgetBuilder.createGridLayoutComposite(splitMode, 0, 2, false);
        LabelComposite w_v = new LabelComposite(width_keep, 0, Messages.getString("pspimage.width"));
        this.splitWidthSize = new ParamRadioComposite(w_v, 0, "splitWidthSize", new String[]{"240", "480", "720", "960", "1440", "1920"}, new String[]{"240", "480", "720", "960", "1440", "1920"}, 6);
        this.paramCsvUpdater.add(this.splitWidthSize);
        this.splitWidthSize.setValue("480");
        this.keepAspectCheck = new ParamBoolean(width_keep, 0, "keep_aspect", Messages.getString("pspimage.keep_aspect"));
        this.paramCsvUpdater.add(this.keepAspectCheck);
        this.keepAspectCheck.setBoolean(true);
        Composite doubleContainer = WidgetBuilder.createGridLayoutComposite(splitMode, 0, 2, false);
        this.supportDoubleSizeCheck = new ParamBoolean(doubleContainer, 0, "support_double", Messages.getString("pspimage.support_double"));
        this.paramCsvUpdater.add(this.supportDoubleSizeCheck);
        this.supportDoubleSizeCheck.setBoolean(true);
        this.minSupportWidthCombo = new ParamCombo(doubleContainer, 0, "minDoubleWidth", Messages.getString("pspimage.min_double_width"), new String[]{"800", "1000", "1300", "1800", "2600"});
        this.paramCsvUpdater.add(this.minSupportWidthCombo);
        this.minSupportWidthCombo.setValue("1300");
        Composite turnMode = this.modeTab.createGridLayoutTab(Messages.getString("pspimage.turn"), 0);
        turnMode.setLayoutData((Object)LayoutDataBuilder.fillBothGridData());
        this.turnTypeRadio = new ParamRadioComposite(turnMode, 0, "turnType", new String[]{"LEFT", "RIGHT"}, new String[]{Messages.getString("pspimage.left"), Messages.getString("pspimage.right")}, 2);
        this.paramCsvUpdater.add(this.turnTypeRadio);
        this.turnTypeRadio.setValue("RIGHT");
        this.turnSize = new ParamRadioComposite(turnMode, 0, "turnSize", new String[]{"272x480", "542x960"}, new String[]{"272x480", "542x960"}, 2);
        this.paramCsvUpdater.add(this.turnSize);
        this.turnSize.setValue("542x960");
        Composite fitSize = this.modeTab.createGridLayoutTab(Messages.getString("pspimage.fit_size"), 0);
        fitSize.setLayoutData((Object)LayoutDataBuilder.fillBothGridData());
        this.fitSizeSizeRadio = new ParamRadioComposite(fitSize, 0, "fitSizeSize", new String[]{"320x240", "480x272", "960x542"}, new String[]{"320x240", "480x272", "960x542"}, 3);
        this.paramCsvUpdater.add(this.fitSizeSizeRadio);
        this.fitSizeSizeRadio.setValue("480x272");
        Composite fitWidth = this.modeTab.createGridLayoutTab(Messages.getString("pspimage.fit_width"), 0);
        fitWidth.setLayoutData((Object)LayoutDataBuilder.fillBothGridData());
        this.fitWidthSizeRadio = new ParamRadioComposite(fitWidth, 0, "fitWidthSize", new String[]{"240", "480", "960"}, new String[]{"240", "480", "960"}, 3);
        this.fitWidthSizeRadio.setValue("480");
        this.paramCsvUpdater.add(this.fitWidthSizeRadio);
        Composite fitHeight = this.modeTab.createGridLayoutTab(Messages.getString("pspimage.fit_height"), 0);
        fitHeight.setLayoutData((Object)LayoutDataBuilder.fillBothGridData());
        this.fitHeightSizeRadio = new ParamRadioComposite(fitHeight, 0, "fitHeightSize", new String[]{"136", "272", "544"}, new String[]{"136", "272", "544"}, 3);
        this.paramCsvUpdater.add(this.fitHeightSizeRadio);
        this.fitHeightSizeRadio.setValue("272");
        FileSelected selectedListener = new FileSelected();
        this.inputDirChooser = new FileDirChoicer(parent, 2048, 3, Messages.getString("pspimage.input"));
        this.inputDirChooser.setLayoutData(new GridData(768));
        this.inputDirChooser.addFileListChangeListener(selectedListener);
        this.inputDirChooser.setFilterExtensions(new String[]{"*.zip"});
        Composite outputs = WidgetBuilder.createGridLayoutComposite(parent, 2048, 2, false);
        outputs.setLayoutData((Object)LayoutDataBuilder.fillHorizontalGridData());
        this.outputDirChooser = new FileDirChoicer(outputs, 0, 1, Messages.getString("pspimage.output"));
        this.outputDirChooser.setLayoutData(new GridData(768));
        this.outputDirChooser.addFileListChangeListener(selectedListener);
        Button pspExport = WidgetBuilder.createButton(outputs, Messages.getString("pspimage.select_pspdir"));
        pspExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PSPImageImportViewer.this.setPSPDir();
            }
        });
        Composite exportType = new Composite(outputs, 0);
        GridData exdata = new GridData(768);
        exdata.horizontalSpan = 2;
        exportType.setLayoutData((Object)exdata);
        exportType.setLayout((Layout)new GridLayout(3, false));
        Label exportLabel = new Label(exportType, 0);
        exportLabel.setText(Messages.getString("pspimage.export_type"));
        this.imageType = new ParamRadioComposite(exportType, 0, "imageType", new String[]{"JPEG"}, new String[]{"JPEG"}, 2);
        this.imageType.setValue("JPEG");
        this.paramCsvUpdater.add(this.imageType);
        this.jpegQualityScale = new ParamScale(exportType, 0, "jpeg_quality", Messages.getString("pspimage.jpeg_quality"), 1, 90, 100);
        this.jpegQualityScale.setLayoutData(LayoutDataBuilder.fillHorizontalGridData());
        this.jpegQualityScale.getScale().setLayoutData((Object)LayoutDataBuilder.fillHorizontalGridData());
        this.paramCsvUpdater.add(this.jpegQualityScale);
        this.pspImageImportExecute.addControl((Control)this.inputDirChooser);
        this.pspImageImportExecute.addControl((Control)this.outputDirChooser);
        this.pspImageImportExecute.addControl((Control)pspExport);
        ExecutingControler.ExecutingControlButton exec = new ExecutingControler.ExecutingControlButton(parent, 0, this.pspImageImportExecute, Messages.getString("exec"), Messages.getString("cancel"));
        exec.setLayoutData(LayoutDataBuilder.hintGridData(100, 40));
        this.pspImageImportExecute.updateControlSwitch();
        this.loadParameters(this.widgetKey);
        this.getSite().getPage().addPartListener((IPartListener2)new ParamSaver());
        new DropMonitor(parent);
    }

    protected void setPSPDir() {
        File pspDir = PSPUtils.findPSPDrive();
        if (pspDir != null) {
            if (PSPUtils.existPictureFolder(pspDir)) {
                this.outputDirChooser.setFile(new File(pspDir, "PICTURE"));
            } else {
                boolean bool = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.getString("pspimage.make_picture"), (String)Messages.getString("pspimage.can_i_make"));
                if (bool) {
                    boolean result = new File(pspDir, "PICTURE").mkdir();
                    if (result) {
                        this.outputDirChooser.setFile(new File(pspDir, "PICTURE"));
                    } else {
                        log.warn((Object)"make picture folder faild");
                    }
                }
            }
            this.pspImageImportExecute.updateControlSwitch();
            StatusBarUtils.showStatusBar("");
        } else {
            StatusBarUtils.showStatusBar(Messages.getString("pspimage.not_psp_connected"));
        }
    }

    public void dropFile(String path) {
        this.inputDirChooser.setFilePath(path);
        if (this.outputDirChooser.getAbsoluteFilePath().equals("")) {
            this.setPSPDir();
        }
        if (this.pspImageImportExecute.canExecute() && !this.pspImageImportExecute.isExecuting()) {
            this.pspImageImportExecute.execute();
        }
    }

    public void setFocus() {
    }

    private Composite createSplitComposite(Composite parent, int split, boolean same, Object data) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(split, same));
        if (data != null) {
            composite.setLayoutData(data);
        }
        return composite;
    }

    private ParamTextArea createGridTextAreaGroup(Composite parent, String key, String label, Object data) {
        ParamTextArea text = new ParamTextArea(parent, 0, key, label, -1);
        text.setLayoutData(data);
        return text;
    }

    private ParamText createLabeldText(Composite parent, String key, String label, Object data) {
        ParamText text = new ParamText(parent, 0, key, label, 0);
        if (data != null) {
            text.setLayoutData(data);
        }
        return text;
    }

    public void saveParameters(String key) {
        Akj_betasPlugin.getDefault().getPluginPreferences().setValue(key, this.paramCsvUpdater.getCsv());
    }

    public GenericParameters getDefaultParameters() {
        new GenericParameters();
        return null;
    }

    public void loadParameters(String key) {
        String csv = Akj_betasPlugin.getDefault().getPluginPreferences().getString(key);
        GenericParameters gm = null;
        gm = csv.equals("") ? this.getDefaultParameters() : GenericParameters.csvToParameters(csv);
        if (gm != null) {
            this.setParameters(gm.getParameters());
        }
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        int i = 0;
        while (i < this.paramCsvUpdater.getParamList().size()) {
            ParamItem item = this.paramCsvUpdater.getParamList().get(i);
            if (item.getValue().length() > 0) {
                parameterMap.put(item.getKey(), item.getValue());
            }
            ++i;
        }
        return parameterMap;
    }

    public void setParameters(Map map) {
        int i = 0;
        while (i < this.paramCsvUpdater.getParamList().size()) {
            ParamItem item = this.paramCsvUpdater.getParamList().get(i);
            String value = (String)map.get(item.getKey());
            if (value != null) {
                item.setValue(value);
            } else {
                item.setValue("");
            }
            ++i;
        }
    }

    public class DropMonitor
    extends DropTargetAdapter {
        public DropMonitor(Composite controler) {
            Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
            int operations = 3;
            DropTarget target2 = new DropTarget((Control)controler, operations);
            target2.setTransfer(types);
            target2.addDropListener((DropTargetListener)this);
        }

        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            block0: {
                String[] files = (String[])event.data;
                int i = 0;
                if (i >= files.length) break block0;
                PSPImageImportViewer.this.dropFile(files[i]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ParamCsvUpdater
    implements ParamItemActionListener {
        private String csv;
        protected List<ParamItem> paramList = new ArrayList<ParamItem>();

        @Override
        public void paramItemModified(ParamItem item) {
            this.csv = GenericParameters.mapToCsv(PSPImageImportViewer.this.getParameters());
        }

        public String getCsv() {
            return this.csv;
        }

        public void add(ParamItem item) {
            this.paramList.add(item);
            item.setParamItemActionListener(this);
        }

        public List<ParamItem> getParamList() {
            return this.paramList;
        }

        public void setParamList(List<ParamItem> paramList) {
            this.paramList = paramList;
        }
    }

    public class LabeledCheckedGrup
    extends Composite {
        private Button checkButton;
        private Label label;
        private Composite container;
        private Group group;

        public LabeledCheckedGrup(Composite parent, int style, String labelText, CheckToRadio checkToRadio) {
            super(parent, style);
            this.setLayout((Layout)new FillLayout());
            this.group = new Group((Composite)this, 0);
            this.group.setLayout((Layout)new GridLayout());
            Composite labels = new Composite((Composite)this.group, 0);
            labels.setLayout((Layout)new GridLayout(2, false));
            labels.setLayoutData((Object)LayoutDataBuilder.fillHorizontalGridData());
            this.checkButton = checkToRadio.createButton(labels, 32);
            this.checkButton.setData("label", (Object)labelText);
            this.label = new Label(labels, 0);
            this.label.setForeground(new Color(null, 0, 70, 213));
            this.label.setLayoutData((Object)LayoutDataBuilder.fillHorizontalGridData());
            this.label.setText(labelText);
            this.container = new Composite((Composite)this.group, 0);
            this.container.setLayoutData((Object)LayoutDataBuilder.fillBothGridData());
            this.container.setLayout((Layout)new GridLayout());
        }

        public Button getCheckButton() {
            return this.checkButton;
        }

        public void setCheckButton(Button checkButton) {
            this.checkButton = checkButton;
        }

        public Composite getContainer() {
            return this.container;
        }

        public void setContainer(Composite container) {
            this.container = container;
        }

        public Group getGroup() {
            return this.group;
        }

        public void setGroup(Group group) {
            this.group = group;
        }

        public Label getLabel() {
            return this.label;
        }

        public void setLabel(Label label) {
            this.label = label;
        }
    }

    public class LabelComposite
    extends Composite {
        private Label label;

        public LabelComposite(Composite parent, int style, String text) {
            super(parent, style);
            this.setLayout((Layout)new GridLayout(2, false));
            this.label = new Label((Composite)this, 0);
            this.label.setText(text);
        }

        public Label getLabel() {
            return this.label;
        }

        public void setLabel(Label label) {
            this.label = label;
        }
    }

    public class BothLabelComposite
    extends Composite {
        private Label headerLabel;
        private Label footerLabel;
        private Composite composite;

        public Composite getComposite() {
            return this.composite;
        }

        public void setComposite(Composite composite) {
            this.composite = composite;
        }

        public Label getFooterLabel() {
            return this.footerLabel;
        }

        public void setFooterLabel(Label footerLabel) {
            this.footerLabel = footerLabel;
        }

        public Label getHeaderLabel() {
            return this.headerLabel;
        }

        public void setHeaderLabel(Label headerLabel) {
            this.headerLabel = headerLabel;
        }

        public BothLabelComposite(Composite parent, int style, String header, String footer) {
            super(parent, style);
            this.setLayout((Layout)new GridLayout(3, false));
            this.headerLabel = new Label((Composite)this, 0);
            this.headerLabel.setText(header);
            this.composite = new Composite((Composite)this, 0);
            this.composite.setLayout((Layout)new FillLayout());
            this.footerLabel = new Label((Composite)this, 0);
            this.footerLabel.setText(footer);
        }
    }

    public class PSPImageImportExecute
    extends ExecutingControler {
        private String inputDirChooser_value;
        private String outputDirChooser_value;
        private int overWrapSize_value;
        private int imageWidth;
        private int imageHeight;
        private int mode;
        public static final int SPLIT = 0;
        public static final int TURN = 1;
        public static final int SIZE = 2;
        public static final int WIDTH = 3;
        public static final int HEIGHT = 4;
        private SupportCancel supportCancel;
        private boolean convertJpeg;
        private boolean convertGif;
        private boolean convertPng;
        private IProgressMonitor monitor;
        private boolean isSplitTypePixel;
        private int splitNum_value;
        private boolean supportDouble;
        private float jpegQuality;
        private int turnType_value;
        private ImageChanger imageChanger;
        private int minDoubleSize;
        private boolean cancelChange;
        private boolean keepAspect;

        public void afterExecute() {
        }

        public void beforeExecute() {
            PSPImageImportViewer.this.pspImageImportExecute.updateControlSwitch();
            this.convertJpeg = false;
            this.convertPng = false;
            this.convertGif = false;
            this.cancelChange = false;
            String[] importImageValues = PSPImageImportViewer.this.importImages.getSelectionValues();
            int i = 0;
            while (i < importImageValues.length) {
                if (importImageValues[i].equals("JPEG")) {
                    this.convertJpeg = true;
                }
                if (importImageValues[i].equals("GIF")) {
                    this.convertGif = true;
                }
                if (importImageValues[i].equals("PNG")) {
                    this.convertPng = true;
                }
                ++i;
            }
            this.jpegQuality = (float)PSPImageImportViewer.this.jpegQualityScale.getScale().getSelection() / 100.0f;
            String label = PSPImageImportViewer.this.modeTab.getValue();
            if (label.equals(Messages.getString("pspimage.split"))) {
                this.mode = 0;
                this.overWrapSize_value = this.toInt(PSPImageImportViewer.this.overWrapSizeCombo.getValue(), 90);
                this.splitNum_value = this.toInt(PSPImageImportViewer.this.maxSplitCombo.getValue(), 4);
                this.imageWidth = this.toInt(PSPImageImportViewer.this.splitWidthSize.getValue(), 480);
                this.isSplitTypePixel = PSPImageImportViewer.this.splitTypePixel.getSelection();
                this.supportDouble = PSPImageImportViewer.this.supportDoubleSizeCheck.getBoolean();
                ImageSplitter splitter = new ImageSplitter();
                splitter.setJpegQuality(this.jpegQuality);
                this.supportCancel = splitter;
                this.keepAspect = PSPImageImportViewer.this.keepAspectCheck.getBoolean();
                double ratio = (double)this.imageWidth / 480.0;
                int h = 272;
                if (this.keepAspect) {
                    h = (int)(ratio * 272.0);
                }
                int overwrap = 0;
                if (this.overWrapSize_value > 0) {
                    overwrap = (int)((double)h * ((double)this.overWrapSize_value / 100.0));
                }
                this.minDoubleSize = this.toInt(PSPImageImportViewer.this.minSupportWidthCombo.getValue(), 1300);
                log.info((Object)("width=" + this.imageWidth + " height=" + h + " overwrap=" + overwrap));
                splitter.setWidth(this.imageWidth);
                splitter.setHeight(h);
                splitter.setOverwrap(overwrap);
                if (!this.isSplitTypePixel) {
                    splitter.setMode(1);
                }
                splitter.setSplitNum(this.splitNum_value);
                splitter.setSupportDoubleSize(this.supportDouble);
                splitter.setDoubleSizeLimit(this.minDoubleSize);
                this.imageChanger = splitter;
            } else if (label.equals(Messages.getString("pspimage.turn"))) {
                this.mode = 1;
                this.imageWidth = this.toInt(PSPImageImportViewer.this.splitWidthSize.getValue(), 480);
                String tSize = PSPImageImportViewer.this.turnSize.getValue();
                if (tSize != null) {
                    int[] wh = FFMpegUtils.sizeToWidthHeight(tSize);
                    this.imageWidth = wh[1];
                    this.imageHeight = wh[0];
                }
                this.turnType_value = PSPImageImportViewer.this.turnTypeRadio.getValue().equals("LEFT") ? 1 : 0;
                ImageTurner turner = new ImageTurner();
                turner.setJpegQuality(this.jpegQuality);
                this.supportCancel = turner;
                turner.setWidth(this.imageWidth);
                turner.setHeight(this.imageHeight);
                turner.setTurnMode(this.turnType_value);
                this.imageChanger = turner;
            } else if (label.equals(Messages.getString("pspimage.fit_size"))) {
                ImageResizer resizer = new ImageResizer();
                resizer.setJpegQuality(this.jpegQuality);
                String tSize = PSPImageImportViewer.this.fitSizeSizeRadio.getValue();
                if (tSize != null) {
                    int[] wh = FFMpegUtils.sizeToWidthHeight(tSize);
                    this.imageWidth = wh[0];
                    this.imageHeight = wh[1];
                }
                resizer.setWidth(this.imageWidth);
                resizer.setHeight(this.imageHeight);
                this.imageChanger = resizer;
            } else if (label.equals(Messages.getString("pspimage.fit_width"))) {
                ImageResizer resizer = new ImageResizer();
                resizer.setJpegQuality(this.jpegQuality);
                this.imageWidth = this.toInt(PSPImageImportViewer.this.fitWidthSizeRadio.getValue(), 480);
                this.imageHeight = 0;
                resizer.setWidth(this.imageWidth);
                resizer.setHeight(this.imageHeight);
                this.imageChanger = resizer;
            } else if (label.equals(Messages.getString("pspimage.fit_height"))) {
                ImageResizer resizer = new ImageResizer();
                resizer.setJpegQuality(this.jpegQuality);
                this.imageWidth = 0;
                this.imageHeight = this.toInt(PSPImageImportViewer.this.fitHeightSizeRadio.getValue(), 480);
                resizer.setWidth(this.imageWidth);
                resizer.setHeight(this.imageHeight);
                this.imageChanger = resizer;
            }
            this.inputDirChooser_value = PSPImageImportViewer.this.inputDirChooser.getAbsoluteFilePath();
            this.outputDirChooser_value = PSPImageImportViewer.this.outputDirChooser.getAbsoluteFilePath();
            this.monitor = ProgressMonitorUtils.getProgressMonitor();
        }

        public int toInt(String text, int defaultValue) {
            try {
                return Integer.parseInt(text);
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }

        public boolean canExecute() {
            return !PSPImageImportViewer.this.inputDirChooser.getAbsoluteFilePath().equals("") && !PSPImageImportViewer.this.outputDirChooser.getAbsoluteFilePath().equals("");
        }

        public void cancelExecuting() {
            if (this.supportCancel != null) {
                this.supportCancel.setCancel(true);
            }
            this.cancelChange = true;
        }

        private boolean isConvertImage(String name) {
            if (this.convertJpeg && ImageUtils.isJpegFile(name)) {
                return true;
            }
            if (this.convertPng && ImageUtils.isPngFile(name)) {
                return true;
            }
            return this.convertGif && ImageUtils.isGifFile(name);
        }

        private void changeImages(File parentFile, String[] names, File output) {
            Arrays.sort(names);
            int folder = 1;
            int psp_max1000 = 1000;
            String baseName = output.getName();
            ZipFile zipFile = null;
            if (FileNameUtils.isZipFile(parentFile.getName())) {
                try {
                    zipFile = new ZipFile(parentFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            int i = 0;
            while (i < names.length) {
                if (this.cancelChange) {
                    return;
                }
                try {
                    String name = null;
                    InputStream input = null;
                    if (parentFile.isDirectory()) {
                        name = names[i];
                        input = new FileInputStream(new File(parentFile, names[i]));
                    } else if (FileNameUtils.isZipFile(parentFile.getName())) {
                        name = names[i];
                        ZipEntry entry = zipFile.getEntry(names[i]);
                        input = zipFile.getInputStream(entry);
                    } else {
                        log.warn((Object)("not supported file:" + parentFile.getAbsolutePath()));
                    }
                    this.imageChanger.changeImage(name, input, output);
                    try {
                        input.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ProgressMonitorUtils.workedMonitor(this.monitor, 1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            this.imageChanger.clear();
            File[] imageFiles = this.sortByLastModified(output, output.list());
            int i2 = 0;
            while (i2 < names.length) {
                ++i2;
            }
            File moveTo = null;
            int i3 = psp_max1000;
            while (i3 < imageFiles.length) {
                boolean ret;
                if (i3 % psp_max1000 == 0) {
                    moveTo = new File(output.getParent(), String.valueOf(baseName) + "[" + folder + "]");
                    moveTo.mkdir();
                    ++folder;
                }
                if (!(ret = imageFiles[i3].renameTo(new File(moveTo, imageFiles[i3].getName())))) {
                    log.warn((Object)("rename faild:" + imageFiles[i3]));
                } else {
                    log.info((Object)("renamed:" + imageFiles[i3]));
                }
                ++i3;
            }
        }

        public File[] sortByLastModified(File parent, String[] list) {
            File[] files = new File[list.length];
            int i = 0;
            while (i < files.length) {
                files[i] = new File(parent, list[i]);
                ++i;
            }
            Arrays.sort(files, new LastModofiedComparater());
            return files;
        }

        public void inExecute() {
            Akj_betasPlugin.getDefault().startLogSession();
            System.gc();
            File input = new File(this.inputDirChooser_value);
            File outputParent = new File(this.outputDirChooser_value);
            if (!outputParent.exists()) {
                StatusBarUtils.showStatusBar(Messages.getString("pspimage.dir_not_found"));
                return;
            }
            File output = null;
            String fileName = input.getName();
            if (input.isDirectory()) {
                output = new File(FileNameUtils.getNotFoundFileName(new File(outputParent, input.getName())));
            } else if (ImageUtils.isImageFile(input.getAbsolutePath())) {
                output = new File(FileNameUtils.getNotFoundFileName(new File(outputParent, FileNameUtils.getRemovedExtensionName(input.getName()))));
            } else if (FileNameUtils.isZipFile(input.getName())) {
                output = new File(FileNameUtils.getNotFoundFileName(new File(outputParent, FileNameUtils.getRemovedExtensionName(input.getName()))));
            } else {
                Akj_betasPlugin.getDefault().logPrintln(String.valueOf(Messages.getString("pspimage.not_supported_file")) + input.getName());
                return;
            }
            log.trace((Object)("mode:" + this.mode));
            ArrayList<String> imageNames = new ArrayList<String>();
            if (input.isDirectory()) {
                String[] list = input.list();
                int i = 0;
                while (i < list.length) {
                    if (this.isConvertImage(list[i])) {
                        imageNames.add(list[i]);
                    }
                    ++i;
                }
            } else if (FileNameUtils.isZipFile(input.getName())) {
                try {
                    ZipFile zip = new ZipFile(input);
                    Enumeration en = zip.getEntries();
                    while (en.hasMoreElements()) {
                        ZipEntry entry = (ZipEntry)en.nextElement();
                        if (!this.isConvertImage(entry.getName())) continue;
                        imageNames.add(entry.getName());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                input = input.getParentFile();
                imageNames.add(fileName);
            }
            ProgressMonitorUtils.beginMonitor(this.monitor, Messages.getString("pspimage.start_convert"), imageNames.size());
            Akj_betasPlugin.getDefault().logPrintln(String.valueOf(fileName) + " " + imageNames.size() + " pictures");
            try {
                if (imageNames.size() > 0) {
                    output.mkdir();
                    this.changeImages(input, imageNames.toArray(new String[imageNames.size()]), output);
                    Akj_betasPlugin.getDefault().logPrintln(Messages.getString("pspimage.convert_finished"));
                } else {
                    StatusBarUtils.showStatusBar(Messages.getString("pspimage.empty_image"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                StatusBarUtils.showStatusBar("faild_maybe_memory_error");
            }
            ProgressMonitorUtils.doneMonitor(this.monitor);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class LastModofiedComparater
        implements Comparator<File> {
            @Override
            public int compare(File file1, File file2) {
                long t = file1.lastModified() - file2.lastModified();
                if (t < 0L) {
                    return -1;
                }
                if (t > 0L) {
                    return 1;
                }
                return 0;
            }
        }
    }

    public class FileSelected
    implements FileDirChoicer.FileStatusChangeListener {
        public void addList(FileDirChoicer.FileStatusChangeEvent event) {
            PSPImageImportViewer.this.pspImageImportExecute.updateControlSwitch();
        }

        public void removeList(FileDirChoicer.FileStatusChangeEvent event) {
            PSPImageImportViewer.this.pspImageImportExecute.updateControlSwitch();
        }
    }

    public class ParamSaver
    implements IPartListener2 {
        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
            if (partRef.getId().equals(ID)) {
                PSPImageImportViewer.this.saveParameters(PSPImageImportViewer.this.widgetKey);
            }
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }
    }
}

