/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.snack;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.snack.Spectrogram;
import jp.sourceforge.akjrcp.snack.SpectrogramGifConverter;
import jp.sourceforge.akjrcp.snack.SpectrogramListener;
import jp.sourceforge.akjrcp.snack.SpectrogramParser;
import jp.sourceforge.akjrcp.ui.ProgressMonitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpectrogramExecuter {
    public static Log log = LogFactory.getLog(SpectrogramExecuter.class);
    private String spectrogramExePath;
    private Process process;
    private boolean cancel;

    public void cancel() {
        this.cancel = true;
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public void createSpectrogramImage(File[] audioFile, String outputDir, int samplerate, int width, int height, double persample, int start, int end, ProgressMonitor monitor, SpectrogramListener listener) throws IOException {
        SpectrogramGifConverter parser = new SpectrogramGifConverter(samplerate, height, persample);
        parser.setImageWidth(width);
        parser.setProgressMonitor(monitor);
        parser.setSpectrogramListener(listener);
        parser.setExportPath(outputDir);
        int i = 0;
        while (i < audioFile.length) {
            if (this.cancel) {
                return;
            }
            String[] argv = new String[]{this.spectrogramExePath, audioFile[i].getAbsolutePath(), "" + height, "" + persample, "" + start, "" + end};
            Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(String.valueOf(FFMpegUtils.toPrintCommand(argv)) + "\n");
            log.trace((Object)"start:getSpectoram");
            this.process = Runtime.getRuntime().exec(argv);
            log.trace((Object)"end:getSpectoram");
            if (this.process != null) {
                InputStream input = null;
                if (this.process != null && (input = this.process.getInputStream()) != null) {
                    long starttime = System.currentTimeMillis();
                    log.trace((Object)"start-parse-spectrogram:");
                    parser.parse(input);
                    log.trace((Object)("end-parse-spectrogram:" + (System.currentTimeMillis() - starttime) + "ms"));
                }
            }
            ++i;
        }
    }

    public Spectrogram getSpectram(String path, int samplerate, int height, int persample, int start, int end) throws IOException {
        return this.getSpectram(path, samplerate, height, persample, start, end, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Spectrogram getSpectram(String path, int samplerate, int height, int persample, int start, int end, ProgressMonitor monitor) throws IOException {
        Spectrogram spectrogram = null;
        String[] argv = new String[]{this.spectrogramExePath, path, "" + height, "" + persample, "" + start, "" + end};
        log.trace((Object)"start:getSpectoram");
        this.process = Runtime.getRuntime().exec(argv);
        log.trace((Object)"end:getSpectoram");
        if (this.process != null) {
            InputStream input = null;
            SpectrogramExecuter spectrogramExecuter = this;
            synchronized (spectrogramExecuter) {
                if (this.process != null && (input = this.process.getInputStream()) != null) {
                    long starttime = System.currentTimeMillis();
                    log.trace((Object)"start-parse-spectrogram:");
                    SpectrogramParser parser = new SpectrogramParser(samplerate, height, persample);
                    parser.setProgressMonitor(monitor);
                    spectrogram = (Spectrogram)parser.parse(input);
                    log.trace((Object)("end-parse-spectrogram:" + (System.currentTimeMillis() - starttime) + "ms"));
                }
            }
        }
        return spectrogram;
    }

    public String getSpectrogramExePath() {
        return this.spectrogramExePath;
    }

    public void setSpectrogramExePath(String spectrogramExePath) {
        this.spectrogramExePath = spectrogramExePath;
    }
}

