/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.subtitle;

import jp.sourceforge.akjrcp.ui.ImageCanvas;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class SubtitleEditView
extends ViewPart {
    public static Log log = LogFactory.getLog(SubtitleEditView.class);
    public static final String ID = SubtitleEditView.class.getName();
    private ImageCanvas imageCanvas;
    GC gc;

    public static void makeButton(Composite parent, String imageID) {
        Button bt = new Button(parent, 0);
        bt.setImage(PlatformUI.getWorkbench().getSharedImages().getImage(imageID));
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(8, false));
        SubtitleEditView.makeButton(parent, "IMG_OBJ_PROJECT");
        SubtitleEditView.makeButton(parent, "IMG_OBJ_PROJECT_CLOSED");
        SubtitleEditView.makeButton(parent, "IMG_OBJS_BKMRK_TSK");
        SubtitleEditView.makeButton(parent, "IMG_OPEN_MARKER");
        SubtitleEditView.makeButton(parent, "IMG_OBJS_TASK_TSK");
        SubtitleEditView.makeButton(parent, "IMG_DEF_VIEW");
        SubtitleEditView.makeButton(parent, "IMG_OBJ_ELEMENTS");
        SubtitleEditView.makeButton(parent, "IMG_OBJ_FILE");
        SubtitleEditView.makeButton(parent, "IMG_OBJ_FOLDER");
        SubtitleEditView.makeButton(parent, "IMG_OBJS_ERROR_TSK");
        SubtitleEditView.makeButton(parent, "IMG_OBJS_INFO_TSK");
        SubtitleEditView.makeButton(parent, "IMG_OBJS_WARN_TSK");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_BACK");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_BACK_DISABLED");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_COPY");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_COPY_DISABLED");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_CUT");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_CUT_DISABLED");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_DELETE");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_DELETE_DISABLED");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_FORWARD");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_FORWARD_DISABLED");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_NEW_WIZARD");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_NEW_WIZARD_DISABLED");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_PASTE");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_PASTE_DISABLED");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_REDO");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_REDO_DISABLED");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_UNDO");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_UNDO_DISABLED");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_UP");
        SubtitleEditView.makeButton(parent, "IMG_TOOL_UP_DISABLED");
    }

    protected void startPaint() {
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < 300) {
            Image image = SubtitleEditView.getImage(i);
            this.gc.drawImage(image, 0, 0);
            image.dispose();
            ++i;
        }
        long end = System.currentTimeMillis();
        double sec = ((double)end - (double)start) / 1000.0;
        log.info((Object)(String.valueOf(sec) + " sec"));
    }

    private static Image getImage(int i) {
        return new Image(null, "c:\\tmp\\imagegrey\\stream" + SubtitleEditView.toDigits(i) + ".jpg");
    }

    public static String toDigits(int value) {
        String result = "" + value;
        while (result.length() < 5) {
            result = "0" + result;
        }
        return result;
    }

    public void setFocus() {
    }

    public class StartPaint
    extends Thread {
        public void run() {
            SubtitleEditView.this.startPaint();
        }
    }

    public class ThreadPaint
    extends Thread {
        public void run() {
            SubtitleEditView.this.startPaint();
        }
    }
}

