/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui.draw2d;

import jp.sourceforge.akjrcp.ui.draw2d.ChainedFigure;
import jp.sourceforge.akjrcp.ui.draw2d.DoubleScalableFigure;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;

public class ChainedFlowFigure
extends DoubleScalableFigure {
    public static Log log = LogFactory.getLog(ChainedFlowFigure.class);
    private ChainedFigure lastFigure;
    private FlowLayout flowLayout = new FlowLayout(true);

    public ChainedFlowFigure() {
        super(256, 256);
        this.flowLayout.setMajorSpacing(0);
        this.flowLayout.setMinorSpacing(0);
        this.setLayoutManager((LayoutManager)this.flowLayout);
    }

    public void addChainedFigure(ChainedFigure figure) {
        figure.setFigure(this.lastFigure);
        this.lastFigure = figure;
        this.add(figure);
        this.resize();
    }

    public void resize() {
        int maxheight = 0;
        int width = 0;
        for (Figure f : this.getChildren()) {
            width += f.getSize().width;
            maxheight = Math.max(maxheight, f.getSize().height);
        }
        this.setSize(width, maxheight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScale(double wzoom, double vzoom) {
        this.hzoom = vzoom;
        this.wzoom = wzoom;
        this.getChildren();
        ChainedFlowFigure chainedFlowFigure = this;
        synchronized (chainedFlowFigure) {
            DoubleScalableFigure[] figures = this.getChildren().toArray(new DoubleScalableFigure[this.getChildren().size()]);
            int i = 0;
            while (i < figures.length) {
                figures[i].setScale(wzoom, vzoom);
                ++i;
            }
            this.getLayoutManager().layout((IFigure)this);
            this.revalidate();
        }
    }

    public void paintFigure(Graphics g) {
    }
}

