/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.terrain.util;

import com.jme.system.JmeException;
import com.jmex.terrain.util.AbstractHeightMap;
import java.util.Random;
import java.util.logging.Logger;

public class HillHeightMap
extends AbstractHeightMap {
    private static final Logger logger = Logger.getLogger(HillHeightMap.class.getName());
    private int iterations;
    private float minRadius;
    private float maxRadius;
    private byte flattening;
    private long seed;

    public HillHeightMap(int n, int n2, float f, float f2, byte by, long l) {
        if (n <= 0 || n2 <= 0 || f <= 0.0f || f2 <= 0.0f || f >= f2 || by < 1) {
            throw new JmeException("Either size of the terrain is not greater that zero, or number of iterations is not greater that zero, or minimum or maximum radius are not greater than zero, or minimum radius is greater than maximum radius, or power of flattening is below one");
        }
        this.size = n;
        this.seed = l;
        this.iterations = n2;
        this.minRadius = f;
        this.maxRadius = f2;
        this.flattening = by;
        this.load();
    }

    public HillHeightMap(int n, int n2, float f, float f2, byte by) {
        this(n, n2, f, f2, by, new Random().nextLong());
    }

    public boolean load() {
        int n;
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        this.heightData = new int[this.size * this.size];
        float[][] fArray = new float[this.size][this.size];
        Random random = new Random(this.seed);
        for (n = 0; n < this.iterations; ++n) {
            this.addHill(fArray, random);
        }
        this.normalize(fArray);
        this.flatten(fArray);
        this.normalizeTerrain(fArray);
        for (n = 0; n < this.size; ++n) {
            for (int i = 0; i < this.size; ++i) {
                this.setHeightAtPoint((int)fArray[n][i], i, n);
            }
        }
        logger.info("Created Heightmap using the Hill Algorithm");
        return true;
    }

    protected void addHill(float[][] fArray, Random random) {
        float f = this.randomRange(random, this.minRadius, this.maxRadius);
        float f2 = this.randomRange(random, -f, (float)this.size + f);
        float f3 = this.randomRange(random, -f, (float)this.size + f);
        float f4 = f * f;
        int n = Math.round(f2 - f - 1.0f);
        int n2 = Math.round(f2 + f + 1.0f);
        int n3 = Math.round(f3 - f - 1.0f);
        int n4 = Math.round(f3 + f + 1.0f);
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.size) {
            n2 = this.size - 1;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 > this.size) {
            n4 = this.size - 1;
        }
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                float f5 = (f2 - (float)i) * (f2 - (float)i) + (f3 - (float)j) * (f3 - (float)j);
                float f6 = f4 - f5;
                if (!(f6 > 0.0f)) continue;
                float[] fArray2 = fArray[i];
                int n5 = j;
                fArray2[n5] = fArray2[n5] + f6;
            }
        }
    }

    protected void normalize(float[][] fArray) {
        int n;
        int n2;
        float f;
        float f2 = f = fArray[0][0];
        for (n2 = 0; n2 < this.size; ++n2) {
            for (n = 0; n < this.size; ++n) {
                float f3 = fArray[n2][n];
                if (f3 < f) {
                    f = f3;
                }
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
        }
        if (f2 != f) {
            for (n2 = 0; n2 < this.size; ++n2) {
                for (n = 0; n < this.size; ++n) {
                    fArray[n2][n] = (fArray[n2][n] - f) / (f2 - f);
                }
            }
        }
    }

    protected void flatten(float[][] fArray) {
        if (this.flattening > 1) {
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    float f = 1.0f;
                    float f2 = fArray[i][j];
                    for (int k = 0; k < this.flattening; ++k) {
                        f *= f2;
                    }
                    fArray[i][j] = f;
                }
            }
        }
    }

    private float randomRange(Random random, float f, float f2) {
        return (float)random.nextInt() * (f2 - f) / 2.1474836E9f + f;
    }

    public void setIterations(int n) {
        if (n <= 0) {
            throw new JmeException("Number of iterations is not greater than zero");
        }
        this.iterations = n;
    }

    public void setFlattening(byte by) {
        if (by < 1) {
            throw new JmeException("Power is below one");
        }
        this.flattening = by;
    }

    public void setMaxRadius(float f) {
        if (f <= 0.0f || f <= this.minRadius) {
            throw new JmeException("The maximum radius is not greater than 0, or not greater than the minimum radius");
        }
        this.maxRadius = f;
    }

    public void setMinRadius(float f) {
        if (f <= 0.0f || f >= this.maxRadius) {
            throw new JmeException("The minimum radius is not greater than 0, or not lower than the maximum radius");
        }
        this.minRadius = f;
    }
}

