/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.terrain.util;

import com.jme.util.TextureManager;
import com.jmex.terrain.util.AbstractHeightMap;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;

public class ImageBasedHeightMap
extends AbstractHeightMap {
    public ImageBasedHeightMap(Image image) {
        BufferedImage bufferedImage = ImageConverter.toBufferedImage(image, 5);
        boolean bl = TextureManager.hasAlpha((Image)bufferedImage);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (n != n2) {
            throw new RuntimeException("imageWidth: " + n + " != imageHeight: " + n2);
        }
        this.size = n;
        byte[] byArray = (byte[])bufferedImage.getRaster().getDataElements(0, 0, n, n2, null);
        int n3 = 3;
        int n4 = 0;
        if (bl) {
            n3 = 4;
            n4 = 1;
        }
        this.heightData = new int[n * n2];
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n6 = i * n * n3 + j * n3 + n4;
                int n7 = byArray[n6] >= 0 ? byArray[n6] : 256 + byArray[n6];
                int n8 = byArray[n6 + 1] >= 0 ? byArray[n6 + 1] : 256 + byArray[n6 + 1];
                int n9 = byArray[n6 + 2] >= 0 ? byArray[n6 + 2] : 256 + byArray[n6 + 2];
                int n10 = (int)(0.299 * (double)n9 + 0.587 * (double)n8 + 0.114 * (double)n7);
                this.heightData[n5++] = n10;
            }
        }
    }

    public boolean load() {
        return true;
    }

    private static class ImageConverter {
        private ImageConverter() {
        }

        public static BufferedImage toBufferedImage(Image image) {
            if (image instanceof BufferedImage) {
                return (BufferedImage)image;
            }
            ColorModel colorModel = ImageConverter.getColorModel(image);
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            return ImageConverter.copy(ImageConverter.createBufferedImage(colorModel, n, n2), image);
        }

        public static BufferedImage toBufferedImage(Image image, int n) {
            if (image instanceof BufferedImage && ((BufferedImage)image).getType() == n) {
                return (BufferedImage)image;
            }
            int n2 = image.getWidth(null);
            int n3 = image.getHeight(null);
            return ImageConverter.copy(new BufferedImage(n2, n3, n), image);
        }

        public static BufferedImage copy(BufferedImage bufferedImage, Image image) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            return bufferedImage;
        }

        public static ColorModel getColorModel(Image image) {
            try {
                PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
                pixelGrabber.grabPixels();
                return pixelGrabber.getColorModel();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Unexpected interruption", interruptedException);
            }
        }

        public static BufferedImage createBufferedImage(ColorModel colorModel, int n, int n2) {
            WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
            boolean bl = colorModel.isAlphaPremultiplied();
            return new BufferedImage(colorModel, writableRaster, bl, null);
        }
    }
}

