/*
 * Decompiled with CFR 0.152.
 */
package com.jme.curve;

import com.jme.curve.Curve;
import com.jme.intersection.CollisionResults;
import com.jme.intersection.PickResults;
import com.jme.math.Matrix3f;
import com.jme.math.Ray;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.util.geom.BufferUtils;

public class BezierCurve
extends Curve {
    private static final long serialVersionUID = 1L;
    private static Vector3f tempVect = new Vector3f();

    public BezierCurve(String string) {
        super(string);
    }

    public BezierCurve(String string, Vector3f[] vector3fArray) {
        super(string, vector3fArray);
    }

    public Vector3f getPoint(float f, Vector3f vector3f) {
        if (f < 0.0f) {
            BufferUtils.populateFromBuffer(vector3f, this.getBatch(0).getVertexBuffer(), 0);
            return vector3f;
        }
        if (f > 1.0f) {
            BufferUtils.populateFromBuffer(vector3f, this.getBatch(0).getVertexBuffer(), this.getBatch(0).getVertexCount() - 1);
            return vector3f;
        }
        float f2 = 1.0f;
        float f3 = (float)Math.pow(1.0f - f, this.getBatch(0).getVertexCount() - 1);
        vector3f.zero();
        for (int i = 0; i < this.getBatch(0).getVertexCount(); ++i) {
            int n = this.getBatch(0).getVertexCount() - 1;
            int n2 = i;
            int n3 = n - n2;
            float f4 = f2 * f3;
            f2 *= f;
            f3 /= 1.0f - f;
            while (n >= 1) {
                f4 *= (float)n;
                --n;
                if (n2 > 1) {
                    f4 /= (float)n2;
                    --n2;
                }
                if (n3 <= 1) continue;
                f4 /= (float)n3;
                --n3;
            }
            BufferUtils.populateFromBuffer(tempVect, this.getBatch(0).getVertexBuffer(), i);
            vector3f.x += BezierCurve.tempVect.x * f4;
            vector3f.y += BezierCurve.tempVect.y * f4;
            vector3f.z += BezierCurve.tempVect.z * f4;
        }
        return vector3f;
    }

    public Vector3f getPoint(float f) {
        return this.getPoint(f, new Vector3f());
    }

    public Matrix3f getOrientation(float f, float f2) {
        Matrix3f matrix3f = new Matrix3f();
        Vector3f vector3f = this.getPoint(f);
        Vector3f vector3f2 = vector3f.subtract(this.getPoint(f + f2));
        vector3f2 = vector3f2.normalize();
        Vector3f vector3f3 = this.getPoint(f - f2).subtract(vector3f);
        Vector3f vector3f4 = vector3f2.cross(vector3f3);
        vector3f4 = vector3f4.normalize();
        Vector3f vector3f5 = vector3f2.cross(vector3f4);
        vector3f5 = vector3f5.normalize();
        matrix3f.setColumn(0, vector3f2);
        matrix3f.setColumn(1, vector3f4);
        matrix3f.setColumn(2, vector3f5);
        return matrix3f;
    }

    public Matrix3f getOrientation(float f, float f2, Vector3f vector3f) {
        if (vector3f == null) {
            return this.getOrientation(f, f2);
        }
        Matrix3f matrix3f = new Matrix3f();
        Vector3f vector3f2 = this.getPoint(f).subtract(this.getPoint(f + f2));
        vector3f2 = vector3f2.normalize();
        Vector3f vector3f3 = vector3f2.cross(vector3f);
        vector3f3 = vector3f3.normalize();
        Vector3f vector3f4 = vector3f3.cross(vector3f2);
        vector3f4 = vector3f4.normalize();
        matrix3f.setColumn(0, vector3f2);
        matrix3f.setColumn(1, vector3f4);
        matrix3f.setColumn(2, vector3f3);
        return matrix3f;
    }

    public void findCollisions(Spatial spatial, CollisionResults collisionResults) {
    }

    public boolean hasCollision(Spatial spatial, boolean bl) {
        return false;
    }

    public void findPick(Ray ray, PickResults pickResults) {
    }
}

