/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.mouse;

import com.jme.input.ActionTrigger;
import com.jme.input.MouseInput;
import com.jme.input.MouseInputListener;
import com.jme.input.mouse.MouseInputHandlerDevice;
import com.jme.system.DisplaySystem;
import java.util.ArrayList;

class TriggersMouseInputListener
implements MouseInputListener {
    private float maxWheel = 120.0f;
    public static final boolean DO_CLAMP = false;
    private ArrayList<MouseInputHandlerDevice.MouseButtonTrigger> buttonTriggers = new ArrayList();
    private ArrayList<MouseInputHandlerDevice.MouseAxisTrigger> axisTriggers = new ArrayList();

    public void activate() {
        MouseInput.get().addListener(this);
    }

    public boolean isActivated() {
        return MouseInput.get().containsListener(this);
    }

    public void deactivate() {
        MouseInput.get().removeListener(this);
    }

    public void onButton(int n, boolean bl, int n2, int n3) {
        for (int i = this.buttonTriggers.size() - 1; i >= 0; --i) {
            ActionTrigger actionTrigger = this.buttonTriggers.get(i);
            actionTrigger.checkActivation('\u0000', n, Float.NaN, Float.NaN, bl, null);
        }
    }

    public void onWheel(int n, int n2, int n3) {
        float f = TriggersMouseInputListener.clamp((float)MouseInput.get().getWheelRotation() / this.maxWheel);
        float f2 = TriggersMouseInputListener.clamp((float)n / this.maxWheel);
        for (int i = this.axisTriggers.size() - 1; i >= 0; --i) {
            ActionTrigger actionTrigger = this.axisTriggers.get(i);
            actionTrigger.checkActivation('\u0000', 2, f, f2, false, null);
        }
    }

    public void onMove(int n, int n2, int n3, int n4) {
        float f = TriggersMouseInputListener.clamp((float)n3 / (float)DisplaySystem.getDisplaySystem().getWidth());
        float f2 = TriggersMouseInputListener.clamp((float)n4 / (float)DisplaySystem.getDisplaySystem().getHeight());
        float f3 = TriggersMouseInputListener.clamp((float)n / (float)DisplaySystem.getDisplaySystem().getWidth());
        float f4 = TriggersMouseInputListener.clamp((float)n2 / (float)DisplaySystem.getDisplaySystem().getHeight());
        for (int i = this.axisTriggers.size() - 1; i >= 0; --i) {
            ActionTrigger actionTrigger = this.axisTriggers.get(i);
            if (n != 0) {
                actionTrigger.checkActivation('\u0000', 0, f, f3, false, null);
            }
            if (n2 == 0) continue;
            actionTrigger.checkActivation('\u0000', 1, f2, f4, false, null);
        }
    }

    void add(MouseInputHandlerDevice.MouseButtonTrigger mouseButtonTrigger) {
        this.buttonTriggers.add(mouseButtonTrigger);
    }

    void remove(MouseInputHandlerDevice.MouseButtonTrigger mouseButtonTrigger) {
        this.buttonTriggers.remove(mouseButtonTrigger);
    }

    void add(MouseInputHandlerDevice.MouseAxisTrigger mouseAxisTrigger) {
        this.axisTriggers.add(mouseAxisTrigger);
    }

    void remove(MouseInputHandlerDevice.MouseAxisTrigger mouseAxisTrigger) {
        this.axisTriggers.remove(mouseAxisTrigger);
    }

    private static float clamp(float f) {
        return f;
    }
}

