/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math;

import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;

public class Ring
implements Serializable,
Savable {
    private static final long serialVersionUID = 1L;
    private Vector3f center;
    private Vector3f up;
    private float innerRadius;
    private float outerRadius;
    private static transient Vector3f b1 = new Vector3f();
    private static transient Vector3f b2 = new Vector3f();

    public Ring() {
        this.center = new Vector3f();
        this.up = Vector3f.UNIT_Y.clone();
        this.innerRadius = 0.0f;
        this.outerRadius = 1.0f;
    }

    public Ring(Vector3f vector3f, Vector3f vector3f2, float f, float f2) {
        this.center = vector3f;
        this.up = vector3f2;
        this.innerRadius = f;
        this.outerRadius = f2;
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public void setCenter(Vector3f vector3f) {
        this.center = vector3f;
    }

    public Vector3f getUp() {
        return this.up;
    }

    public void setUp(Vector3f vector3f) {
        this.up = vector3f;
    }

    public float getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(float f) {
        this.innerRadius = f;
    }

    public float getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(float f) {
        this.outerRadius = f;
    }

    public Vector3f random() {
        return this.random(null);
    }

    public Vector3f random(Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        float f = this.innerRadius * this.innerRadius;
        float f2 = this.outerRadius * this.outerRadius;
        float f3 = FastMath.sqrt(f + FastMath.nextRandomFloat() * (f2 - f));
        float f4 = FastMath.nextRandomFloat() * ((float)Math.PI * 2);
        this.up.cross(Vector3f.UNIT_X, b1);
        if (b1.lengthSquared() < 1.1920929E-7f) {
            this.up.cross(Vector3f.UNIT_Y, b1);
        }
        b1.normalizeLocal();
        this.up.cross(b1, b2);
        vector3f.set(b1).multLocal(f3 * FastMath.cos(f4)).addLocal(this.center);
        vector3f.scaleAdd(f3 * FastMath.sin(f4), b2, vector3f);
        return vector3f;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.center, "center", Vector3f.ZERO);
        outputCapsule.write(this.up, "up", Vector3f.UNIT_Z);
        outputCapsule.write(this.innerRadius, "innerRadius", 0.0f);
        outputCapsule.write(this.outerRadius, "outerRadius", 1.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.center = (Vector3f)inputCapsule.readSavable("center", Vector3f.ZERO.clone());
        this.up = (Vector3f)inputCapsule.readSavable("up", Vector3f.UNIT_Z.clone());
        this.innerRadius = inputCapsule.readFloat("innerRadius", 0.0f);
        this.outerRadius = inputCapsule.readFloat("outerRadius", 1.0f);
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

