/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math;

import com.jme.math.FastMath;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Logger;

public class Vector3f
implements Externalizable,
Savable {
    private static final Logger logger = Logger.getLogger(Vector3f.class.getName());
    private static final long serialVersionUID = 1L;
    public static final Vector3f ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f UNIT_X = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f UNIT_Y = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f UNIT_Z = new Vector3f(0.0f, 0.0f, 1.0f);
    public static final Vector3f UNIT_XYZ = new Vector3f(1.0f, 1.0f, 1.0f);
    public float x;
    public float y;
    public float z;

    public Vector3f() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vector3f(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public Vector3f(Vector3f vector3f) {
        this.set(vector3f);
    }

    public Vector3f set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        return this;
    }

    public Vector3f set(Vector3f vector3f) {
        this.x = vector3f.x;
        this.y = vector3f.y;
        this.z = vector3f.z;
        return this;
    }

    public Vector3f add(Vector3f vector3f) {
        if (null == vector3f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        return new Vector3f(this.x + vector3f.x, this.y + vector3f.y, this.z + vector3f.z);
    }

    public Vector3f add(Vector3f vector3f, Vector3f vector3f2) {
        vector3f2.x = this.x + vector3f.x;
        vector3f2.y = this.y + vector3f.y;
        vector3f2.z = this.z + vector3f.z;
        return vector3f2;
    }

    public Vector3f addLocal(Vector3f vector3f) {
        if (null == vector3f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x += vector3f.x;
        this.y += vector3f.y;
        this.z += vector3f.z;
        return this;
    }

    public Vector3f add(float f, float f2, float f3) {
        return new Vector3f(this.x + f, this.y + f2, this.z + f3);
    }

    public Vector3f addLocal(float f, float f2, float f3) {
        this.x += f;
        this.y += f2;
        this.z += f3;
        return this;
    }

    public void scaleAdd(float f, Vector3f vector3f) {
        this.x = this.x * f + vector3f.x;
        this.y = this.y * f + vector3f.y;
        this.z = this.z * f + vector3f.z;
    }

    public void scaleAdd(float f, Vector3f vector3f, Vector3f vector3f2) {
        this.x = vector3f.x * f + vector3f2.x;
        this.y = vector3f.y * f + vector3f2.y;
        this.z = vector3f.z * f + vector3f2.z;
    }

    public float dot(Vector3f vector3f) {
        if (null == vector3f) {
            logger.warning("Provided vector is null, 0 returned.");
            return 0.0f;
        }
        return this.x * vector3f.x + this.y * vector3f.y + this.z * vector3f.z;
    }

    public Vector3f cross(Vector3f vector3f) {
        return this.cross(vector3f, null);
    }

    public Vector3f cross(Vector3f vector3f, Vector3f vector3f2) {
        return this.cross(vector3f.x, vector3f.y, vector3f.z, vector3f2);
    }

    public Vector3f cross(float f, float f2, float f3, Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        float f4 = this.y * f3 - this.z * f2;
        float f5 = this.z * f - this.x * f3;
        float f6 = this.x * f2 - this.y * f;
        vector3f.set(f4, f5, f6);
        return vector3f;
    }

    public Vector3f crossLocal(Vector3f vector3f) {
        return this.crossLocal(vector3f.x, vector3f.y, vector3f.z);
    }

    public Vector3f crossLocal(float f, float f2, float f3) {
        float f4 = this.y * f3 - this.z * f2;
        float f5 = this.z * f - this.x * f3;
        this.z = this.x * f2 - this.y * f;
        this.x = f4;
        this.y = f5;
        return this;
    }

    public float length() {
        return FastMath.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float distanceSquared(Vector3f vector3f) {
        double d = this.x - vector3f.x;
        double d2 = this.y - vector3f.y;
        double d3 = this.z - vector3f.z;
        return (float)(d * d + d2 * d2 + d3 * d3);
    }

    public float distance(Vector3f vector3f) {
        return FastMath.sqrt(this.distanceSquared(vector3f));
    }

    public Vector3f mult(float f) {
        return new Vector3f(this.x * f, this.y * f, this.z * f);
    }

    public Vector3f mult(float f, Vector3f vector3f) {
        if (null == vector3f) {
            vector3f = new Vector3f();
        }
        vector3f.x = this.x * f;
        vector3f.y = this.y * f;
        vector3f.z = this.z * f;
        return vector3f;
    }

    public Vector3f multLocal(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    public Vector3f multLocal(Vector3f vector3f) {
        if (null == vector3f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x *= vector3f.x;
        this.y *= vector3f.y;
        this.z *= vector3f.z;
        return this;
    }

    public Vector3f mult(Vector3f vector3f) {
        if (null == vector3f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        return this.mult(vector3f, null);
    }

    public Vector3f mult(Vector3f vector3f, Vector3f vector3f2) {
        if (null == vector3f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        if (vector3f2 == null) {
            vector3f2 = new Vector3f();
        }
        return vector3f2.set(this.x * vector3f.x, this.y * vector3f.y, this.z * vector3f.z);
    }

    public Vector3f divide(float f) {
        f = 1.0f / f;
        return new Vector3f(this.x * f, this.y * f, this.z * f);
    }

    public Vector3f divideLocal(float f) {
        f = 1.0f / f;
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    public Vector3f divide(Vector3f vector3f) {
        return new Vector3f(this.x / vector3f.x, this.y / vector3f.y, this.z / vector3f.z);
    }

    public Vector3f divideLocal(Vector3f vector3f) {
        this.x /= vector3f.x;
        this.y /= vector3f.y;
        this.z /= vector3f.z;
        return this;
    }

    public Vector3f negate() {
        return new Vector3f(-this.x, -this.y, -this.z);
    }

    public Vector3f negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3f subtract(Vector3f vector3f) {
        return new Vector3f(this.x - vector3f.x, this.y - vector3f.y, this.z - vector3f.z);
    }

    public Vector3f subtractLocal(Vector3f vector3f) {
        if (null == vector3f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x -= vector3f.x;
        this.y -= vector3f.y;
        this.z -= vector3f.z;
        return this;
    }

    public Vector3f subtract(Vector3f vector3f, Vector3f vector3f2) {
        if (vector3f2 == null) {
            vector3f2 = new Vector3f();
        }
        vector3f2.x = this.x - vector3f.x;
        vector3f2.y = this.y - vector3f.y;
        vector3f2.z = this.z - vector3f.z;
        return vector3f2;
    }

    public Vector3f subtract(float f, float f2, float f3) {
        return new Vector3f(this.x - f, this.y - f2, this.z - f3);
    }

    public Vector3f subtractLocal(float f, float f2, float f3) {
        this.x -= f;
        this.y -= f2;
        this.z -= f3;
        return this;
    }

    public Vector3f normalize() {
        float f = this.length();
        if (f != 0.0f) {
            return this.divide(f);
        }
        return this.divide(1.0f);
    }

    public Vector3f normalizeLocal() {
        float f = this.length();
        if (f != 0.0f) {
            return this.divideLocal(f);
        }
        return this;
    }

    public void zero() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public float angleBetween(Vector3f vector3f) {
        float f = this.dot(vector3f);
        float f2 = FastMath.acos(f);
        return f2;
    }

    public void interpolate(Vector3f vector3f, float f) {
        this.x = (1.0f - f) * this.x + f * vector3f.x;
        this.y = (1.0f - f) * this.y + f * vector3f.y;
        this.z = (1.0f - f) * this.z + f * vector3f.z;
    }

    public void interpolate(Vector3f vector3f, Vector3f vector3f2, float f) {
        this.x = (1.0f - f) * vector3f.x + f * vector3f2.x;
        this.y = (1.0f - f) * vector3f.y + f * vector3f2.y;
        this.z = (1.0f - f) * vector3f.z + f * vector3f2.z;
    }

    public static boolean isValidVector(Vector3f vector3f) {
        if (vector3f == null) {
            return false;
        }
        if (Float.isNaN(vector3f.x) || Float.isNaN(vector3f.y) || Float.isNaN(vector3f.z)) {
            return false;
        }
        return !Float.isInfinite(vector3f.x) && !Float.isInfinite(vector3f.y) && !Float.isInfinite(vector3f.z);
    }

    public static void generateOrthonormalBasis(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        vector3f3.normalizeLocal();
        Vector3f.generateComplementBasis(vector3f, vector3f2, vector3f3);
    }

    public static void generateComplementBasis(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        if (FastMath.abs(vector3f3.x) >= FastMath.abs(vector3f3.y)) {
            float f = FastMath.invSqrt(vector3f3.x * vector3f3.x + vector3f3.z * vector3f3.z);
            vector3f.x = -vector3f3.z * f;
            vector3f.y = 0.0f;
            vector3f.z = vector3f3.x * f;
            vector3f2.x = vector3f3.y * vector3f.z;
            vector3f2.y = vector3f3.z * vector3f.x - vector3f3.x * vector3f.z;
            vector3f2.z = -vector3f3.y * vector3f.x;
        } else {
            float f = FastMath.invSqrt(vector3f3.y * vector3f3.y + vector3f3.z * vector3f3.z);
            vector3f.x = 0.0f;
            vector3f.y = vector3f3.z * f;
            vector3f.z = -vector3f3.y * f;
            vector3f2.x = vector3f3.y * vector3f.z - vector3f3.z * vector3f.y;
            vector3f2.y = -vector3f3.x * vector3f.z;
            vector3f2.z = vector3f3.x * vector3f.y;
        }
    }

    public Vector3f clone() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public float[] toArray(float[] fArray) {
        fArray[0] = this.x;
        fArray[1] = this.y;
        fArray[2] = this.z;
        return fArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Vector3f)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Vector3f vector3f = (Vector3f)object;
        if (Float.compare(this.x, vector3f.x) != 0) {
            return false;
        }
        if (Float.compare(this.y, vector3f.y) != 0) {
            return false;
        }
        return Float.compare(this.z, vector3f.z) == 0;
    }

    public int hashCode() {
        int n = 37;
        n += 37 * n + Float.floatToIntBits(this.x);
        n += 37 * n + Float.floatToIntBits(this.y);
        n += 37 * n + Float.floatToIntBits(this.z);
        return n;
    }

    public String toString() {
        return "com.jme.math.Vector3f [X=" + this.x + ", Y=" + this.y + ", Z=" + this.z + "]";
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readFloat();
        this.y = objectInput.readFloat();
        this.z = objectInput.readFloat();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.x);
        objectOutput.writeFloat(this.y);
        objectOutput.writeFloat(this.z);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.x, "x", 0.0f);
        outputCapsule.write(this.y, "y", 0.0f);
        outputCapsule.write(this.z, "z", 0.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.x = inputCapsule.readFloat("x", 0.0f);
        this.y = inputCapsule.readFloat("y", 0.0f);
        this.z = inputCapsule.readFloat("z", 0.0f);
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
    }

    public float getZ() {
        return this.z;
    }

    public void setZ(float f) {
        this.z = f;
    }

    public float get(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException("index must be either 0, 1 or 2");
    }

    public void set(int n, float f) {
        switch (n) {
            case 0: {
                this.x = f;
                return;
            }
            case 1: {
                this.y = f;
                return;
            }
            case 2: {
                this.z = f;
                return;
            }
        }
        throw new IllegalArgumentException("index must be either 0, 1 or 2");
    }
}

