/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;

public class VBOInfo
implements Serializable,
Savable {
    private static final long serialVersionUID = 1L;
    private boolean useVBOVertex = false;
    private boolean useVBOTexture = false;
    private boolean useVBOColor = false;
    private boolean useVBONormal = false;
    private boolean useVBOIndex = false;
    private int vboVertexID = -1;
    private int vboColorID = -1;
    private int vboNormalID = -1;
    private int[] vboTextureIDs = null;
    private int vboIndexID = -1;

    public VBOInfo() {
        this(false);
    }

    public VBOInfo(boolean bl) {
        this.useVBOColor = bl;
        this.useVBOTexture = bl;
        this.useVBOVertex = bl;
        this.useVBONormal = bl;
        this.useVBOIndex = false;
        this.vboTextureIDs = new int[2];
    }

    public VBOInfo copy() {
        VBOInfo vBOInfo = new VBOInfo();
        vBOInfo.useVBOVertex = this.useVBOVertex;
        vBOInfo.useVBOTexture = this.useVBOTexture;
        vBOInfo.useVBOColor = this.useVBOColor;
        vBOInfo.useVBONormal = this.useVBONormal;
        vBOInfo.useVBOIndex = this.useVBOIndex;
        return vBOInfo;
    }

    public void resizeTextureIds(int n) {
        if (this.vboTextureIDs.length == n || n == 0) {
            return;
        }
        int[] nArray = new int[n];
        int n2 = Math.min(n, this.vboTextureIDs.length);
        while (--n2 >= 0) {
            nArray[n2] = this.vboTextureIDs[n2];
        }
        this.vboTextureIDs = nArray;
    }

    public boolean isVBOVertexEnabled() {
        return this.useVBOVertex;
    }

    public boolean isVBOIndexEnabled() {
        return this.useVBOIndex;
    }

    public boolean isVBOTextureEnabled() {
        return this.useVBOTexture;
    }

    public boolean isVBONormalEnabled() {
        return this.useVBONormal;
    }

    public boolean isVBOColorEnabled() {
        return this.useVBOColor;
    }

    public void setVBOVertexEnabled(boolean bl) {
        this.useVBOVertex = bl;
    }

    public void setVBOIndexEnabled(boolean bl) {
        this.useVBOIndex = bl;
    }

    public void setVBOTextureEnabled(boolean bl) {
        this.useVBOTexture = bl;
    }

    public void setVBONormalEnabled(boolean bl) {
        this.useVBONormal = bl;
    }

    public void setVBOColorEnabled(boolean bl) {
        this.useVBOColor = bl;
    }

    public int getVBOVertexID() {
        return this.vboVertexID;
    }

    public int getVBOTextureID(int n) {
        if (n >= this.vboTextureIDs.length) {
            return -1;
        }
        return this.vboTextureIDs[n];
    }

    public int getVBONormalID() {
        return this.vboNormalID;
    }

    public int getVBOColorID() {
        return this.vboColorID;
    }

    public void setVBOVertexID(int n) {
        this.vboVertexID = n;
    }

    public void setVBOTextureID(int n, int n2) {
        this.vboTextureIDs[n] = n2;
    }

    public void setVBONormalID(int n) {
        this.vboNormalID = n;
    }

    public void setVBOColorID(int n) {
        this.vboColorID = n;
    }

    public int getVBOIndexID() {
        return this.vboIndexID;
    }

    public void setVBOIndexID(int n) {
        this.vboIndexID = n;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.useVBOVertex, "useVBOVertex", false);
        outputCapsule.write(this.useVBOTexture, "useVBOTexture", false);
        outputCapsule.write(this.useVBOColor, "useVBOColor", false);
        outputCapsule.write(this.useVBONormal, "useVBONormal", false);
        outputCapsule.write(this.useVBOIndex, "useVBOIndex", false);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.useVBOVertex = inputCapsule.readBoolean("useVBOVertex", false);
        this.useVBOTexture = inputCapsule.readBoolean("useVBOTexture", false);
        this.useVBOColor = inputCapsule.readBoolean("useVBOColor", false);
        this.useVBONormal = inputCapsule.readBoolean("useVBONormal", false);
        this.useVBOIndex = inputCapsule.readBoolean("useVBOIndex", false);
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

