/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.geometryinstancing.instance;

import com.jme.math.Matrix4f;
import com.jme.math.Vector3f;

public class GeometryInstanceAttributes {
    protected Vector3f scale;
    protected Vector3f rotation;
    protected Vector3f translation;
    protected Matrix4f mtNormal;
    protected Matrix4f mtWorld;
    private Vector3f rotationDegrees = new Vector3f();

    public GeometryInstanceAttributes(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        this.scale = vector3f2;
        this.rotation = vector3f3;
        this.translation = vector3f;
        this.mtWorld = new Matrix4f();
        this.mtNormal = new Matrix4f();
        this.buildMatrices();
    }

    public void buildMatrices() {
        this.mtWorld.loadIdentity();
        this.mtWorld.m00 = this.scale.x;
        this.mtWorld.m11 = this.scale.y;
        this.mtWorld.m22 = this.scale.z;
        this.rotationDegrees.set(this.rotation).multLocal(57.295776f);
        this.mtNormal.loadIdentity();
        this.mtNormal.angleRotation(this.rotationDegrees);
        this.mtNormal.multLocal(this.mtWorld);
        this.mtWorld.set(this.mtNormal);
        this.mtWorld.setTranslation(this.translation);
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public void setScale(Vector3f vector3f) {
        this.scale = vector3f;
    }

    public Vector3f getTranslation() {
        return this.translation;
    }

    public void setTranslation(Vector3f vector3f) {
        this.translation = vector3f;
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public void setRotation(Vector3f vector3f) {
        this.rotation = vector3f;
    }

    public Matrix4f getWorldMatrix() {
        return this.mtWorld;
    }

    public Matrix4f getNormalMatrix() {
        return this.mtNormal;
    }
}

