/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;

public class OrientedBox
extends TriMesh {
    private static final long serialVersionUID = 1L;
    protected Vector3f center;
    protected Vector3f xAxis = new Vector3f(1.0f, 0.0f, 0.0f);
    protected Vector3f yAxis = new Vector3f(0.0f, 1.0f, 0.0f);
    protected Vector3f zAxis = new Vector3f(0.0f, 0.0f, 1.0f);
    protected Vector3f extent = new Vector3f(0.0f, 0.0f, 0.0f);
    protected Vector2f texTopRight;
    protected Vector2f texTopLeft;
    protected Vector2f texBotRight;
    protected Vector2f texBotLeft;
    public Vector3f[] vectorStore = new Vector3f[8];
    public boolean correctCorners;
    private static final Vector3f tempVa = new Vector3f();
    private static final Vector3f tempVb = new Vector3f();
    private static final Vector3f tempVc = new Vector3f();

    public OrientedBox(String string) {
        super(string);
        for (int i = 0; i < this.vectorStore.length; ++i) {
            this.vectorStore[i] = new Vector3f();
        }
        this.texTopRight = new Vector2f(1.0f, 1.0f);
        this.texTopLeft = new Vector2f(1.0f, 0.0f);
        this.texBotRight = new Vector2f(0.0f, 1.0f);
        this.texBotLeft = new Vector2f(0.0f, 0.0f);
        this.center = new Vector3f(0.0f, 0.0f, 0.0f);
        this.correctCorners = false;
        this.computeInformation();
    }

    public void computeInformation() {
        this.setVertexData();
        this.setNormalData();
        this.setTextureData();
        this.setIndexData();
    }

    private void setIndexData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(triangleBatch.getIndexBuffer(), 36));
        triangleBatch.setTriangleQuantity(12);
        for (int i = 0; i < 6; ++i) {
            triangleBatch.getIndexBuffer().put(i * 4 + 0);
            triangleBatch.getIndexBuffer().put(i * 4 + 1);
            triangleBatch.getIndexBuffer().put(i * 4 + 3);
            triangleBatch.getIndexBuffer().put(i * 4 + 1);
            triangleBatch.getIndexBuffer().put(i * 4 + 2);
            triangleBatch.getIndexBuffer().put(i * 4 + 3);
        }
    }

    private void setTextureData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        if (triangleBatch.getTextureBuffers().get(0) == null) {
            triangleBatch.getTextureBuffers().set(0, BufferUtils.createVector2Buffer(24));
            for (int i = 0; i < 6; ++i) {
                triangleBatch.getTextureBuffers().get(0).put(this.texTopRight.x).put(this.texTopRight.y);
                triangleBatch.getTextureBuffers().get(0).put(this.texTopLeft.x).put(this.texTopLeft.y);
                triangleBatch.getTextureBuffers().get(0).put(this.texBotLeft.x).put(this.texBotLeft.y);
                triangleBatch.getTextureBuffers().get(0).put(this.texBotRight.x).put(this.texBotRight.y);
            }
        }
    }

    private void setNormalData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(triangleBatch.getNormalBuffer(), 24));
        triangleBatch.getNormalBuffer().put(this.yAxis.x).put(this.yAxis.y).put(this.yAxis.z);
        triangleBatch.getNormalBuffer().put(this.yAxis.x).put(this.yAxis.y).put(this.yAxis.z);
        triangleBatch.getNormalBuffer().put(this.yAxis.x).put(this.yAxis.y).put(this.yAxis.z);
        triangleBatch.getNormalBuffer().put(this.yAxis.x).put(this.yAxis.y).put(this.yAxis.z);
        triangleBatch.getNormalBuffer().put(this.xAxis.x).put(this.xAxis.y).put(this.xAxis.z);
        triangleBatch.getNormalBuffer().put(this.xAxis.x).put(this.xAxis.y).put(this.xAxis.z);
        triangleBatch.getNormalBuffer().put(this.xAxis.x).put(this.xAxis.y).put(this.xAxis.z);
        triangleBatch.getNormalBuffer().put(this.xAxis.x).put(this.xAxis.y).put(this.xAxis.z);
        triangleBatch.getNormalBuffer().put(-this.xAxis.x).put(-this.xAxis.y).put(-this.xAxis.z);
        triangleBatch.getNormalBuffer().put(-this.xAxis.x).put(-this.xAxis.y).put(-this.xAxis.z);
        triangleBatch.getNormalBuffer().put(-this.xAxis.x).put(-this.xAxis.y).put(-this.xAxis.z);
        triangleBatch.getNormalBuffer().put(-this.xAxis.x).put(-this.xAxis.y).put(-this.xAxis.z);
        triangleBatch.getNormalBuffer().put(-this.yAxis.x).put(-this.yAxis.y).put(-this.yAxis.z);
        triangleBatch.getNormalBuffer().put(-this.yAxis.x).put(-this.yAxis.y).put(-this.yAxis.z);
        triangleBatch.getNormalBuffer().put(-this.yAxis.x).put(-this.yAxis.y).put(-this.yAxis.z);
        triangleBatch.getNormalBuffer().put(-this.yAxis.x).put(-this.yAxis.y).put(-this.yAxis.z);
        triangleBatch.getNormalBuffer().put(-this.zAxis.x).put(-this.zAxis.y).put(-this.zAxis.z);
        triangleBatch.getNormalBuffer().put(-this.zAxis.x).put(-this.zAxis.y).put(-this.zAxis.z);
        triangleBatch.getNormalBuffer().put(-this.zAxis.x).put(-this.zAxis.y).put(-this.zAxis.z);
        triangleBatch.getNormalBuffer().put(-this.zAxis.x).put(-this.zAxis.y).put(-this.zAxis.z);
        triangleBatch.getNormalBuffer().put(this.zAxis.x).put(this.zAxis.y).put(this.zAxis.z);
        triangleBatch.getNormalBuffer().put(this.zAxis.x).put(this.zAxis.y).put(this.zAxis.z);
        triangleBatch.getNormalBuffer().put(this.zAxis.x).put(this.zAxis.y).put(this.zAxis.z);
        triangleBatch.getNormalBuffer().put(this.zAxis.x).put(this.zAxis.y).put(this.zAxis.z);
    }

    private void setVertexData() {
        this.computeCorners();
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexBuffer(), 24));
        triangleBatch.setVertexCount(24);
        triangleBatch.getVertexBuffer().put(this.vectorStore[0].x).put(this.vectorStore[0].y).put(this.vectorStore[0].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[1].x).put(this.vectorStore[1].y).put(this.vectorStore[1].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[5].x).put(this.vectorStore[5].y).put(this.vectorStore[5].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[3].x).put(this.vectorStore[3].y).put(this.vectorStore[3].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[0].x).put(this.vectorStore[0].y).put(this.vectorStore[0].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[3].x).put(this.vectorStore[3].y).put(this.vectorStore[3].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[6].x).put(this.vectorStore[6].y).put(this.vectorStore[6].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[2].x).put(this.vectorStore[2].y).put(this.vectorStore[2].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[5].x).put(this.vectorStore[5].y).put(this.vectorStore[5].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[1].x).put(this.vectorStore[1].y).put(this.vectorStore[1].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[4].x).put(this.vectorStore[4].y).put(this.vectorStore[4].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[7].x).put(this.vectorStore[7].y).put(this.vectorStore[7].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[6].x).put(this.vectorStore[6].y).put(this.vectorStore[6].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[7].x).put(this.vectorStore[7].y).put(this.vectorStore[7].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[4].x).put(this.vectorStore[4].y).put(this.vectorStore[4].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[2].x).put(this.vectorStore[2].y).put(this.vectorStore[2].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[3].x).put(this.vectorStore[3].y).put(this.vectorStore[3].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[5].x).put(this.vectorStore[5].y).put(this.vectorStore[5].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[7].x).put(this.vectorStore[7].y).put(this.vectorStore[7].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[6].x).put(this.vectorStore[6].y).put(this.vectorStore[6].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[1].x).put(this.vectorStore[1].y).put(this.vectorStore[1].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[4].x).put(this.vectorStore[4].y).put(this.vectorStore[4].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[2].x).put(this.vectorStore[2].y).put(this.vectorStore[2].z);
        triangleBatch.getVertexBuffer().put(this.vectorStore[0].x).put(this.vectorStore[0].y).put(this.vectorStore[0].z);
    }

    public void computeCorners() {
        this.correctCorners = true;
        tempVa.set(this.xAxis).multLocal(this.extent.x);
        tempVb.set(this.yAxis).multLocal(this.extent.y);
        tempVc.set(this.zAxis).multLocal(this.extent.z);
        this.vectorStore[0].set(this.center).addLocal(tempVa).addLocal(tempVb).addLocal(tempVc);
        this.vectorStore[1].set(this.center).addLocal(tempVa).subtractLocal(tempVb).addLocal(tempVc);
        this.vectorStore[2].set(this.center).addLocal(tempVa).addLocal(tempVb).subtractLocal(tempVc);
        this.vectorStore[3].set(this.center).subtractLocal(tempVa).addLocal(tempVb).addLocal(tempVc);
        this.vectorStore[4].set(this.center).addLocal(tempVa).subtractLocal(tempVb).subtractLocal(tempVc);
        this.vectorStore[5].set(this.center).subtractLocal(tempVa).subtractLocal(tempVb).addLocal(tempVc);
        this.vectorStore[6].set(this.center).subtractLocal(tempVa).addLocal(tempVb).subtractLocal(tempVc);
        this.vectorStore[7].set(this.center).subtractLocal(tempVa).subtractLocal(tempVb).subtractLocal(tempVc);
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public void setCenter(Vector3f vector3f) {
        this.center = vector3f;
    }

    public Vector3f getExtent() {
        return this.extent;
    }

    public void setExtent(Vector3f vector3f) {
        this.extent = vector3f;
    }

    public Vector3f getxAxis() {
        return this.xAxis;
    }

    public void setxAxis(Vector3f vector3f) {
        this.xAxis = vector3f;
    }

    public Vector3f getyAxis() {
        return this.yAxis;
    }

    public void setyAxis(Vector3f vector3f) {
        this.yAxis = vector3f;
    }

    public Vector3f getzAxis() {
        return this.zAxis;
    }

    public void setzAxis(Vector3f vector3f) {
        this.zAxis = vector3f;
    }

    public boolean isCorrectCorners() {
        return this.correctCorners;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.center, "center", Vector3f.ZERO);
        outputCapsule.write(this.xAxis, "xAxis", Vector3f.UNIT_X);
        outputCapsule.write(this.yAxis, "yAxis", Vector3f.UNIT_Y);
        outputCapsule.write(this.zAxis, "zAxis", Vector3f.UNIT_Z);
        outputCapsule.write(this.extent, "extent", Vector3f.ZERO);
        outputCapsule.write(this.texTopRight, "texTopRight", new Vector2f(1.0f, 1.0f));
        outputCapsule.write(this.texTopLeft, "texTopLeft", new Vector2f(1.0f, 0.0f));
        outputCapsule.write(this.texBotRight, "texBotRight", new Vector2f(0.0f, 1.0f));
        outputCapsule.write(this.texBotLeft, "texBotLeft", new Vector2f(0.0f, 0.0f));
        outputCapsule.write(this.vectorStore, "vectorStore", new Vector3f[8]);
        outputCapsule.write(this.correctCorners, "correctCorners", false);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.center = (Vector3f)inputCapsule.readSavable("center", Vector3f.ZERO.clone());
        this.xAxis = (Vector3f)inputCapsule.readSavable("xAxis", Vector3f.UNIT_X.clone());
        this.yAxis = (Vector3f)inputCapsule.readSavable("yAxis", Vector3f.UNIT_Y.clone());
        this.zAxis = (Vector3f)inputCapsule.readSavable("zAxis", Vector3f.UNIT_Z.clone());
        this.extent = (Vector3f)inputCapsule.readSavable("extent", Vector3f.ZERO.clone());
        this.texTopRight = (Vector2f)inputCapsule.readSavable("texTopRight", new Vector2f(1.0f, 1.0f));
        this.texTopLeft = (Vector2f)inputCapsule.readSavable("texTopLeft", new Vector2f(1.0f, 0.0f));
        this.texBotRight = (Vector2f)inputCapsule.readSavable("texBotRight", new Vector2f(0.0f, 1.0f));
        this.texBotLeft = (Vector2f)inputCapsule.readSavable("texBotLeft", new Vector2f(0.0f, 0.0f));
        Savable[] savableArray = inputCapsule.readSavableArray("vectorStore", new Vector3f[8]);
        if (savableArray == null) {
            this.vectorStore = null;
        } else {
            this.vectorStore = new Vector3f[savableArray.length];
            for (int i = 0; i < savableArray.length; ++i) {
                this.vectorStore[i] = (Vector3f)savableArray[i];
            }
        }
        this.correctCorners = inputCapsule.readBoolean("correctCorners", false);
    }
}

