/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.FastMath;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;

public class Tube
extends TriMesh
implements Savable {
    private static final long serialVersionUID = 1L;
    private int axisSamples;
    private int radialSamples;
    private float outerRadius;
    private float innerRadius;
    private float height;

    public static long getSerialVersionUID() {
        return 1L;
    }

    public Tube() {
    }

    public Tube(String string, float f, float f2, float f3, int n, int n2) {
        super(string);
        this.outerRadius = f;
        this.innerRadius = f2;
        this.height = f3;
        this.axisSamples = n;
        this.radialSamples = n2;
        this.allocateVertices();
    }

    public Tube(String string, float f, float f2, float f3) {
        this(string, f, f2, f3, 2, 20);
    }

    private void allocateVertices() {
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexCount(2 * (this.axisSamples + 1) * (this.radialSamples + 1) + this.radialSamples * 4);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexBuffer(), triangleBatch.getVertexCount()));
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(triangleBatch.getNormalBuffer(), triangleBatch.getVertexCount()));
        triangleBatch.getTextureBuffers().set(0, BufferUtils.createVector2Buffer(triangleBatch.getVertexCount()));
        triangleBatch.setTriangleQuantity(4 * this.radialSamples * (1 + this.axisSamples));
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(triangleBatch.getIndexBuffer(), 3 * triangleBatch.getTriangleCount()));
        this.setGeometryData();
        this.setIndexData();
    }

    public int getAxisSamples() {
        return this.axisSamples;
    }

    public void setAxisSamples(int n) {
        this.axisSamples = n;
        this.allocateVertices();
    }

    public int getRadialSamples() {
        return this.radialSamples;
    }

    public void setRadialSamples(int n) {
        this.radialSamples = n;
        this.allocateVertices();
    }

    public float getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(float f) {
        this.outerRadius = f;
        this.allocateVertices();
    }

    public float getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(float f) {
        this.innerRadius = f;
        this.allocateVertices();
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float f) {
        this.height = f;
        this.allocateVertices();
    }

    private void setGeometryData() {
        int n;
        TriangleBatch triangleBatch = this.getBatch(0);
        float f = 1.0f / (float)this.radialSamples;
        float f2 = this.height / (float)this.axisSamples;
        float f3 = 1.0f / (float)this.axisSamples;
        float f4 = 0.5f * this.height;
        float f5 = this.innerRadius / this.outerRadius;
        float[] fArray = new float[this.radialSamples];
        float[] fArray2 = new float[this.radialSamples];
        for (n = 0; n < this.radialSamples; ++n) {
            float f6 = (float)Math.PI * 2 * f * (float)n;
            fArray2[n] = FastMath.cos(f6);
            fArray[n] = FastMath.sin(f6);
        }
        for (n = 0; n < this.radialSamples + 1; ++n) {
            for (int i = 0; i < this.axisSamples + 1; ++i) {
                triangleBatch.getVertexBuffer().put(fArray2[n % this.radialSamples] * this.outerRadius).put(f2 * (float)i - f4).put(fArray[n % this.radialSamples] * this.outerRadius);
                triangleBatch.getNormalBuffer().put(fArray2[n % this.radialSamples]).put(0.0f).put(fArray[n % this.radialSamples]);
                triangleBatch.getTextureBuffer(0).put((float)n * f).put(f3 * (float)i);
            }
        }
        for (n = 0; n < this.radialSamples + 1; ++n) {
            for (int i = 0; i < this.axisSamples + 1; ++i) {
                triangleBatch.getVertexBuffer().put(fArray2[n % this.radialSamples] * this.innerRadius).put(f2 * (float)i - f4).put(fArray[n % this.radialSamples] * this.innerRadius);
                triangleBatch.getNormalBuffer().put(-fArray2[n % this.radialSamples]).put(0.0f).put(-fArray[n % this.radialSamples]);
                triangleBatch.getTextureBuffer(0).put((float)n * f).put(f3 * (float)i);
            }
        }
        for (n = 0; n < this.radialSamples; ++n) {
            triangleBatch.getVertexBuffer().put(fArray2[n] * this.outerRadius).put(-f4).put(fArray[n] * this.outerRadius);
            triangleBatch.getVertexBuffer().put(fArray2[n] * this.innerRadius).put(-f4).put(fArray[n] * this.innerRadius);
            triangleBatch.getNormalBuffer().put(0.0f).put(-1.0f).put(0.0f);
            triangleBatch.getNormalBuffer().put(0.0f).put(-1.0f).put(0.0f);
            triangleBatch.getTextureBuffer(0).put(0.5f + 0.5f * fArray2[n]).put(0.5f + 0.5f * fArray[n]);
            triangleBatch.getTextureBuffer(0).put(0.5f + f5 * 0.5f * fArray2[n]).put(0.5f + f5 * 0.5f * fArray[n]);
        }
        for (n = 0; n < this.radialSamples; ++n) {
            triangleBatch.getVertexBuffer().put(fArray2[n] * this.outerRadius).put(f4).put(fArray[n] * this.outerRadius);
            triangleBatch.getVertexBuffer().put(fArray2[n] * this.innerRadius).put(f4).put(fArray[n] * this.innerRadius);
            triangleBatch.getNormalBuffer().put(0.0f).put(1.0f).put(0.0f);
            triangleBatch.getNormalBuffer().put(0.0f).put(1.0f).put(0.0f);
            triangleBatch.getTextureBuffer(0).put(0.5f + 0.5f * fArray2[n]).put(0.5f + 0.5f * fArray[n]);
            triangleBatch.getTextureBuffer(0).put(0.5f + f5 * 0.5f * fArray2[n]).put(0.5f + f5 * 0.5f * fArray[n]);
        }
    }

    private void setIndexData() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        TriangleBatch triangleBatch = this.getBatch(0);
        int n7 = (this.axisSamples + 1) * (this.radialSamples + 1);
        int n8 = 2 * n7;
        int n9 = n8 + 2 * this.radialSamples;
        for (n6 = 0; n6 < this.radialSamples; ++n6) {
            for (n5 = 0; n5 < this.axisSamples; ++n5) {
                n4 = n5 + (this.axisSamples + 1) * n6;
                n3 = n4 + 1;
                n2 = n4 + (this.axisSamples + 1);
                n = n2 + 1;
                triangleBatch.getIndexBuffer().put(n4).put(n3).put(n2);
                triangleBatch.getIndexBuffer().put(n3).put(n).put(n2);
            }
        }
        for (n6 = 0; n6 < this.radialSamples; ++n6) {
            for (n5 = 0; n5 < this.axisSamples; ++n5) {
                n4 = n7 + n5 + (this.axisSamples + 1) * n6;
                n3 = n4 + 1;
                n2 = n4 + (this.axisSamples + 1);
                n = n2 + 1;
                triangleBatch.getIndexBuffer().put(n4).put(n2).put(n3);
                triangleBatch.getIndexBuffer().put(n3).put(n2).put(n);
            }
        }
        for (n6 = 0; n6 < this.radialSamples; ++n6) {
            n5 = n8 + 2 * n6;
            n4 = n5 + 1;
            n3 = n8 + 2 * ((n6 + 1) % this.radialSamples);
            n2 = n3 + 1;
            triangleBatch.getIndexBuffer().put(n5).put(n3).put(n4);
            triangleBatch.getIndexBuffer().put(n4).put(n3).put(n2);
        }
        for (n6 = 0; n6 < this.radialSamples; ++n6) {
            n5 = n9 + 2 * n6;
            n4 = n5 + 1;
            n3 = n9 + 2 * ((n6 + 1) % this.radialSamples);
            n2 = n3 + 1;
            triangleBatch.getIndexBuffer().put(n5).put(n4).put(n3);
            triangleBatch.getIndexBuffer().put(n4).put(n2).put(n3);
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.getAxisSamples(), "axisSamples", 0);
        outputCapsule.write(this.getRadialSamples(), "radialSamples", 0);
        outputCapsule.write(this.getOuterRadius(), "outerRadius", 0.0f);
        outputCapsule.write(this.getInnerRadius(), "innerRadius", 0.0f);
        outputCapsule.write(this.getHeight(), "height", 0.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.setAxisSamples(inputCapsule.readInt("axisSamples", 0));
        this.setRadialSamples(inputCapsule.readInt("radialSamples", 0));
        this.setOuterRadius(inputCapsule.readFloat("outerRadius", 0.0f));
        this.setInnerRadius(inputCapsule.readFloat("innerRadius", 0.0f));
        this.setHeight(inputCapsule.readFloat("height", 0.0f));
    }
}

