/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.editors.swing.particles;

import com.jmex.editors.swing.particles.ParticleEditPanel;
import com.jmex.editors.swing.widget.ValuePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ParticleFlowPanel
extends ParticleEditPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox rateBox;
    private ValuePanel releaseRatePanel = new ValuePanel("Particles per second: ", "", 0, Integer.MAX_VALUE, 1);
    private ValuePanel rateVarPanel = new ValuePanel("Variance: ", "%", 0.0f, 1.0f, 0.01f);
    private JCheckBox spawnBox;

    public ParticleFlowPanel() {
        this.setLayout(new GridBagLayout());
        this.initPanel();
    }

    private void initPanel() {
        this.rateBox = new JCheckBox(new AbstractAction("Regulate Flow"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ParticleFlowPanel.this.getEdittedParticles().getParticleController().setControlFlow(ParticleFlowPanel.this.rateBox.isSelected());
                ParticleFlowPanel.this.updateRateLabels();
            }
        });
        this.releaseRatePanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleFlowPanel.this.getEdittedParticles().setReleaseRate(ParticleFlowPanel.this.releaseRatePanel.getIntValue());
            }
        });
        this.rateVarPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleFlowPanel.this.getEdittedParticles().setReleaseVariance(ParticleFlowPanel.this.rateVarPanel.getFloatValue());
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(this.createTitledBorder("RATE"));
        jPanel.add((Component)this.rateBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.releaseRatePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 10, 5), 0, 0));
        jPanel.add((Component)this.rateVarPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.spawnBox = new JCheckBox(new AbstractAction("Respawn 'dead' particles."){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (ParticleFlowPanel.this.spawnBox.isSelected()) {
                    ParticleFlowPanel.this.getEdittedParticles().getParticleController().setRepeatType(1);
                } else {
                    ParticleFlowPanel.this.getEdittedParticles().getParticleController().setRepeatType(0);
                }
            }
        });
        this.spawnBox.setSelected(true);
        JButton jButton = new JButton(new AbstractAction("Force Respawn"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ParticleFlowPanel.this.getEdittedParticles().forceRespawn();
            }
        });
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(this.createTitledBorder("SPAWN"));
        jPanel2.add((Component)this.spawnBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 10), 0, 0));
        jPanel2.add((Component)jButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 10), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 5, 10), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
    }

    public void updateWidgets() {
        this.rateBox.setSelected(this.getEdittedParticles().getParticleController().isControlFlow());
        this.releaseRatePanel.setValue(this.getEdittedParticles().getReleaseRate());
        this.rateVarPanel.setValue(this.getEdittedParticles().getReleaseVariance());
        this.updateRateLabels();
        this.spawnBox.setSelected(this.getEdittedParticles().getParticleController().getRepeatType() == 1);
    }

    private void updateRateLabels() {
        this.releaseRatePanel.setEnabled(this.rateBox.isSelected());
        this.rateVarPanel.setEnabled(this.rateBox.isSelected());
    }
}

