/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.editors.swing.particles;

import com.jmex.editors.swing.particles.InfluenceEditPanel;
import com.jmex.editors.swing.widget.ValuePanel;
import com.jmex.editors.swing.widget.VectorPanel;
import com.jmex.effects.particles.SwarmInfluence;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SwarmInfluencePanel
extends InfluenceEditPanel {
    private static final long serialVersionUID = 1L;
    private ValuePanel swarmRange = new ValuePanel("Range: ", "", -1.4E-45f, Float.MAX_VALUE, 0.1f);
    private ValuePanel swarmTurnSpeed = new ValuePanel("Turn Speed: ", "", -1.4E-45f, Float.MAX_VALUE, 0.1f);
    private ValuePanel swarmMaxSpeed = new ValuePanel("Max Speed: ", "", -1.4E-45f, Float.MAX_VALUE, 0.1f);
    private ValuePanel swarmAcceleration = new ValuePanel("Acceleration: ", "", -1.4E-45f, Float.MAX_VALUE, 0.1f);
    private ValuePanel swarmDeviance = new ValuePanel("Deviance: ", "", 0.0f, 180.0f, 1.0f);
    private VectorPanel swarmLocationPanel = new VectorPanel(-1.4E-45f, Float.MAX_VALUE, 0.1f);

    public SwarmInfluencePanel() {
        this.setLayout(new GridBagLayout());
        this.initPanel();
    }

    private void initPanel() {
        this.swarmRange.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((SwarmInfluence)SwarmInfluencePanel.this.getEdittedInfluence()).setSwarmRange(SwarmInfluencePanel.this.swarmRange.getFloatValue());
            }
        });
        this.swarmDeviance.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((SwarmInfluence)SwarmInfluencePanel.this.getEdittedInfluence()).setDeviance((float)Math.PI / 180 * SwarmInfluencePanel.this.swarmDeviance.getFloatValue());
            }
        });
        this.swarmMaxSpeed.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((SwarmInfluence)SwarmInfluencePanel.this.getEdittedInfluence()).setMaxSpeed(SwarmInfluencePanel.this.swarmMaxSpeed.getFloatValue());
            }
        });
        this.swarmAcceleration.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((SwarmInfluence)SwarmInfluencePanel.this.getEdittedInfluence()).setSpeedBump(SwarmInfluencePanel.this.swarmAcceleration.getFloatValue());
            }
        });
        this.swarmTurnSpeed.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((SwarmInfluence)SwarmInfluencePanel.this.getEdittedInfluence()).setTurnSpeed(SwarmInfluencePanel.this.swarmTurnSpeed.getFloatValue());
            }
        });
        this.swarmLocationPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((SwarmInfluence)SwarmInfluencePanel.this.getEdittedInfluence()).setSwarmOffset(SwarmInfluencePanel.this.swarmLocationPanel.getValue());
            }
        });
        this.swarmLocationPanel.setBorder(this.createTitledBorder(" SWARM OFFSET "));
        this.setBorder(this.createTitledBorder(" SWARM PARAMETERS "));
        this.add((Component)this.swarmLocationPanel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.add((Component)this.swarmRange, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.add((Component)this.swarmMaxSpeed, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.add((Component)this.swarmAcceleration, new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.add((Component)this.swarmTurnSpeed, new GridBagConstraints(0, 4, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.add((Component)this.swarmDeviance, new GridBagConstraints(0, 5, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
    }

    public void updateWidgets() {
        SwarmInfluence swarmInfluence = (SwarmInfluence)this.getEdittedInfluence();
        this.swarmLocationPanel.setValue(swarmInfluence.getSwarmOffset());
        this.swarmRange.setValue(swarmInfluence.getSwarmRange());
        this.swarmMaxSpeed.setValue(swarmInfluence.getMaxSpeed());
        this.swarmAcceleration.setValue(swarmInfluence.getSpeedBump());
        this.swarmTurnSpeed.setValue(swarmInfluence.getTurnSpeed());
        this.swarmDeviance.setValue(swarmInfluence.getDeviance() * 57.295776f);
    }
}

