/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.xml.types;

import com.jmex.xml.types.SchemaCalendarBase;
import com.jmex.xml.types.SchemaDate;
import com.jmex.xml.types.SchemaDateTime;
import com.jmex.xml.types.SchemaNormalizedString;
import com.jmex.xml.types.SchemaString;
import com.jmex.xml.types.SchemaTime;
import com.jmex.xml.types.SchemaType;
import com.jmex.xml.types.SchemaTypeCalendar;
import com.jmex.xml.types.StringParseException;
import com.jmex.xml.types.TypesIncompatibleException;
import java.text.DecimalFormat;

public class SchemaDuration
extends SchemaCalendarBase {
    protected boolean bNegative;

    public SchemaDuration() {
        this.setEmpty();
    }

    public SchemaDuration(SchemaDuration schemaDuration) {
        this.year = schemaDuration.year;
        this.month = schemaDuration.month;
        this.day = schemaDuration.day;
        this.hour = schemaDuration.hour;
        this.minute = schemaDuration.minute;
        this.second = schemaDuration.second;
        this.partsecond = schemaDuration.partsecond;
        this.hasTZ = schemaDuration.hasTZ;
        this.offsetTZ = schemaDuration.offsetTZ;
        this.bNegative = schemaDuration.isNegative();
        this.isempty = schemaDuration.isempty;
    }

    public SchemaDuration(int n, int n2, int n3, int n4, int n5, int n6, double d, boolean bl) {
        this.setYear(n);
        this.setMonth(n2);
        this.setDay(n3);
        this.setHour(n4);
        this.setMinute(n5);
        this.setSecond(n6);
        this.setPartSecond(d);
        this.bNegative = bl;
        this.isempty = false;
    }

    public SchemaDuration(String string) {
        this.parse(string);
    }

    public SchemaDuration(SchemaType schemaType) {
        this.assign(schemaType);
    }

    public SchemaDuration(SchemaTypeCalendar schemaTypeCalendar) {
        this.assign(schemaTypeCalendar);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public double getPartSecond() {
        return this.partsecond;
    }

    public int getMillisecond() {
        return (int)Math.round(this.partsecond * 1000.0);
    }

    public boolean isNegative() {
        return this.bNegative;
    }

    public void setYear(int n) {
        this.year = n;
        this.isempty = false;
    }

    public void setMonth(int n) {
        this.month = n;
        this.isempty = false;
    }

    public void setDay(int n) {
        this.day = n;
        this.isempty = false;
    }

    public void setHour(int n) {
        this.hour = n;
        this.isempty = false;
    }

    public void setMinute(int n) {
        this.minute = n;
        this.isempty = false;
    }

    public void setSecond(int n) {
        this.second = n;
        this.isempty = false;
    }

    public void setPartSecond(double d) {
        this.partsecond = d;
        this.isempty = false;
    }

    public void setMillisecond(int n) {
        int n2;
        int n3 = n;
        if (n3 < 0) {
            n2 = n / 1000 + 1;
            n3 = n2 * 1000 + n;
            this.second = !this.bNegative ? (this.second -= n2) : (this.second += n2 - 1);
        }
        if (n3 >= 1000) {
            n2 = n3 / 1000;
            n3 %= 1000;
            this.second = !this.bNegative ? (this.second += n2) : (this.second -= n2);
        }
        this.partsecond = (double)n3 / 1000.0;
        this.isempty = false;
    }

    public void setNegative(boolean bl) {
        this.bNegative = bl;
        this.isempty = false;
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull() || schemaType.isEmpty()) {
            this.setEmpty();
        } else if (schemaType instanceof SchemaDuration) {
            this.setInternalValues(((SchemaDuration)schemaType).year, ((SchemaDuration)schemaType).month, ((SchemaDuration)schemaType).day, ((SchemaDuration)schemaType).hour, ((SchemaDuration)schemaType).minute, ((SchemaDuration)schemaType).second, ((SchemaDuration)schemaType).partsecond, 0, 0);
            this.bNegative = ((SchemaDuration)schemaType).bNegative;
        } else if (schemaType instanceof SchemaString) {
            this.parse(((Object)schemaType).toString());
        } else {
            throw new TypesIncompatibleException(schemaType, this);
        }
    }

    public void setEmpty() {
        this.setInternalValues(0, 0, 0, 0, 0, 0, 0.0, 0, 0);
        this.bNegative = false;
        this.isempty = true;
    }

    public Object clone() {
        return new SchemaDuration(this);
    }

    public String toString() {
        if (this.isempty) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bNegative) {
            stringBuffer.append("-");
        }
        stringBuffer.append("P");
        if (this.year != 0) {
            stringBuffer.append(new DecimalFormat("0").format(this.year));
            stringBuffer.append("Y");
        }
        if (this.month != 0) {
            stringBuffer.append(new DecimalFormat("0").format(this.month));
            stringBuffer.append("M");
        }
        if (this.day != 0) {
            stringBuffer.append(new DecimalFormat("0").format(this.day));
            stringBuffer.append("D");
        }
        if (this.hour != 0 || this.minute != 0 || this.second != 0 || this.partsecond > 0.0) {
            stringBuffer.append("T");
            if (this.hour != 0) {
                stringBuffer.append(new DecimalFormat("0").format(this.hour));
                stringBuffer.append("H");
            }
            if (this.minute != 0) {
                stringBuffer.append(new DecimalFormat("0").format(this.minute));
                stringBuffer.append("M");
            }
            if (this.second != 0) {
                stringBuffer.append(new DecimalFormat("0").format(this.second));
            }
            if (this.partsecond > 0.0 && this.partsecond < 1.0) {
                String string = new DecimalFormat("0.0###############").format(this.partsecond);
                stringBuffer.append(".");
                stringBuffer.append(string.substring(2, string.length()));
            }
            if (this.second != 0 || this.partsecond > 0.0 && this.partsecond < 1.0) {
                stringBuffer.append("S");
            }
        }
        if (stringBuffer.length() == 1) {
            stringBuffer.append("T0S");
        }
        return stringBuffer.toString();
    }

    public boolean booleanValue() {
        return true;
    }

    public void parse(String string) {
        String string2 = SchemaNormalizedString.normalize((byte)3, string);
        if (string2 == null) {
            this.isempty = true;
            return;
        }
        if (string2.length() == 0) {
            this.isempty = true;
            return;
        }
        int n = 0;
        this.bNegative = false;
        this.day = 0;
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
        this.partsecond = 0.0;
        this.month = 0;
        this.year = 0;
        if (string2.charAt(n) == '-') {
            this.bNegative = true;
            ++n;
        }
        if (n == string2.length() || string2.charAt(n) != 'P') {
            throw new StringParseException("Duration must start with P or -P followed by a duration value.", 2);
        }
        ++n;
        int n2 = 0;
        while (n != string2.length()) {
            if (n2 == 8) {
                throw new StringParseException("Extra data after duration value.", 2);
            }
            if (string2.charAt(n) == 'T') {
                if (n2 >= 4) {
                    throw new StringParseException("Multiple Ts inside duration value.", 2);
                }
                n2 = 4;
                ++n;
            }
            if (n2 == 3) {
                throw new StringParseException("Extra data after duration value.", 2);
            }
            if (n == string2.length() || string2.charAt(n) < '0' || string2.charAt(n) > '9') {
                throw new StringParseException("Invalid numeric data in duration value.", 2);
            }
            int n3 = 0;
            int n4 = 0;
            while (n != string2.length() && string2.charAt(n) >= '0' && string2.charAt(n) <= '9') {
                if (n3 >= 100000000) {
                    throw new StringParseException("Numeric overflow in duration value.", 2);
                }
                n3 = n3 * 10 + (string2.charAt(n) - 48);
                ++n4;
                ++n;
            }
            if (n == string2.length()) {
                throw new StringParseException("Duration value missing component designator.", 2);
            }
            int n5 = 8;
            switch (string2.charAt(n)) {
                case 'Y': {
                    if (n2 >= 4) {
                        n5 = 8;
                        break;
                    }
                    n5 = 0;
                    break;
                }
                case 'M': {
                    if (n2 >= 4) {
                        n5 = 5;
                        break;
                    }
                    n5 = 1;
                    break;
                }
                case 'D': {
                    if (n2 >= 4) {
                        n5 = 8;
                        break;
                    }
                    n5 = 2;
                    break;
                }
                case 'H': {
                    if (n2 >= 4) {
                        n5 = 4;
                        break;
                    }
                    n5 = 8;
                    break;
                }
                case 'S': {
                    if (n2 >= 7) {
                        n5 = 7;
                        break;
                    }
                    if (n2 >= 4) {
                        n5 = 6;
                        break;
                    }
                    n5 = 8;
                    break;
                }
                case '.': {
                    n5 = n2 >= 4 ? 6 : 8;
                }
            }
            if (n5 == 8 || n5 < n2) {
                throw new StringParseException("Invalid or duplicate component designator.", 2);
            }
            ++n;
            switch (n5) {
                case 0: {
                    this.year = n3;
                    break;
                }
                case 1: {
                    this.month = n3;
                    break;
                }
                case 2: {
                    this.day = n3;
                    break;
                }
                case 4: {
                    this.hour = n3;
                    break;
                }
                case 5: {
                    this.minute = n3;
                    break;
                }
                case 6: {
                    this.second = n3;
                    break;
                }
                case 7: {
                    this.partsecond = (double)n3 * Math.pow(0.1, n4);
                }
            }
            n2 = n5 + 1;
        }
        if (n2 == 0) {
            throw new StringParseException("No components given after P in duration value.", 2);
        }
        this.isempty = false;
    }

    public int calendarType() {
        return 0;
    }

    public SchemaDuration durationValue() {
        return new SchemaDuration(this);
    }

    public SchemaDateTime dateTimeValue() {
        throw new TypesIncompatibleException(this, new SchemaDateTime("2003-07-28T12:00:00"));
    }

    public SchemaDate dateValue() {
        throw new TypesIncompatibleException(this, new SchemaDate("2003-07-28"));
    }

    public SchemaTime timeValue() {
        throw new TypesIncompatibleException(this, new SchemaTime("12:00:00"));
    }

    public long getDayTimeValue() {
        int n = this.bNegative ? -1 : 1;
        return (long)(((double)((((long)this.day * 24L + (long)this.hour) * 60L + (long)this.minute) * 60L + (long)this.second) + this.partsecond) * 1000.0) * (long)n;
    }

    public int getYearMonthValue() {
        int n = this.bNegative ? -1 : 1;
        return (this.year * 12 + this.month) * n;
    }

    public void setYearMonthValue(int n) {
        if (n < 0) {
            this.bNegative = true;
            n = -n;
        } else {
            this.bNegative = false;
        }
        this.year = n / 12;
        this.month = n % 12;
    }

    public void setDayTimeValue(long l) {
        if (l < 0L) {
            this.bNegative = true;
            l = -l;
        } else {
            this.bNegative = false;
        }
        this.day = (int)(l / 86400000L);
        this.hour = (int)((l %= 86400000L) / 3600000L);
        this.minute = (int)((l %= 3600000L) / 60000L);
        this.second = (int)((l %= 60000L) / 1000L);
        this.partsecond = (double)(l %= 1000L) / 1000.0;
    }
}

