/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.collada;

import com.jme.app.SimpleHeadlessApp;
import com.jme.scene.Spatial;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.resource.ResourceLocator;
import com.jme.util.resource.ResourceLocatorTool;
import com.jme.util.resource.SimpleResourceLocator;
import com.jmex.model.collada.ColladaImporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ColladaToJme
extends SimpleHeadlessApp {
    private static final Logger logger = Logger.getLogger(ColladaToJme.class.getName());
    Spatial collada;
    static String in;
    static String outDir;

    public static void main(String[] stringArray) {
        if (stringArray.length < 3 || stringArray.length > 3) {
            logger.info("USAGE: ColladaToJme <COLLADA File> <Texture Directory> <Jme File>");
            System.exit(1);
        }
        in = stringArray[0];
        String string2 = stringArray[1];
        outDir = stringArray[2];
        ResourceLocatorTool.addResourceLocator((String)"texture", (ResourceLocator)new SimpleResourceLocator(new File(string2).toURI()));
        File file = new File(outDir);
        if (!file.exists()) {
            file.mkdir();
        }
        ColladaToJme colladaToJme = new ColladaToJme();
        colladaToJme.start();
    }

    protected void simpleInitGame() {
        long l = System.nanoTime();
        this.writeFile(in);
        this.finished = true;
        long l2 = System.nanoTime();
        logger.info("Conversion took: " + (l2 - l) / 1000000000L + " seconds.");
    }

    protected void writeFile(String string2) {
        File file = new File(string2);
        if (file.isDirectory()) {
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            logger.info(string2 + " is a Directory, getting subfiles: ");
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                logger.info("Sending: " + string2 + stringArray[i]);
                this.writeFile(string2 + stringArray[i]);
            }
            return;
        }
        if (file.getName().toUpperCase().endsWith(".DAE")) {
            this.collada = null;
            System.gc();
            logger.info("Found Collada file, converting: " + string2);
            String string3 = outDir + file.getName().substring(0, file.getName().toUpperCase().indexOf(".DAE")) + ".jme";
            logger.info("Storing as: " + string3);
            String string4 = file.getName().substring(0, file.getName().indexOf("."));
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.log(Level.WARNING, "Error creating FileInputStream", fileNotFoundException);
            }
            if (fileInputStream == null) {
                logger.info("Unable to find file");
                System.exit(0);
            }
            try {
                ColladaImporter.load(fileInputStream, string4);
                this.collada = ColladaImporter.getModel();
                ColladaImporter.cleanUp();
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Error loading Collada file", exception);
            }
            this.collada.updateGeometricState(0.0f, true);
            this.collada.updateRenderState();
            try {
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                BinaryExporter.getInstance().save((Savable)this.collada, file2);
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "Error saving Collada file", iOException);
            }
        }
    }
}

