/*
 * Decompiled with CFR 0.152.
 */
package md5reader;

import com.jme.image.Texture;
import com.jme.util.TextureManager;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.net.URLClassLoader;
import md5reader.MD5SimpleShader;
import model.Shader;
import model.SimpleSkin;
import util.file.FileUtils;

public class MD5DefaultSkin
extends SimpleSkin
implements Externalizable {
    public static final int DEFAULT = 0;
    public static final int DETAIL = 1;
    public static final int NORMAL = 2;
    private static final String[] TYPESUFFIX = new String[]{"", "", ""};
    private String[] prefixes = new String[]{"", "", ""};
    private String[] suffixes = new String[]{".png", ".png", ".png"};
    private ClassLoader classLoader;

    public void setPrefix(int type, String prefix) {
        this.prefixes[type] = prefix;
    }

    public void setSuffix(int type, String suffix) {
        this.suffixes[type] = suffix;
    }

    private String name(String name, int type, int suffixType) {
        name = name.concat(TYPESUFFIX[suffixType]);
        return MD5DefaultSkin.str(this.prefixes[type]) + name + MD5DefaultSkin.str(this.suffixes[type]);
    }

    private static String str(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    private Texture loadTexture(String path, int type, boolean fallback) throws IOException {
        URL url = this.getResource(this.name(path, type, type));
        if (url == null && fallback) {
            url = this.getResource(this.name(path, type, 0));
        }
        if (url == null && (url = this.getResource(this.name(path, 0, type))) == null && fallback) {
            url = this.getResource(this.name(path, 0, 0));
        }
        if (url == null) {
            return null;
        }
        return TextureManager.loadTexture((URL)url, (int)6, (int)1);
    }

    protected URL getResource(String name) throws IOException {
        if (this.classLoader != null) {
            return this.classLoader.getResource(name);
        }
        File file = new File(name);
        if (file.isFile()) {
            return file.toURL();
        }
        return null;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Shader getShader(String meshName) {
        Shader shader = super.getShader(meshName);
        if (shader == null && (shader = this.loadShader(meshName)) != null) {
            this.setShader(meshName, shader);
        }
        return shader;
    }

    private Shader loadShader(String meshName) {
        try {
            Texture detail = this.loadTexture(meshName, 1, true);
            if (detail != null) {
                Texture normal = this.loadTexture(meshName, 2, false);
                if (normal == null) {
                    return new MD5SimpleShader(detail);
                }
                return new MD5SimpleShader(detail);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        FileUtils.checkVersionByte(in, 1, 1);
        this.classLoader = new URLClassLoader((URL[])in.readObject());
        this.prefixes = (String[])in.readObject();
        this.suffixes = (String[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(((URLClassLoader)this.classLoader).getURLs());
        out.writeObject(this.prefixes);
        out.writeObject(this.suffixes);
    }
}

