/*
 * Decompiled with CFR 0.152.
 */
package md5reader;

import com.jme.math.Vector2f;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import md5reader.AbstractD3Reader;
import md5reader.MD5DefaultSkin;
import model.Mesh;
import model.Model;
import model.SkeletalKeyFrame;
import model.SkeletalModel;
import model.Skeleton;
import model.WeightedMesh;
import model.animation.AnimationUtils;
import model.file.ModelReader;

public class MD5MeshReader
extends AbstractD3Reader
implements ModelReader {
    public static final String CLASSLOADER = "skin.classloader";
    public static final String DEFAULT_PREFIX = "skin.defaultprefix";
    public static final String DEFAULT_SUFFIX = "skin.defaultsuffix";
    public static final String DETAIL_PREFIX = "skin.detail.prefix";
    public static final String DETAIL_SUFFIX = "skin.detail.suffix";
    private SkeletalModel model;

    @Override
    public void setProperty(String name, Object value) {
        if (this.model == null) {
            this.model = new SkeletalModel("MD5Model", 0, new MD5DefaultSkin());
        }
        if (name.equals(CLASSLOADER)) {
            ((MD5DefaultSkin)this.model.getDefaultSkin()).setClassLoader((ClassLoader)value);
        } else if (name.equals(DEFAULT_PREFIX)) {
            ((MD5DefaultSkin)this.model.getDefaultSkin()).setPrefix(0, (String)value);
        } else if (name.equals(DEFAULT_SUFFIX)) {
            ((MD5DefaultSkin)this.model.getDefaultSkin()).setSuffix(0, (String)value);
        } else if (name.equals(DETAIL_PREFIX)) {
            ((MD5DefaultSkin)this.model.getDefaultSkin()).setPrefix(1, (String)value);
        } else if (name.equals(DETAIL_SUFFIX)) {
            ((MD5DefaultSkin)this.model.getDefaultSkin()).setSuffix(1, (String)value);
        }
    }

    @Override
    public Model readModel(InputStream in) throws IOException {
        String text;
        this.setInputStream(in);
        if (this.model == null) {
            this.model = new SkeletalModel("MD5Model", 0, new MD5DefaultSkin());
        }
        int index = 0;
        ArrayList<WeightedMesh> weightedMeshList = new ArrayList<WeightedMesh>();
        while ((text = this.readStringStartOfLine()) != null) {
            if (text.equals("MD5Version")) {
                this.readPositiveInt();
                continue;
            }
            if (text.equals("commandline")) {
                this.skip(3);
                continue;
            }
            if (text.equals("numJoints")) {
                this.model.setSkeleton(new Skeleton(this.readPositiveInt()));
                continue;
            }
            if (text.equals("numMeshes")) {
                this.model.resetMeshCount(this.readPositiveInt());
                continue;
            }
            if (text.equals("joints")) {
                this.skip(6);
                this.loadJoints();
                continue;
            }
            if (text.equals("mesh")) {
                this.skip(6);
                WeightedMesh result = this.loadMesh(index);
                if (result == null) continue;
                weightedMeshList.add(result);
                continue;
            }
            throw new IOException("Unexpected text: " + text);
        }
        this.model.resetMeshCount(weightedMeshList.size());
        for (int i = 0; i < weightedMeshList.size(); ++i) {
            this.model.getMeshes()[i] = (Mesh)weightedMeshList.get(i);
        }
        SkeletalModel retModel = this.model;
        this.model = null;
        return retModel;
    }

    private void loadJoints() throws IOException {
        String text;
        Skeleton skeleton = this.model.getSkeleton();
        int i = 0;
        SkeletalKeyFrame bind = skeleton.getBindFrame();
        while ((text = this.readStringStartOfLine()) != null) {
            skeleton.getJointNames()[i] = text;
            skeleton.getParents()[i] = this.readInt();
            bind.positions[i] = this.readVector3f();
            bind.rotations[i] = this.readQuaternion();
            ++i;
        }
        AnimationUtils.globalToLocal(skeleton);
        int[] parents = skeleton.getParents();
        for (i = 0; i < parents.length; ++i) {
            if (parents[i] >= 0) continue;
            bind.rotations[i].set(BASE.mult(bind.rotations[i]));
        }
    }

    private WeightedMesh loadMesh(int index) throws IOException {
        String text;
        WeightedMesh mesh = new WeightedMesh("Mesh");
        boolean result = true;
        while ((text = this.readStringStartOfLine()) != null) {
            if (text.equals("shader")) {
                String shader = this.readString();
                mesh.setName(shader);
                if (shader.equals("")) {
                    System.out.println("empty shader not accepted of mesh in md5 file.modify it");
                    continue;
                }
                if (!shader.toLowerCase().endsWith(".tga")) continue;
                System.out.println("chop .tga in shader name of mesh in md5 file.modify it");
                continue;
            }
            if (text.equals("numverts")) {
                int vert = this.readPositiveInt();
                if (vert == 0) {
                    System.out.println("empty-mesh:");
                    result = false;
                }
                mesh.resetVertexCount(vert);
                continue;
            }
            if (text.equals("numtris")) {
                mesh.resetTriangleCount(this.readPositiveInt());
                continue;
            }
            if (text.equals("numweights")) {
                mesh.resetWeightCount(this.readPositiveInt());
                continue;
            }
            if (text.equals("vert")) {
                int i = this.readPositiveInt();
                mesh.getVertexTextureCoords((int)0)[i] = this.invert(this.readVector2f());
                mesh.getVertexFirstWeight()[i] = this.readPositiveInt();
                mesh.getVertexWeightCount()[i] = this.readPositiveInt();
                continue;
            }
            if (text.equals("tri")) {
                int i = this.readPositiveInt() * 3;
                mesh.getTriangleCornerArray()[i] = this.readPositiveInt();
                mesh.getTriangleCornerArray()[i + 2] = this.readPositiveInt();
                mesh.getTriangleCornerArray()[i + 1] = this.readPositiveInt();
                continue;
            }
            if (text.equals("weight")) {
                int i = this.readPositiveInt();
                mesh.getWeightJoint()[i] = this.readPositiveInt();
                mesh.getWeightWeight()[i] = this.readFloat();
                mesh.getWeightOffset()[i] = this.readVector3f();
                continue;
            }
            throw new IOException("Unexpected text: " + text);
        }
        if (result) {
            mesh.updateTriangleCorners();
            mesh.updateTextureBuffer(0);
            return mesh;
        }
        return null;
    }

    private Vector2f invert(Vector2f vec) {
        vec.y = 1.0f - vec.y;
        return vec;
    }
}

