/*
 * Decompiled with CFR 0.152.
 */
package md5reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

class MD5Scanner {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    private static final String ZZ_CMAP_PACKED = "\u0001\u0002\b\u0000\u0001\u0002\u0001\u0001\u0002\u0002\u0001\u0001\u0012\u0000\u0001\u0002\u0001\t\u0001\u0005\u0002\u0000\u0002\t\u0001\u0000\u0001\r\u0001\u000e\u0001\u0004\u0002\t\u0001\u0006\u0001\b\u0001\u0003\n\n\u0001\u0007\u0001\u0000\u0003\t\u0002\u0000\u001d\t\u0001\u0000\u0001\t\u0001\u0000\u001a\t\u0001\u000b\u0001\u0000\u0001\f\uff82\u0000";
    private static final char[] ZZ_CMAP = MD5Scanner.zzUnpackCMap("\u0001\u0002\b\u0000\u0001\u0002\u0001\u0001\u0002\u0002\u0001\u0001\u0012\u0000\u0001\u0002\u0001\t\u0001\u0005\u0002\u0000\u0002\t\u0001\u0000\u0001\r\u0001\u000e\u0001\u0004\u0002\t\u0001\u0006\u0001\b\u0001\u0003\n\n\u0001\u0007\u0001\u0000\u0003\t\u0002\u0000\u001d\t\u0001\u0000\u0001\t\u0001\u0000\u001a\t\u0001\u000b\u0001\u0000\u0001\f\uff82\u0000");
    private static final int[] ZZ_ACTION = MD5Scanner.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0001\u0001\u0002\u0002\u0002\u0003\u0001\u0001\u0001\u0003\u0001\u0001\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\u0002\u0001\u0003\u0001\u0000\u0001\t\u0001\u0000\u0001\n\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0002";
    private static final int[] ZZ_ROWMAP = MD5Scanner.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u000f\u0000\u001e\u0000\u000f\u0000-\u0000<\u0000K\u0000Z\u0000i\u0000x\u0000\u000f\u0000\u000f\u0000\u000f\u0000\u000f\u0000\u0087\u0000\u0096\u0000K\u0000\u000f\u0000i\u0000i\u0000\u00a5\u0000\u00b4\u0000\u00c3\u0000<";
    private static final int[] ZZ_TRANS = MD5Scanner.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\u0006\u0001\t\u0001\u0006\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0010\u0000\u0001\u0003\u0010\u0000\u0001\u000f\u0001\u0010\u0003\u0000\u0003\u0006\u0007\u0000\u0002\u0006\u0003\u0000\u0003\u0006\u0004\u0000\u0001\u0011\u0001\u0000\u0003\u0011\u0001\u0012\t\u0011\u0003\u0000\u0002\u0006\u0002\u0000\u0001\u0006\u0001\u0013\u0001\u0006\u0001\n\u000e\u0000\u0001\u0014\f\u0000\u0001\u0013\u0001\u0000\u0001\n\u0004\u0000\u0001\u000f\u0001\u0000\r\u000f\u0003\u0015\u0001\u0010\u0001\u0016\u0003\u0015\u0003\u0010\b\u0015\u0001\u0017\r\u0015\u0001\u0018\u0001\u0016\u0003\u0015\u0003\u0010\u0007\u0015\u0001\u0004\u0001\u0017\n\u0015";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = MD5Scanner.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\u0001\t\u0001\u0001\u0001\t\u0006\u0001\u0004\t\u0002\u0001\u0001\u0000\u0001\t\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean isString = false;

    private static int[] zzUnpackAction() {
        int[] result = new int[24];
        int offset = 0;
        offset = MD5Scanner.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[24];
        int offset = 0;
        offset = MD5Scanner.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[210];
        int offset = 0;
        offset = MD5Scanner.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[24];
        int offset = 0;
        offset = MD5Scanner.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public String asString() {
        String text = this.yytext();
        if (this.isString) {
            text = text.substring(1, text.length() - 1);
        }
        return text;
    }

    public float asFloat() {
        return Float.parseFloat(this.yytext());
    }

    public int asInt() {
        return Integer.parseInt(this.yytext());
    }

    public int getLine() {
        return this.yyline + 1;
    }

    MD5Scanner(Reader in) {
        this.zzReader = in;
    }

    MD5Scanner(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 68) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += numRead;
        return false;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public int nextToken() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block26: while (true) {
            int zzInput;
            int zzCurrentPosL;
            int zzMarkedPosL = this.zzMarkedPos;
            boolean zzR = false;
            block27: for (zzCurrentPosL = this.zzStartRead; zzCurrentPosL < zzMarkedPosL; ++zzCurrentPosL) {
                switch (zzBufferL[zzCurrentPosL]) {
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        ++this.yyline;
                        zzR = false;
                        continue block27;
                    }
                    case '\r': {
                        ++this.yyline;
                        zzR = true;
                        continue block27;
                    }
                    case '\n': {
                        if (zzR) {
                            zzR = false;
                            continue block27;
                        }
                        ++this.yyline;
                        continue block27;
                    }
                    default: {
                        zzR = false;
                    }
                }
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    boolean eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzLexicalState;
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 9: {
                    this.isString = true;
                    return 3;
                }
                case 11: {
                    continue block26;
                }
                case 8: {
                    return 5;
                }
                case 12: {
                    continue block26;
                }
                case 5: {
                    return 6;
                }
                case 13: {
                    continue block26;
                }
                case 4: {
                    return 2;
                }
                case 14: {
                    continue block26;
                }
                case 6: {
                    return 7;
                }
                case 15: {
                    continue block26;
                }
                case 10: {
                    return 1;
                }
                case 16: {
                    continue block26;
                }
                case 1: {
                    throw new IOException("Unknown character: <" + this.yytext() + "> (" + this.yytext().charAt(0) + ") at line " + (this.yyline + 1));
                }
                case 17: {
                    continue block26;
                }
                case 7: {
                    return 4;
                }
                case 18: {
                    continue block26;
                }
                case 3: {
                    this.isString = false;
                    return 3;
                }
                case 19: {
                    continue block26;
                }
                case 2: 
                case 20: {
                    continue block26;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzReader.close();
                return 0;
            }
            this.zzScanError(1);
        }
    }
}

